/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp;

import com.sun.jdmk.internal.snmp.SnmpTools;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.management.snmp.SnmpOid;

public class SnmpEngineId
implements Serializable {
    byte[] engineId = null;
    String hexString = null;
    String humanString = null;

    SnmpEngineId(String string) {
        this.engineId = SnmpTools.ascii2binary(string);
        this.hexString = string.toLowerCase();
    }

    SnmpEngineId(byte[] byArray) {
        this.engineId = byArray;
        this.hexString = SnmpTools.binary2ascii(byArray).toLowerCase();
    }

    public String getReadableId() {
        return this.humanString;
    }

    public String toString() {
        return this.hexString;
    }

    public byte[] getBytes() {
        return this.engineId;
    }

    void setStringValue(String string) {
        this.humanString = string;
    }

    static void validateId(String string) throws IllegalArgumentException {
        byte[] byArray = SnmpTools.ascii2binary(string);
        SnmpEngineId.validateId(byArray);
    }

    static void validateId(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length < 5) {
            throw new IllegalArgumentException("Id size lower than 5 bytes.");
        }
        if (byArray.length > 32) {
            throw new IllegalArgumentException("Id size greater than 32 bytes.");
        }
        if ((byArray[0] & 0x80) == 0 && byArray.length != 12) {
            throw new IllegalArgumentException("Very first bit = 0 and length != 12 octets");
        }
        byte[] byArray2 = new byte[byArray.length];
        if (Arrays.equals(byArray2, byArray)) {
            throw new IllegalArgumentException("Zeroed Id.");
        }
        byte[] byArray3 = new byte[byArray.length];
        Arrays.fill(byArray3, (byte)-1);
        if (Arrays.equals(byArray3, byArray)) {
            throw new IllegalArgumentException("0xFF Id.");
        }
    }

    public static SnmpEngineId createEngineId(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        SnmpEngineId.validateId(byArray);
        return new SnmpEngineId(byArray);
    }

    public static SnmpEngineId createEngineId() {
        Object var0 = null;
        byte[] byArray = new byte[13];
        int n = 42;
        long l = 255L;
        long l2 = System.currentTimeMillis();
        byArray[0] = (byte)((n & 0xFF000000) >> 24);
        byArray[0] = (byte)(byArray[0] | 0x80);
        byArray[1] = (byte)((n & 0xFF0000) >> 16);
        byArray[2] = (byte)((n & 0xFF00) >> 8);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = 5;
        byArray[5] = (byte)((l2 & l << 56) >>> 56);
        byArray[6] = (byte)((l2 & l << 48) >>> 48);
        byArray[7] = (byte)((l2 & l << 40) >>> 40);
        byArray[8] = (byte)((l2 & l << 32) >>> 32);
        byArray[9] = (byte)((l2 & l << 24) >>> 24);
        byArray[10] = (byte)((l2 & l << 16) >>> 16);
        byArray[11] = (byte)((l2 & l << 8) >>> 8);
        byArray[12] = (byte)(l2 & l);
        return new SnmpEngineId(byArray);
    }

    public SnmpOid toOid() {
        long[] lArray = new long[this.engineId.length + 1];
        lArray[0] = this.engineId.length;
        int n = 1;
        while (n <= this.engineId.length) {
            lArray[n] = this.engineId[n - 1] & 0xFF;
            ++n;
        }
        return new SnmpOid(lArray);
    }

    public static SnmpEngineId createEngineId(String string) throws IllegalArgumentException, UnknownHostException {
        if (string == null) {
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            SnmpEngineId.validateId(string);
            return new SnmpEngineId(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 161;
        int n2 = 42;
        InetAddress inetAddress = null;
        SnmpEngineId snmpEngineId = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Passed string is invalid : [" + string + "]");
        }
        if (!string2.equals(":")) {
            inetAddress = InetAddress.getByName(string2);
            try {
                stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
                snmpEngineId.setStringValue(string);
                return snmpEngineId;
            }
        } else {
            inetAddress = InetAddress.getLocalHost();
        }
        try {
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
            snmpEngineId.setStringValue(string);
            return snmpEngineId;
        }
        if (!string3.equals(":")) {
            n = Integer.parseInt(string3);
            try {
                stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
                snmpEngineId.setStringValue(string);
                return snmpEngineId;
            }
        }
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
            snmpEngineId.setStringValue(string);
            return snmpEngineId;
        }
        if (!string4.equals(":")) {
            n2 = Integer.parseInt(string4);
        }
        snmpEngineId = SnmpEngineId.createEngineId(inetAddress, n, n2);
        snmpEngineId.setStringValue(string);
        return snmpEngineId;
    }

    public static SnmpEngineId createEngineId(int n) throws UnknownHostException {
        int n2 = 42;
        InetAddress inetAddress = null;
        inetAddress = InetAddress.getLocalHost();
        return SnmpEngineId.createEngineId(inetAddress, n, n2);
    }

    public static SnmpEngineId createEngineId(InetAddress inetAddress, int n) throws IllegalArgumentException {
        int n2 = 42;
        if (inetAddress == null) {
            throw new IllegalArgumentException("InetAddress is null.");
        }
        return SnmpEngineId.createEngineId(inetAddress, n, n2);
    }

    public static SnmpEngineId createEngineId(int n, int n2) throws UnknownHostException {
        InetAddress inetAddress = null;
        inetAddress = InetAddress.getLocalHost();
        return SnmpEngineId.createEngineId(inetAddress, n, n2);
    }

    public static SnmpEngineId createEngineId(InetAddress inetAddress, int n, int n2) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("InetAddress is null.");
        }
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[13];
        byArray2[0] = (byte)((n2 & 0xFF000000) >> 24);
        byArray2[0] = (byte)(byArray2[0] | 0x80);
        byArray2[1] = (byte)((n2 & 0xFF0000) >> 16);
        byArray2[2] = (byte)((n2 & 0xFF00) >> 8);
        byArray2[3] = (byte)(n2 & 0xFF);
        byArray2[4] = 5;
        int n3 = 0;
        while (n3 < 4) {
            byArray2[n3 + 5] = byArray[n3];
            ++n3;
        }
        byArray2[9] = (byte)((n & 0xFF000000) >> 24);
        byArray2[10] = (byte)((n & 0xFF0000) >> 16);
        byArray2[11] = (byte)((n & 0xFF00) >> 8);
        byArray2[12] = (byte)(n & 0xFF);
        return new SnmpEngineId(byArray2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpEngineId)) {
            return false;
        }
        return this.hexString.equals(((SnmpEngineId)object).toString());
    }

    public int hashCode() {
        return this.hexString.hashCode();
    }
}

