/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tasks;

import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class DaemonTaskServer
implements TaskServer {
    private final Daemon daemon = new Daemon();
    private transient boolean on = false;
    private transient boolean isRunning = false;
    private transient boolean terminating = false;
    private transient LinkedList list = new LinkedList();
    private transient Thread thread = null;
    private transient long sequenceNumber = 0L;
    private static int count = 0;

    private synchronized void running() {
        this.isRunning = true;
    }

    private synchronized void stopped() {
        this.isRunning = false;
        this.thread = null;
    }

    private synchronized boolean isRunning() {
        return this.isRunning;
    }

    private synchronized boolean isOn() {
        return this.on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        try {
            this.running();
            while (this.isOn()) {
                try {
                    Task task = this.nextTask();
                    if (task == null) continue;
                    this.execute(task);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Object var4_4 = null;
            this.stopped();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stopped();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Task nextTask() throws InterruptedException {
        try {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                Task task = (Task)this.list.removeFirst();
                return task;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.wait();
            try {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    Task task = (Task)this.list.removeFirst();
                    return task;
                }
            }
            catch (NoSuchElementException noSuchElementException2) {
                return null;
            }
        }
    }

    protected void execute(Task task) throws InterruptedException {
        task.run();
    }

    protected void cancel(Task task) throws InterruptedException {
        task.cancel();
    }

    public synchronized void submitTask(Task task) {
        if (this.terminating) {
            throw new IllegalStateException("Task Server Terminated");
        }
        if (task == null) {
            return;
        }
        this.list.addLast(task);
        this.wakethread();
    }

    private final synchronized void wakethread() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Thread thread;
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            if (!this.isOn() && this.thread == null) {
                return;
            }
            thread = this.thread;
            this.on = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        if (thread != null && Thread.currentThread() != thread) {
            thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isListEmpty() {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            boolean bl = this.list.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws InterruptedException {
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            this.terminating = true;
        }
        this.stop();
        DaemonTaskServer daemonTaskServer2 = this;
        synchronized (daemonTaskServer2) {
            while (!this.isListEmpty()) {
                try {
                    Task task;
                    LinkedList linkedList = this.list;
                    synchronized (linkedList) {
                        task = (Task)this.list.removeFirst();
                    }
                    this.cancel(task);
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        if (this.isOn() || this.isRunning()) {
            throw new IllegalStateException("Must be stopped in order to reset");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
        this.terminating = false;
    }

    public void start() {
        this.start(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n) {
        Thread thread;
        DaemonTaskServer daemonTaskServer = this;
        synchronized (daemonTaskServer) {
            if (this.terminating) {
                throw new IllegalStateException("Task Server Terminated");
            }
            if (this.isOn()) {
                return;
            }
            this.on = true;
            thread = this.thread = new Thread((Runnable)this.daemon, "DaemonTaskServer(" + count++ + ")");
            thread.setDaemon(true);
            thread.setPriority(n);
        }
        thread.start();
    }

    private final class Daemon
    implements Runnable {
        private Daemon() {
        }

        public void run() {
            DaemonTaskServer.this.run();
        }
    }
}

