/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.snmp.usm.SnmpUsmEnginePeer;
import com.sun.jdmk.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.jdmk.trace.Trace;
import javax.management.snmp.SnmpSecurityException;
import javax.management.snmp.SnmpStatusException;

class SnmpUsmTimelinessModule {
    private SnmpUsmExceptionGenerator gen = null;
    private int timeWindow = 150;
    String dbgTag = "SnmpUsmTimelinessModule";

    SnmpUsmTimelinessModule(SnmpUsmExceptionGenerator snmpUsmExceptionGenerator) {
        this.gen = snmpUsmExceptionGenerator;
    }

    void handleResponseTimeliness(SnmpUsmEnginePeer snmpUsmEnginePeer, SnmpUsmSecurityParameters snmpUsmSecurityParameters) throws SnmpSecurityException {
        if (snmpUsmEnginePeer.getAuthoritativeEngineTime() == 0 && snmpUsmEnginePeer.getAuthoritativeEngineBoots() == 0) {
            if (this.isTraceOn()) {
                this.trace("handleResponseTimeliness", "Update time and boot: " + snmpUsmSecurityParameters.getAuthoritativeEngineTime() + ":" + snmpUsmSecurityParameters.getAuthoritativeEngineBoots());
            }
            snmpUsmEnginePeer.setAuthoritativeEngineTime(snmpUsmSecurityParameters.getAuthoritativeEngineTime());
            snmpUsmEnginePeer.setAuthoritativeEngineBoots(snmpUsmSecurityParameters.getAuthoritativeEngineBoots());
            snmpUsmEnginePeer.setAuthoritativeEngineLastReceivedTime(snmpUsmSecurityParameters.getAuthoritativeEngineTime());
            return;
        }
        int n = snmpUsmSecurityParameters.getAuthoritativeEngineTime();
        int n2 = snmpUsmSecurityParameters.getAuthoritativeEngineBoots();
        if (n == 0 && n2 == 0) {
            if (this.isTraceOn()) {
                this.trace("handleResponseTimeliness", "Received 0:0 value from an engineId discovery, ignoring it");
            }
            return;
        }
        int n3 = snmpUsmEnginePeer.getAuthoritativeEngineTime();
        int n4 = snmpUsmEnginePeer.getAuthoritativeEngineBoots();
        int n5 = snmpUsmEnginePeer.getAuthoritativeLastReceivedEngineTime();
        if (this.isTraceOn()) {
            this.trace("handleResponseTimeliness", "Local values time:boot: latestTime " + n3 + ":" + n4 + ":" + n5 + "\n" + "Received values time:boot: " + n + ":" + n2);
        }
        if (n2 > n4 || n2 == n4 && n > n5) {
            if (this.isTraceOn()) {
                this.trace("handleResponseTimeliness", "Timeliness succeeded, updating values.");
            }
            snmpUsmEnginePeer.setAuthoritativeEngineTime(n);
            snmpUsmEnginePeer.setAuthoritativeEngineBoots(n2);
            snmpUsmEnginePeer.setAuthoritativeEngineLastReceivedTime(n);
            return;
        }
        if (n2 == Integer.MAX_VALUE) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException("Received engine nb boots is 0x7FFFFFFF. Authoritative engine Id [" + snmpUsmEnginePeer.authoritativeEngineId + "] needs to be manually reconfigured!");
            snmpSecurityException.status = 248;
            throw snmpSecurityException;
        }
        if (n4 > n2) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException("Received engine nb boots is smaller than the local notion. The authoritative engine has been reconfigured. Reject the response!");
            snmpSecurityException.status = 248;
            throw snmpSecurityException;
        }
        if (n4 == n2 && n < n3 - this.getTimelinessWindow()) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException("Received an engine time that is not in the right time frame. Reject the response!");
            snmpSecurityException.status = 248;
            throw snmpSecurityException;
        }
    }

    void handleTimeliness(SnmpEngineImpl snmpEngineImpl, SnmpUsmSecurityParameters snmpUsmSecurityParameters) throws SnmpSecurityException, SnmpStatusException {
        int n = snmpUsmSecurityParameters.getAuthoritativeEngineTime();
        int n2 = snmpUsmSecurityParameters.getAuthoritativeEngineBoots();
        if (n == 0 && n2 == 0) {
            snmpUsmSecurityParameters.setAuthoritativeEngineTime(snmpEngineImpl.getEngineTime());
            snmpUsmSecurityParameters.setAuthoritativeEngineBoots(snmpEngineImpl.getEngineBoots());
            if (this.isTraceOn()) {
                this.trace("handleTimeliness", "Boot time discovery. Sending engine boot: " + snmpUsmSecurityParameters.getAuthoritativeEngineBoots() + ", engine time: " + snmpUsmSecurityParameters.getAuthoritativeEngineTime());
            }
            this.gen.genTimeWindowException(null, null, (byte)5, snmpUsmSecurityParameters);
        }
        if (n2 == Integer.MAX_VALUE || n2 != snmpEngineImpl.getEngineBoots()) {
            if (this.isTraceOn()) {
                this.trace("handleTimeliness", "Invalid boots: Received boot: " + n2 + ", Local engine boot: " + snmpEngineImpl.getEngineBoots());
            }
            this.gen.genTimeWindowException(null, null, (byte)5, snmpUsmSecurityParameters);
        }
        if (Math.abs(n - snmpEngineImpl.getEngineTime()) > this.getTimelinessWindow()) {
            if (this.isTraceOn()) {
                this.trace("handleTimeliness", "Invalid time: Received time: " + n + ", Local engine time: " + snmpEngineImpl.getEngineTime());
            }
            this.gen.genTimeWindowException(null, null, (byte)5, snmpUsmSecurityParameters);
        }
    }

    synchronized int getTimelinessWindow() {
        return this.timeWindow;
    }

    synchronized void setTimelinessWindow(int n) {
        this.timeWindow = n;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

