/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.snmp.usm.SnmpUsmSecurityParameters;
import javax.management.snmp.BerDecoder;
import javax.management.snmp.BerEncoder;
import javax.management.snmp.BerException;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;

class SnmpUsmSecurityParametersImpl
implements SnmpUsmSecurityParameters {
    private SnmpEngineId authoritativeEngineId = null;
    private int authoritativeEngineBoots = 0;
    private int authoritativeEngineTime = 0;
    private String userName = null;
    private byte[] authParameters = null;
    private byte[] privParameters = null;

    public String getPrincipal() {
        return this.getUserName();
    }

    public SnmpEngineId getAuthoritativeEngineId() {
        return this.authoritativeEngineId;
    }

    public void setAuthoritativeEngineId(SnmpEngineId snmpEngineId) {
        this.authoritativeEngineId = snmpEngineId;
    }

    public int getAuthoritativeEngineBoots() {
        return this.authoritativeEngineBoots;
    }

    public void setAuthoritativeEngineBoots(int n) {
        this.authoritativeEngineBoots = n;
    }

    public int getAuthoritativeEngineTime() {
        return this.authoritativeEngineTime;
    }

    public void setAuthoritativeEngineTime(int n) {
        this.authoritativeEngineTime = n;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public byte[] getAuthParameters() {
        return this.authParameters;
    }

    public void setAuthParameters(byte[] byArray) {
        this.authParameters = byArray;
    }

    public byte[] getPrivParameters() {
        return this.privParameters;
    }

    public void setPrivParameters(byte[] byArray) {
        this.privParameters = byArray;
    }

    public SnmpUsmSecurityParametersImpl() {
    }

    public SnmpUsmSecurityParametersImpl(SnmpEngineId snmpEngineId, int n, int n2, String string, byte[] byArray, byte[] byArray2) {
        this.authoritativeEngineId = snmpEngineId;
        this.authoritativeEngineBoots = n;
        this.authoritativeEngineTime = n2;
        this.userName = string;
        this.authParameters = byArray;
        this.privParameters = byArray2;
    }

    public SnmpUsmSecurityParametersImpl(SnmpUsmSecurityParameters snmpUsmSecurityParameters) {
        this.authoritativeEngineId = snmpUsmSecurityParameters.getAuthoritativeEngineId();
        this.authoritativeEngineBoots = snmpUsmSecurityParameters.getAuthoritativeEngineBoots();
        this.authoritativeEngineTime = snmpUsmSecurityParameters.getAuthoritativeEngineTime();
        this.userName = snmpUsmSecurityParameters.getUserName();
    }

    public void decode(byte[] byArray) throws SnmpStatusException {
        try {
            BerDecoder berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            this.authoritativeEngineId = SnmpEngineId.createEngineId(berDecoder.fetchOctetString());
            this.authoritativeEngineBoots = berDecoder.fetchInteger();
            this.authoritativeEngineTime = berDecoder.fetchInteger();
            this.userName = new String(berDecoder.fetchOctetString());
            this.authParameters = berDecoder.fetchOctetString();
            this.privParameters = berDecoder.fetchOctetString();
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid security parameters Ber encoding.");
        }
    }

    public String toString() {
        return (this.authoritativeEngineId != null ? this.authoritativeEngineId.toString() : "<unknown engine id>") + " : " + (this.userName != null ? this.userName : "<unknown user>") + ":" + this.authoritativeEngineBoots + ":" + this.authoritativeEngineTime + ":" + this.authParameters + ":" + this.privParameters;
    }

    public int encode(byte[] byArray) throws SnmpTooBigException {
        int n = 0;
        try {
            BerEncoder berEncoder = new BerEncoder(byArray);
            berEncoder.openSequence();
            berEncoder.putOctetString(this.privParameters != null ? this.privParameters : new byte[]{});
            berEncoder.putOctetString(this.authParameters != null ? this.authParameters : new byte[]{});
            berEncoder.putOctetString(this.userName != null ? this.userName.getBytes() : new byte[]{});
            berEncoder.putInteger(this.authoritativeEngineTime);
            berEncoder.putInteger(this.authoritativeEngineBoots);
            if (this.authoritativeEngineId != null) {
                berEncoder.putOctetString(this.authoritativeEngineId.getBytes() != null ? this.authoritativeEngineId.getBytes() : new byte[]{});
            } else {
                berEncoder.putOctetString(new byte[0]);
            }
            berEncoder.closeSequence();
            n = berEncoder.trim();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
        return n;
    }
}

