/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.internal.snmp.SnmpDecryptedPdu;
import com.sun.jdmk.internal.snmp.SnmpEncryptionPair;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.snmp.SnmpUnknownMsgProcModelException;
import com.sun.jdmk.snmp.usm.SnmpUserSecurityModel;
import com.sun.jdmk.snmp.usm.SnmpUsmEngineIdException;
import com.sun.jdmk.snmp.usm.SnmpUsmException;
import com.sun.jdmk.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.jdmk.snmp.usm.SnmpUsmLcd;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivException;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivPair;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityCache;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.jdmk.snmp.usm.SnmpUsmUserNameException;
import com.sun.jdmk.trace.Trace;
import javax.management.snmp.SnmpSecurityException;
import javax.management.snmp.SnmpStatusException;

class SnmpUsmPrivModule {
    SnmpUserSecurityModel model = null;
    SnmpUsmLcd lcd = null;
    SnmpUsmExceptionGenerator genExp = null;
    String dbgTag = "SnmpUsmPrivModule";

    SnmpUsmPrivModule(SnmpUserSecurityModel snmpUserSecurityModel, SnmpUsmLcd snmpUsmLcd, SnmpUsmExceptionGenerator snmpUsmExceptionGenerator) {
        this.model = snmpUserSecurityModel;
        this.lcd = snmpUsmLcd;
        this.genExp = snmpUsmExceptionGenerator;
    }

    SnmpDecryptedPdu decrypt(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, int n, SnmpUsmSecurityParameters snmpUsmSecurityParameters, SnmpUsmSecurityCache snmpUsmSecurityCache, byte[] byArray, byte by) throws SnmpSecurityException, SnmpStatusException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.decrypt(snmpUsmSecurityCache, snmpUsmSecurityParameters, byArray);
            return snmpMsgProcessingSubSystem.decode(n, byArray2);
        }
        catch (SnmpUsmPrivException snmpUsmPrivException) {
            if (this.isDebugOn()) {
                this.debug("decrypt", snmpUsmPrivException.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmPrivAlgorithmException snmpUsmPrivAlgorithmException) {
            if (this.isDebugOn()) {
                this.debug("decrypt", snmpUsmPrivAlgorithmException.toString());
            }
            this.genExp.genSecurityLevelException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmUserNameException snmpUsmUserNameException) {
            if (this.isDebugOn()) {
                this.debug("decrypt", snmpUsmUserNameException.toString());
            }
            this.genExp.genUserNameException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmEngineIdException snmpUsmEngineIdException) {
            this.genExp.genEngineIdException(null, null, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmException snmpUsmException) {
            if (this.isDebugOn()) {
                this.debug("decrypt", snmpUsmException.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (this.isDebugOn()) {
                this.debug("decrypt", snmpUnknownMsgProcModelException.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("decrypt", exception.toString());
            }
            this.genExp.genDecryptionException(by, snmpUsmSecurityParameters);
        }
        return null;
    }

    private byte[] decrypt(SnmpUsmSecurityCache snmpUsmSecurityCache, SnmpUsmSecurityParameters snmpUsmSecurityParameters, byte[] byArray) throws SnmpUsmException {
        SnmpUsmPrivPair snmpUsmPrivPair = null;
        if (this.isTraceOn()) {
            this.trace("decrypt", " userName : " + snmpUsmSecurityParameters.getUserName());
        }
        snmpUsmPrivPair = this.lcd.getUserPrivPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName());
        if (snmpUsmSecurityCache != null) {
            snmpUsmSecurityCache.priv = snmpUsmPrivPair;
        }
        SnmpEncryptionPair snmpEncryptionPair = new SnmpEncryptionPair();
        snmpEncryptionPair.encryptedData = byArray;
        snmpEncryptionPair.parameters = snmpUsmSecurityParameters.getPrivParameters();
        byte[] byArray2 = snmpUsmPrivPair.algo.decrypt(snmpUsmPrivPair.key, snmpEncryptionPair);
        return byArray2;
    }

    byte[] encrypt(SnmpUsmSecurityCache snmpUsmSecurityCache, SnmpUsmSecurityParameters snmpUsmSecurityParameters, byte[] byArray, int n) throws SnmpUsmException {
        SnmpUsmPrivPair snmpUsmPrivPair = null;
        if (this.isTraceOn()) {
            this.trace("encrypt", " userName : " + snmpUsmSecurityParameters.getUserName());
        }
        if (snmpUsmSecurityCache != null) {
            if (snmpUsmSecurityCache.priv != null) {
                snmpUsmPrivPair = snmpUsmSecurityCache.priv;
            } else {
                snmpUsmSecurityCache.priv = snmpUsmPrivPair = this.lcd.getUserPrivPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName());
            }
        } else {
            snmpUsmPrivPair = this.lcd.getUserPrivPair(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getUserName());
        }
        SnmpEncryptionPair snmpEncryptionPair = snmpUsmPrivPair.algo.encrypt(snmpUsmPrivPair.key, byArray, n);
        snmpUsmSecurityParameters.setPrivParameters(snmpEncryptionPair.parameters);
        return snmpEncryptionPair.encryptedData;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

