/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.internal.snmp.SnmpLcd;
import com.sun.jdmk.internal.snmp.SnmpPersistRowFile;
import com.sun.jdmk.internal.snmp.SnmpPersistRowFileConsumer;
import com.sun.jdmk.internal.snmp.SnmpSubSystem;
import com.sun.jdmk.internal.snmp.SnmpTools;
import com.sun.jdmk.snmp.usm.LcdEngine;
import com.sun.jdmk.snmp.usm.SecurityConfException;
import com.sun.jdmk.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.jdmk.snmp.usm.SnmpUsmAuthAlgorithm;
import com.sun.jdmk.snmp.usm.SnmpUsmAuthAlgorithmException;
import com.sun.jdmk.snmp.usm.SnmpUsmAuthPair;
import com.sun.jdmk.snmp.usm.SnmpUsmEngineIdException;
import com.sun.jdmk.snmp.usm.SnmpUsmException;
import com.sun.jdmk.snmp.usm.SnmpUsmLcd;
import com.sun.jdmk.snmp.usm.SnmpUsmMibTable;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivPair;
import com.sun.jdmk.snmp.usm.SnmpUsmSecureUser;
import com.sun.jdmk.snmp.usm.SnmpUsmSecureUserImpl;
import com.sun.jdmk.snmp.usm.SnmpUsmUserNameException;
import com.sun.jdmk.trace.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineId;

public class SnmpUsmPasswordLcd
implements SnmpUsmLcd {
    static final int USER_ENGINEID = 0;
    static final int USER_NAME = 1;
    static final int USER_SECURITY_NAME = 2;
    static final int USER_AUTH_PROTOCOL = 3;
    static final int USER_AUTH_PASSWORD = 4;
    static final int USER_PRIV_PROTOCOL = 5;
    static final int USER_PRIV_PASSWORD = 6;
    static final int USER_STORAGE_TYPE = 7;
    static final int USER_TEMPLATE = 8;
    UsmConsumer consumer;
    SnmpPersistRowFile file;
    boolean strictParsing;
    Hashtable engines;
    SnmpUsmAlgorithmManager algos;
    LcdEngine localEngine;
    SnmpEngine engine;
    SnmpUsmMibTable table;
    boolean sync;
    boolean syncDone;
    String dbgTag;

    public SnmpUsmPasswordLcd(SnmpEngine snmpEngine, SnmpSubSystem snmpSubSystem, SnmpLcd snmpLcd, String string) throws IllegalArgumentException {
        block6: {
            this.consumer = null;
            this.file = null;
            this.strictParsing = true;
            this.engines = new Hashtable();
            this.algos = null;
            this.localEngine = null;
            this.engine = null;
            this.table = null;
            this.sync = false;
            this.syncDone = false;
            this.dbgTag = "SnmpUsmPasswordLcd";
            this.engine = snmpEngine;
            snmpLcd.addModelLcd(snmpSubSystem, 3, this);
            this.consumer = new UsmConsumer(this);
            String string2 = this.handleSecurityFileLocation(string);
            if (string2 != null) {
                try {
                    this.file = new SnmpPersistRowFile(string2, "userEntry", ",", this.consumer);
                    if (this.strictParsing) {
                        this.file.enableException(true);
                    }
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.isDebugOn()) {
                        this.debug("SnmpUsmPasswordLcd", "Exception :" + illegalArgumentException.toString());
                    }
                    break block6;
                }
            }
            if (this.isDebugOn()) {
                this.debug("SnmpUsmPasswordLcd", "No configuration file provided.");
            }
        }
        this.localEngine = new LcdEngine(snmpEngine.getEngineId());
        this.engines.put(snmpEngine.getEngineId().toString(), this.localEngine);
    }

    public void enableStrictParsing(boolean bl) {
        this.strictParsing = bl;
    }

    public void setUserAuthKeyChange(SnmpUsmSecureUser snmpUsmSecureUser, byte[] byArray) {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)snmpUsmSecureUser;
        snmpUsmSecureUserImpl.setAuthKeyChange(byArray);
    }

    public void setUserPrivKeyChange(SnmpUsmSecureUser snmpUsmSecureUser, byte[] byArray) {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)snmpUsmSecureUser;
        snmpUsmSecureUserImpl.setPrivKeyChange(byArray);
    }

    public void addUser(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        this.insertUser(snmpUsmSecureUser.getEngineId(), snmpUsmSecureUser, bl);
    }

    public SnmpUsmSecureUser createNewUser(byte[] byArray, String string) {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = new SnmpUsmSecureUserImpl(this, SnmpEngineId.createEngineId(byArray), string);
        return snmpUsmSecureUserImpl;
    }

    public int getStorageType() {
        if (this.file != null) {
            return 3;
        }
        return 2;
    }

    public void setMibTable(SnmpUsmMibTable snmpUsmMibTable) {
        this.table = snmpUsmMibTable;
    }

    public synchronized void addEngine(SnmpEngineId snmpEngineId) {
    }

    public void setAlgorithmManager(SnmpUsmAlgorithmManager snmpUsmAlgorithmManager) {
        this.algos = snmpUsmAlgorithmManager;
    }

    public SnmpUsmSecureUser getUser(SnmpEngineId snmpEngineId, String string) throws SnmpUsmEngineIdException, SnmpUsmUserNameException {
        return this.findUser(snmpEngineId, string);
    }

    public synchronized void syncDataSource() throws IllegalArgumentException {
        if (this.syncDone) {
            return;
        }
        this.sync = true;
        if (this.getStorageType() == 3) {
            this.readFile();
        }
        this.sync = false;
        this.syncDone = true;
    }

    public SnmpUsmAlgorithmManager getAlgorithmManager() {
        return this.algos;
    }

    public synchronized SnmpUsmPrivPair getUserPrivPair(SnmpEngineId snmpEngineId, String string) throws SnmpUsmPrivAlgorithmException, SnmpUsmEngineIdException, SnmpUsmUserNameException {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = null;
        snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)this.findUser(snmpEngineId, string);
        SnmpUsmPrivAlgorithm snmpUsmPrivAlgorithm = snmpUsmSecureUserImpl.getPrivPair().algo;
        if (snmpUsmPrivAlgorithm == null) {
            throw new SnmpUsmPrivAlgorithmException("User: " + snmpUsmSecureUserImpl.getName() + " No Priv algorithm");
        }
        return snmpUsmSecureUserImpl.getPrivPair();
    }

    public synchronized SnmpUsmAuthPair getUserAuthPair(SnmpEngineId snmpEngineId, String string) throws SnmpUsmAuthAlgorithmException, SnmpUsmEngineIdException, SnmpUsmUserNameException {
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = null;
        snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)this.findUser(snmpEngineId, string);
        SnmpUsmAuthAlgorithm snmpUsmAuthAlgorithm = snmpUsmSecureUserImpl.getAuthPair().algo;
        if (snmpUsmAuthAlgorithm == null) {
            throw new SnmpUsmAuthAlgorithmException("User: " + snmpUsmSecureUserImpl.getName() + " No Auth algorithm");
        }
        return snmpUsmSecureUserImpl.getAuthPair();
    }

    public synchronized void addUser(SnmpEngineId snmpEngineId, String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) throws SnmpUsmException {
        try {
            this.translateAndInsert(snmpEngineId, snmpEngineId.getReadableId() == null ? snmpEngineId.toString() : snmpEngineId.getReadableId(), string, string2, string3, string4, string5, string6, n, bl);
        }
        catch (SecurityConfException securityConfException) {
            throw new SnmpUsmException(securityConfException.getMessage());
        }
    }

    public synchronized Enumeration getAllUsers() {
        Vector<SnmpUsmSecureUser> vector = new Vector<SnmpUsmSecureUser>();
        Enumeration enumeration = this.engines.elements();
        while (enumeration.hasMoreElements()) {
            LcdEngine lcdEngine = (LcdEngine)enumeration.nextElement();
            Enumeration enumeration2 = lcdEngine.users.elements();
            while (enumeration2.hasMoreElements()) {
                SnmpUsmSecureUser snmpUsmSecureUser = (SnmpUsmSecureUser)enumeration2.nextElement();
                vector.add(snmpUsmSecureUser);
            }
        }
        return vector.elements();
    }

    private String handleSecurityFileLocation(String string) throws IllegalArgumentException {
        String string2 = null;
        File file = null;
        if (string == null) {
            string2 = System.getProperty("jdmk.security.file");
            if (string2 == null) {
                if (this.isDebugOn()) {
                    this.debug("handleSecurityFileLocation", "Security file not found. Use default one.");
                }
                if (!(file = new File(string2 = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.security"))).exists()) {
                    file = null;
                    if (this.isTraceOn()) {
                        this.trace("handleSecurityFileLocation", "The default file [" + string2 + "] doesn't exist.");
                    }
                    return null;
                }
                return string2;
            }
            file = new File(string2);
            if (!file.exists()) {
                if (this.isTraceOn()) {
                    this.trace("handleSecurityFileLocation", "The specified file [" + file + "] doesn't exist, no configuration loaded");
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist, no configuration loaded");
            }
            return string2;
        }
        file = new File(string);
        if (!file.exists()) {
            if (this.isTraceOn()) {
                this.trace("handleSecurityFileLocation", "The specified file [" + file + "] doesn't exist, no configuration loaded");
            }
            throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist, no configuration loaded");
        }
        return string;
    }

    private void sendNewUserEvent(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.table != null) {
            this.table.userAdded(snmpUsmSecureUser);
        }
    }

    private void sendUpdateUserEvent(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.table != null) {
            this.table.userUpdated(snmpUsmSecureUser);
        }
    }

    private void sendRemoveUserEvent(SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.table != null) {
            this.table.userRemoved(snmpUsmSecureUser);
        }
    }

    public synchronized void removeUser(SnmpEngineId snmpEngineId, String string, boolean bl) {
        LcdEngine lcdEngine = (LcdEngine)this.engines.get(snmpEngineId.toString());
        if (lcdEngine == null) {
            return;
        }
        SnmpUsmSecureUser snmpUsmSecureUser = lcdEngine.removeSecureUser(string);
        if (snmpUsmSecureUser != null) {
            if (this.getStorageType() == 3) {
                this.flushFile();
            }
            this.sendRemoveUserEvent(snmpUsmSecureUser, bl);
        }
    }

    private synchronized void insertUser(SnmpEngineId snmpEngineId, SnmpUsmSecureUser snmpUsmSecureUser, boolean bl) {
        SnmpUsmSecureUser snmpUsmSecureUser2;
        LcdEngine lcdEngine = (LcdEngine)this.engines.get(snmpEngineId.toString());
        if (lcdEngine == null) {
            if (this.isDebugOn()) {
                this.debug("insertUser", " New engine Id");
            }
            lcdEngine = new LcdEngine(snmpEngineId);
            this.engines.put(snmpEngineId.toString(), lcdEngine);
        }
        if (this.isDebugOn()) {
            this.debug("insertUser", " engine id : " + lcdEngine.engineId);
        }
        if (this.isDebugOn()) {
            this.debug("insertUser", " Inserting a new User [" + snmpUsmSecureUser.getName() + "]" + ", engineId [" + snmpEngineId + "], notif flag : " + bl);
        }
        if ((snmpUsmSecureUser2 = lcdEngine.addSecureUser(snmpUsmSecureUser)) != null) {
            if (this.isDebugOn()) {
                this.debug("insertUser", " It is an update");
            }
            this.sendUpdateUserEvent(snmpUsmSecureUser, bl);
        } else {
            if (this.isDebugOn()) {
                this.debug("insertUser", " It is a new user");
            }
            this.sendNewUserEvent(snmpUsmSecureUser, bl);
        }
        if (!this.sync && this.getStorageType() == 3) {
            this.flushFile();
        }
    }

    private synchronized SnmpUsmSecureUser findUser(SnmpEngineId snmpEngineId, String string) throws SnmpUsmEngineIdException, SnmpUsmUserNameException {
        if (this.isTraceOn()) {
            this.trace("findUser", "Engine Id : " + snmpEngineId + "/" + snmpEngineId.hashCode() + "     user Name : " + string);
        }
        LcdEngine lcdEngine = (LcdEngine)this.engines.get(snmpEngineId.toString());
        SnmpUsmSecureUser snmpUsmSecureUser = null;
        if (string == null) {
            if (this.isDebugOn()) {
                this.debug("findUser", "Username : [" + string + "] NULL.");
            }
            throw new SnmpUsmUserNameException("User " + string + " unknown.");
        }
        if (lcdEngine == null) {
            if (this.isDebugOn()) {
                this.debug("findUser", "Engine Id [" + snmpEngineId.toString() + "] unknown.");
            }
            throw new SnmpUsmEngineIdException("Unknown engine Id : " + snmpEngineId.toString());
        }
        if (this.isTraceOn()) {
            this.trace("findUser", "EXISTS. Engine Id : " + lcdEngine.engineId.toString());
        }
        if ((snmpUsmSecureUser = lcdEngine.getSecureUser(string)) == null) {
            if (this.isDebugOn()) {
                this.debug("findUser", "Username : [" + string + "] unknown.");
            }
            throw new SnmpUsmUserNameException("User " + string + " unknown.");
        }
        if (this.isTraceOn()) {
            this.trace("findUser", "Known engine Id [" + lcdEngine.engineId.toString() + " ] and user Name [" + snmpUsmSecureUser.getName() + "]");
        }
        return snmpUsmSecureUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void flushFile() {
        Object object;
        FileWriter fileWriter = null;
        if (this.isDebugOn()) {
            this.debug("flushFile", "Flushing file");
        }
        try {
            fileWriter = this.file.createWriter();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!this.isDebugOn()) return;
            this.debug("flushFile", "No configuration file. Will not persist data");
            return;
        }
        catch (IOException iOException) {
            if (!this.isDebugOn()) return;
            this.debug("flushFile", "Error when opening file");
            return;
        }
        try {
            object = this.engine.getEngineId();
            this.file.write(fileWriter, "localEngineID", (((SnmpEngineId)object).getReadableId() == null ? ((SnmpEngineId)object).toString() : ((SnmpEngineId)object).getReadableId()) + "\n");
            this.file.write(fileWriter, "localEngineBoots", this.engine.getEngineBoots() + 1 + "\n\n");
        }
        catch (IOException iOException) {
            if (!this.isDebugOn()) return;
            this.debug("flushFile", iOException);
            return;
        }
        object = this.engines.elements();
        while (object.hasMoreElements()) {
            LcdEngine lcdEngine = (LcdEngine)object.nextElement();
            lcdEngine.storeUsers(this.engine.getEngineId(), fileWriter, this.file);
        }
        try {
            try {
                this.file.releaseWriter(fileWriter);
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("flushFile", "Error when closing file");
                }
                Object var5_9 = null;
                try {}
                catch (IOException iOException2) {
                    if (!this.isDebugOn()) return;
                    this.debug("flushFile", iOException2);
                    return;
                }
                fileWriter.close();
                return;
            }
            Object var5_8 = null;
            try {
                fileWriter.close();
                return;
            }
            catch (IOException iOException) {
                if (!this.isDebugOn()) return;
                this.debug("flushFile", iOException);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            try {}
            catch (IOException iOException) {
                if (!this.isDebugOn()) return;
                this.debug("flushFile", iOException);
                return;
            }
            fileWriter.close();
            throw throwable;
        }
    }

    private synchronized void readFile() {
        block4: {
            try {
                this.file.read();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("readFile", "No configuration file. Will not read or persist data");
                }
            }
            catch (IOException iOException) {
                if (!this.isDebugOn()) break block4;
                this.debug("readFile", "IO error :" + iOException);
            }
        }
    }

    private String strContext(int n) {
        switch (n) {
            case 1: {
                return "user name";
            }
            case 0: {
                return "user engine id";
            }
            case 3: {
                return "user auth protocol";
            }
            case 2: {
                return "user security name";
            }
            case 4: {
                return "user auth password";
            }
            case 6: {
                return "user priv key";
            }
            case 5: {
                return "user priv protocol";
            }
            case 7: {
                return "user storage type";
            }
        }
        return "unknown parameter";
    }

    private synchronized void translateAndInsert(SnmpEngineId snmpEngineId, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, boolean bl) throws SecurityConfException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        SnmpUsmAuthAlgorithm snmpUsmAuthAlgorithm = null;
        SnmpUsmPrivAlgorithm snmpUsmPrivAlgorithm = null;
        if (string2 == null) {
            throw new IllegalArgumentException("Missing user.");
        }
        if (string4 != null && !string4.equals("usmNoAuthProtocol") && (snmpUsmAuthAlgorithm = (SnmpUsmAuthAlgorithm)this.algos.getAlgorithm(string4)) == null) {
            String string8 = "Unknown authentication algorithm : [" + string4 + "]";
            throw new IllegalArgumentException(string8);
        }
        if (string5 != null && string5.startsWith("0x")) {
            try {
                byArray = SnmpTools.ascii2binary(string5);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException(throwable.getMessage());
            }
            if (this.isTraceOn()) {
                this.trace("translateAndInsert", "auth Key : [" + SnmpTools.binary2ascii(byArray) + "]");
            }
        }
        if (string6 != null && !string6.equals("usmNoPrivProtocol") && (snmpUsmPrivAlgorithm = (SnmpUsmPrivAlgorithm)this.algos.getAlgorithm(string6)) == null) {
            String string9 = "Unknown privacy algorithm : [" + string6 + "]";
            throw new IllegalArgumentException(string9);
        }
        if (string7 != null && string7.startsWith("0x")) {
            try {
                byArray2 = SnmpTools.ascii2binary(string7);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException(throwable.getMessage());
            }
            if (this.isTraceOn()) {
                this.trace("translateAndInsert", "priv Key : [" + SnmpTools.binary2ascii(byArray2) + "]");
            }
        }
        if (string5 != null && byArray == null && snmpUsmAuthAlgorithm != null) {
            byArray = snmpUsmAuthAlgorithm.password_to_key(string5);
            if (this.isTraceOn()) {
                this.trace("translateAndInsert", "auth Key : [" + SnmpTools.binary2ascii(byArray) + "]");
            }
        }
        if (byArray != null && snmpUsmAuthAlgorithm != null && !string5.startsWith("0x")) {
            byArray = snmpUsmAuthAlgorithm.localizeAuthKey(byArray, snmpEngineId);
            if (this.isTraceOn()) {
                this.trace("translateAndInsert", "auth KUL : [" + SnmpTools.binary2ascii(byArray) + "]");
            }
        }
        if (string7 != null && byArray2 == null && snmpUsmPrivAlgorithm != null) {
            if (snmpUsmAuthAlgorithm == null) {
                throw new IllegalArgumentException("Translating priv password to priv key but auth algo is null");
            }
            byArray2 = snmpUsmAuthAlgorithm.password_to_key(string7);
            if (this.isTraceOn()) {
                this.trace("translateAndInsert", "priv Key : [" + SnmpTools.binary2ascii(byArray2) + "]");
            }
        }
        if (byArray2 != null && snmpUsmPrivAlgorithm != null && !string7.startsWith("0x")) {
            if (snmpUsmAuthAlgorithm == null) {
                throw new IllegalArgumentException("Localizing priv key but auth algo is null");
            }
            byArray2 = snmpUsmAuthAlgorithm.localizePrivKey(byArray2, snmpEngineId, snmpUsmPrivAlgorithm.getKeySize());
            if (this.isTraceOn()) {
                this.trace("translateAndInsert", "priv KUL : [" + SnmpTools.binary2ascii(byArray2) + "]");
            }
        }
        SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = new SnmpUsmSecureUserImpl(this, snmpEngineId, string, string2, string3, snmpUsmAuthAlgorithm, string4, byArray, string5, snmpUsmPrivAlgorithm, string6, byArray2, string7, n, bl);
        this.insertUser(snmpEngineId, snmpUsmSecureUserImpl, true);
    }

    private synchronized SnmpEngineId translateEngineId(String string) throws SecurityConfException {
        SnmpEngineId snmpEngineId = null;
        int n = string.indexOf("0x");
        if (n == -1 && !string.equals("localEngineID")) {
            try {
                snmpEngineId = SnmpEngineId.createEngineId(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unknown host : " + unknownHostException.getMessage());
            }
            if (this.isTraceOn()) {
                this.trace("translateEngineId", "Caculate engine Id from : " + string + "\tResulting Id : " + snmpEngineId);
            }
        } else if (!string.equals("localEngineID") && !string.equals(this.engine.getEngineId().toString())) {
            try {
                snmpEngineId = SnmpEngineId.createEngineId(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unknown host : " + unknownHostException.getMessage());
            }
        } else {
            snmpEngineId = this.engine.getEngineId();
        }
        return snmpEngineId;
    }

    void endRow(DataUser dataUser, String string, int n) throws Exception {
        int n2;
        block7: {
            n2 = 0;
            if (dataUser.storageType != null) {
                try {
                    n2 = Integer.parseInt(dataUser.storageType);
                    if (n2 != 3) {
                        throw new IllegalArgumentException("Illegal storage type : " + n2);
                    }
                    break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.getMessage());
                }
            }
            n2 = 3;
        }
        SnmpEngineId snmpEngineId = this.translateEngineId(dataUser.strEngineId);
        try {
            this.findUser(snmpEngineId, dataUser.name);
            throw new IllegalArgumentException("Already defined user");
        }
        catch (SnmpUsmException snmpUsmException) {
            boolean bl = false;
            if (dataUser.template != null && dataUser.template.equals("true")) {
                bl = true;
            }
            this.translateAndInsert(snmpEngineId, dataUser.strEngineId, dataUser.name, dataUser.securityName, dataUser.authProtocol, dataUser.authPassword, dataUser.privProtocol, dataUser.privPassword, n2, bl);
            return;
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }

    class UsmConsumer
    implements SnmpPersistRowFileConsumer {
        DataUser user;
        SnmpUsmPasswordLcd usmlcd;

        UsmConsumer(SnmpUsmPasswordLcd snmpUsmPasswordLcd2) {
            this.user = new DataUser();
            this.usmlcd = null;
            this.usmlcd = snmpUsmPasswordLcd2;
        }

        public Object rowBegin(String string, int n) {
            this.user.reset();
            return this.user;
        }

        public void rowEnd(Object object, String string, int n) throws Exception {
            DataUser dataUser = (DataUser)object;
            this.usmlcd.endRow(dataUser, string, n);
        }

        public void treatToken(String string, int n, String string2, int n2, Object object, boolean bl) throws Exception {
            DataUser dataUser = (DataUser)object;
            switch (n2) {
                case 0: {
                    if (bl || string2 == null) {
                        throw new IllegalArgumentException("Missing engine Id.");
                    }
                    if (SnmpUsmPasswordLcd.this.isTraceOn()) {
                        SnmpUsmPasswordLcd.this.trace("treatToken", "context = " + SnmpUsmPasswordLcd.this.strContext(n2) + " value : " + string2);
                    }
                    dataUser.strEngineId = string2;
                    break;
                }
                case 1: {
                    if (bl || string2 == null) {
                        throw new IllegalArgumentException("Missing user.");
                    }
                    if (SnmpUsmPasswordLcd.this.isTraceOn()) {
                        SnmpUsmPasswordLcd.this.trace("treatToken", "context = " + SnmpUsmPasswordLcd.this.strContext(n2) + " value : " + string2);
                    }
                    dataUser.name = string2;
                    break;
                }
                case 2: {
                    if (bl) {
                        return;
                    }
                    dataUser.securityName = string2;
                    break;
                }
                case 3: {
                    if (bl) {
                        return;
                    }
                    dataUser.authProtocol = string2;
                    break;
                }
                case 4: {
                    if (bl) {
                        return;
                    }
                    dataUser.authPassword = string2;
                    break;
                }
                case 5: {
                    if (bl) {
                        return;
                    }
                    dataUser.privProtocol = string2;
                    break;
                }
                case 6: {
                    if (bl) {
                        return;
                    }
                    dataUser.privPassword = string2;
                    break;
                }
                case 7: {
                    if (bl) {
                        return;
                    }
                    dataUser.storageType = string2;
                    break;
                }
                case 8: {
                    if (bl) {
                        return;
                    }
                    dataUser.template = string2;
                    break;
                }
                default: {
                    if (SnmpUsmPasswordLcd.this.isDebugOn()) {
                        SnmpUsmPasswordLcd.this.debug("TreatToken", "Unknown context.");
                    }
                    throw new IllegalArgumentException("Unknown parameter");
                }
            }
        }
    }

    class DataUser {
        String strEngineId = null;
        String name = null;
        String authPassword = null;
        String privPassword = null;
        String securityName = null;
        String authProtocol = null;
        String privProtocol = null;
        String storageType = null;
        String template = null;

        DataUser() {
        }

        void reset() {
            this.strEngineId = null;
            this.name = null;
            this.authPassword = null;
            this.privPassword = null;
            this.securityName = null;
            this.authProtocol = null;
            this.privProtocol = null;
            this.storageType = null;
            this.template = null;
        }
    }
}

