/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.snmp.usm.SnmpUsmAlgorithmImpl;
import com.sun.jdmk.snmp.usm.SnmpUsmAuthAlgorithm;
import com.sun.jdmk.trace.Trace;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.management.snmp.SnmpEngineId;

public abstract class SnmpUsmHmacAlgorithm
extends SnmpUsmAlgorithmImpl
implements SnmpUsmAuthAlgorithm {
    String mdName = null;
    MessageDigest innerMD = null;
    MessageDigest md = null;
    String dbgTag = "SnmpUsmHmacAlgorithm";

    protected SnmpUsmHmacAlgorithm(String string, String string2) {
        super(string);
        this.mdName = string2;
        try {
            this.innerMD = MessageDigest.getInstance(string2);
            this.md = MessageDigest.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (this.isDebugOn()) {
                this.debug("SnmpUsmHmacAlgorithm", noSuchAlgorithmException);
            }
            throw new IllegalArgumentException(noSuchAlgorithmException.getMessage());
        }
    }

    abstract int getBlockSize();

    abstract int getKeySize();

    public abstract int getDeltaSize();

    abstract int getPasswordToKeySize();

    /*
     * Unable to fully structure code
     */
    public byte[] sign(byte[] var1_1, byte[] var2_2, int var3_3) {
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var8_8 = var1_1.length;
        var7_7 = this.getBlockSize();
        if (var8_8 > var7_7) {
            this.md.reset();
            this.md.update(var1_1);
            var1_1 = this.md.digest();
            var8_8 = var1_1.length;
        }
        var5_5 = new byte[var7_7];
        var6_6 = new byte[var7_7];
        var9_9 = 0;
        ** GOTO lbl23
        {
            var5_5[var9_9] = var1_1[var9_9];
            var6_6[var9_9] = var1_1[var9_9];
            ++var9_9;
            do {
                if (var9_9 < var1_1.length) continue block0;
                var5_5[var9_9] = 0;
                var6_6[var9_9] = 0;
                ++var9_9;
lbl23:
                // 2 sources

            } while (var9_9 < var7_7);
        }
        var10_10 = 0;
        while (var10_10 < 64) {
            v0 = var10_10;
            var5_5[v0] = (byte)(var5_5[v0] ^ 54);
            v1 = var10_10++;
            var6_6[v1] = (byte)(var6_6[v1] ^ 92);
        }
        this.innerMD.reset();
        this.innerMD.update(var5_5);
        this.innerMD.update(var2_2, 0, var3_3);
        var4_4 = this.innerMD.digest();
        this.md.reset();
        this.md.update(var6_6);
        this.md.update(var4_4);
        var4_4 = this.md.digest();
        var11_11 = new byte[12];
        var12_12 = 0;
        while (var12_12 < 12) {
            var11_11[var12_12] = var4_4[var12_12];
            ++var12_12;
        }
        return var11_11;
    }

    public boolean verify(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        int n2 = byArray3.length;
        byte[] byArray4 = this.sign(byArray, byArray2, n);
        int n3 = byArray4.length;
        if (n2 != n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (byArray3[n4] != byArray4[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = byArray;
        int n = 0;
        while (n < 16) {
            int n2 = byArray2[n] >>> 4 & 0xF;
            stringBuffer.append("0123456789ABCDEF".charAt(n2));
            n2 = byArray2[n] & 0xF;
            stringBuffer.append("0123456789ABCDEF".charAt(n2));
            ++n;
        }
        return stringBuffer.toString();
    }

    public byte[] password_to_key(String string) {
        int n = 0;
        this.md.reset();
        n = this.getPasswordToKeySize();
        return this.password_to_key(this.md, string, n);
    }

    public byte[] localizeAuthKey(byte[] byArray, SnmpEngineId snmpEngineId) {
        this.md.reset();
        this.md.update(byArray);
        this.md.update(snmpEngineId.getBytes());
        this.md.update(byArray);
        return this.md.digest();
    }

    public byte[] localizePrivKey(byte[] byArray, SnmpEngineId snmpEngineId, int n) {
        byte[] byArray2 = this.localizeAuthKey(byArray, snmpEngineId);
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray3[n2] = byArray2[n2];
            ++n2;
        }
        return byArray3;
    }

    public byte[] calculateAuthDelta(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.calculateDelta(byArray, byArray2, byArray3, this.getDeltaSize());
    }

    public byte[] calculatePrivDelta(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        return this.calculateDelta(byArray, byArray2, byArray3, n);
    }

    private byte[] calculateDelta(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2;
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[n];
        int n3 = 0;
        if (byArray2.length > n) {
            byArray4 = new byte[byArray.length];
            n3 = 0;
            while (n3 < byArray.length) {
                byArray4[n3] = byArray[n3];
                ++n3;
            }
            n2 = (n - 1) / n;
            n3 = 0;
            while (n3 < n2) {
                this.md.reset();
                this.md.update(byArray4);
                this.md.update(byArray3);
                byArray4 = this.md.digest();
                int n4 = n3 * n;
                while (n4 < n * n3 + n) {
                    byArray5[n4] = byArray4[n4];
                    int n5 = n4;
                    byArray5[n5] = (byte)(byArray5[n5] ^ byArray2[n4]);
                    ++n4;
                }
                ++n3;
            }
        } else {
            byArray4 = byArray;
        }
        this.md.reset();
        this.md.update(byArray4);
        this.md.update(byArray3);
        byArray4 = this.md.digest();
        n2 = n3 * n;
        while (n2 < n) {
            byArray5[n2] = byArray4[n2];
            int n6 = n2;
            byArray5[n6] = (byte)(byArray5[n6] ^ byArray2[n2]);
            ++n2;
        }
        return byArray5;
    }

    public byte[] calculateNewAuthKey(byte[] byArray, byte[] byArray2) {
        return this.calculateNewKey(byArray, byArray2, this.getDeltaSize());
    }

    public byte[] calculateNewPrivKey(byte[] byArray, byte[] byArray2, int n) {
        return this.calculateNewKey(byArray, byArray2, n);
    }

    private byte[] calculateNewKey(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[byArray.length];
        int n3 = 0;
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        n3 = 0;
        while (n3 < n) {
            byArray5[n3] = byArray2[n3];
            byArray6[n3] = byArray2[n3 + n];
            ++n3;
        }
        n3 = 0;
        if (byArray4.length > n) {
            n2 = (n - 1) / n;
            byArray3 = new byte[byArray.length];
            n3 = 0;
            while (n3 < byArray.length) {
                byArray3[n3] = byArray[n3];
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                this.md.reset();
                this.md.update(byArray3);
                this.md.update(byArray5);
                byArray3 = this.md.digest();
                int n4 = n3 * n;
                while (n4 < n * n3 + n) {
                    byArray4[n4] = byArray3[n4];
                    int n5 = n4;
                    byArray4[n5] = (byte)(byArray4[n5] ^ byArray6[n4]);
                    ++n4;
                }
                ++n3;
            }
        } else {
            byArray3 = byArray;
        }
        this.md.reset();
        this.md.update(byArray3);
        this.md.update(byArray5);
        byArray3 = this.md.digest();
        n2 = n3 * n;
        while (n2 < n) {
            byArray4[n2] = byArray3[n2];
            int n6 = n2;
            byArray4[n6] = (byte)(byArray4[n6] ^ byArray6[n2]);
            ++n2;
        }
        return byArray4;
    }

    private byte[] password_to_key(MessageDigest messageDigest, String string, int n) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = string.getBytes();
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < 0x100000) {
            int n5 = 0;
            while (n5 < 64) {
                byArray[n5] = byArray2[n3++ % n2];
                ++n5;
            }
            messageDigest.update(byArray, 0, 64);
            n4 += 64;
        }
        return messageDigest.digest();
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

