/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.crypto.provider.SunJCE;
import com.sun.jdmk.internal.snmp.SnmpEncryptionPair;
import com.sun.jdmk.internal.snmp.SnmpTools;
import com.sun.jdmk.snmp.usm.SnmpUsmAlgorithmImpl;
import com.sun.jdmk.snmp.usm.SnmpUsmException;
import com.sun.jdmk.snmp.usm.SnmpUsmKey;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivAlgorithm;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivException;
import com.sun.jdmk.trace.Trace;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.management.snmp.SnmpEngine;

public class SnmpUsmDesAlgorithm
extends SnmpUsmAlgorithmImpl
implements SnmpUsmPrivAlgorithm {
    private long random = -1L;
    private String properties_decrypt = null;
    private String properties_encrypt = null;
    SunJCE jce = new SunJCE();
    public static final String DES_PRIV = "usmDESPrivProtocol";
    private Cipher cipher_encrypt = null;
    private Cipher cipher_decrypt = null;
    private SnmpEngine engine = null;
    String dbgTag = "SnmpUsmDesAlgorithm";

    private synchronized long getRandom() {
        ++this.random;
        return this.random;
    }

    public SnmpUsmDesAlgorithm(SnmpEngine snmpEngine) throws SnmpUsmException {
        super(DES_PRIV);
        Security.addProvider(this.jce);
        this.engine = snmpEngine;
        this.random = System.currentTimeMillis();
        this.properties_encrypt = "DES/CBC/NoPadding";
        this.properties_decrypt = "DES/CBC/NoPadding";
        try {
            this.cipher_encrypt = Cipher.getInstance(this.properties_encrypt);
            this.cipher_decrypt = Cipher.getInstance(this.properties_decrypt);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new SnmpUsmPrivException("NoSuchAlgorithmException");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
            throw new SnmpUsmPrivException("NoSuchPaddingException");
        }
    }

    public SnmpUsmDesAlgorithm(SnmpEngine snmpEngine, String string, String string2) throws SnmpUsmException {
        super(DES_PRIV);
        this.properties_encrypt = string;
        this.properties_decrypt = string2;
        this.engine = snmpEngine;
        Security.addProvider(this.jce);
        try {
            this.cipher_encrypt = Cipher.getInstance(string);
            this.cipher_decrypt = Cipher.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (this.isDebugOn()) {
                this.debug("SnmpUsmDesAlgorithm", noSuchAlgorithmException.getMessage());
            }
            throw new SnmpUsmPrivException("NoSuchAlgorithmException");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            if (this.isDebugOn()) {
                this.debug("SnmpUsmDesAlgorithm", noSuchPaddingException.getMessage());
            }
            throw new SnmpUsmPrivException("NoSuchPaddingException");
        }
    }

    public int getKeySize() {
        return 16;
    }

    public int getDeltaSize() {
        return 16;
    }

    public String getOid() {
        return "1.3.6.1.6.3.10.1.2.2";
    }

    private byte[] genDesKey(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        byArray2[7] = 0;
        int n = 6;
        while (n >= 0) {
            int n2 = 6 - n;
            byArray2[n] = byArray[n + 1];
            byArray2[n] = (byte)(byArray2[n] >>> 1);
            byArray2[n] = (byte)(byArray2[n] & 0x7F);
            int n3 = n2;
            while (n3 > 0) {
                byte by = (byte)(byArray2[n] & 1);
                byArray2[n] = (byte)(byArray2[n] >>> 1);
                byArray2[n] = (byte)(byArray2[n] & 0x7F);
                by = (byte)(by << 8 - n3);
                byArray2[n + 1] = (byte)(byArray2[n + 1] | by);
                --n3;
            }
            --n;
        }
        byArray2[0] = (byte)(byArray2[0] | byArray[0] & 0xFE);
        return byArray2;
    }

    public synchronized SnmpEncryptionPair encrypt(byte[] byArray, byte[] byArray2, int n) throws SnmpUsmException {
        int n2 = n % 8;
        int n3 = 0;
        byte[] byArray3 = byArray2;
        int n4 = n;
        if (n2 != 0) {
            n3 = 8 - n2;
            if (this.isDebugOn()) {
                this.debug("encrypt", " Padding, must add : " + n3);
            }
            byArray3 = new byte[n + n3];
            n4 = byArray3.length;
            int n5 = 0;
            while (n5 < n) {
                byArray3[n5] = byArray2[n5];
                ++n5;
            }
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tkey length :" + byArray.length + "\tkey :" + SnmpTools.binary2ascii(byArray) + "\tdata length :" + n4 + "\tstart time:" + System.currentTimeMillis());
        }
        SnmpEncryptionPair snmpEncryptionPair = new SnmpEncryptionPair();
        int n6 = this.engine.getEngineBoots();
        long l = this.getRandom();
        if (byArray.length != 16) {
            throw new SnmpUsmPrivException("Invalid key size :" + byArray.length);
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tGen key start time:" + System.currentTimeMillis());
        }
        DESKeySpec dESKeySpec = null;
        try {
            dESKeySpec = new DESKeySpec(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", invalidKeyException.getMessage());
            }
            throw new SnmpUsmPrivException("InvalidKeyException");
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tDes key = :" + dESKeySpec.getKey());
        }
        byte[] byArray4 = new byte[8];
        if (this.isDebugOn()) {
            this.debug("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tGen key start time:" + System.currentTimeMillis());
        }
        byte[] byArray5 = new byte[]{(byte)(n6 & 0xFF000000), (byte)(n6 & 0xFF0000), (byte)(n6 & 0xFF00), (byte)(n6 & 0xFF), (byte)(l & 0xFFFFFFFFFF000000L), (byte)(l & 0xFF0000L), (byte)(l & 0xFF00L), (byte)(l & 0xFFL)};
        if (this.isDebugOn()) {
            this.debug("encrypt", "Salt : " + SnmpTools.binary2ascii(byArray5));
        }
        int n7 = 0;
        while (n7 < 8) {
            byArray4[n7] = byArray[n7 + 8];
            int n8 = n7;
            byArray4[n8] = (byte)(byArray4[n8] ^ byArray5[n7]);
            ++n7;
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "IV : " + SnmpTools.binary2ascii(byArray4));
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tSalt end time:" + System.currentTimeMillis());
        }
        snmpEncryptionPair.parameters = byArray5;
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
        try {
            this.cipher_encrypt.init(1, (Key)new SnmpUsmKey(dESKeySpec.getKey()), ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.getMessage();
            throw new SnmpUsmPrivException("InvalidKeyException");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (this.isDebugOn()) {
                this.debug("encrypt :", invalidAlgorithmParameterException.getMessage());
            }
            throw new SnmpUsmPrivException("InvalidAlgorithmParameterException");
        }
        try {
            snmpEncryptionPair.encryptedData = this.cipher_encrypt.doFinal(byArray3, 0, n4);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (this.isDebugOn()) {
                this.debug("encrypt :", illegalBlockSizeException.getMessage());
            }
            throw new SnmpUsmPrivException("IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            if (this.isDebugOn()) {
                this.debug("encrypt :", badPaddingException.getMessage());
            }
            throw new SnmpUsmPrivException("BadPaddingException");
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("encrypt :", exception.getMessage());
            }
            throw new SnmpUsmPrivException(exception.getMessage());
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "Over params length :" + snmpEncryptionPair.parameters.length + " encrypted data length :" + snmpEncryptionPair.encryptedData.length);
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "encrypt using :\t" + this.properties_encrypt + "\tENCRYPT end time:" + System.currentTimeMillis());
        }
        if (this.isDebugOn()) {
            this.debug("encrypt", "Encryption input :" + SnmpTools.binary2ascii(byArray3, n4));
            this.debug("encrypt", "Encryption output :" + SnmpTools.binary2ascii(snmpEncryptionPair.encryptedData));
        }
        return snmpEncryptionPair;
    }

    public synchronized byte[] decrypt(byte[] byArray, SnmpEncryptionPair snmpEncryptionPair) throws SnmpUsmException {
        Object object;
        if (this.isDebugOn()) {
            this.debug("decrypt", "decrypt using :\t" + this.properties_decrypt + "\tkey length :" + byArray.length + "\tkey :" + SnmpTools.binary2ascii(byArray) + "\tdata length :" + snmpEncryptionPair.encryptedData.length + "\t priv parameters : " + SnmpTools.binary2ascii(snmpEncryptionPair.parameters));
        }
        if (snmpEncryptionPair.encryptedData == null) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", "encrypted data is null, error.");
            }
            throw new SnmpUsmPrivException("Invalid encrypted data.");
        }
        int n = snmpEncryptionPair.encryptedData.length % 8;
        if (n != 0) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", "encrypted data length is not OK, error.");
            }
            throw new SnmpUsmPrivException("Invalid encrypted data length.");
        }
        DESKeySpec dESKeySpec = null;
        byte[] byArray2 = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray2[n2] = byArray[n2 + 8];
            int n3 = n2;
            byArray2[n3] = (byte)(byArray2[n3] ^ snmpEncryptionPair.parameters[n2]);
            ++n2;
        }
        if (this.isDebugOn()) {
            this.debug("decrypt", "IV parameter :" + SnmpTools.binary2ascii(byArray2));
        }
        try {
            dESKeySpec = new DESKeySpec(byArray);
            object = new IvParameterSpec(byArray2);
            this.cipher_decrypt.init(2, (Key)new SnmpUsmKey(dESKeySpec.getKey()), (AlgorithmParameterSpec)object);
        }
        catch (InvalidKeyException invalidKeyException) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", invalidKeyException.getMessage());
            }
            throw new SnmpUsmPrivException("InvalidKeyException");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", invalidAlgorithmParameterException.getMessage());
            }
            throw new SnmpUsmPrivException("InvalidAlgorithmParameterException");
        }
        if (this.isDebugOn()) {
            this.debug("decrypt :", "IV Parameter: " + SnmpTools.binary2ascii(snmpEncryptionPair.parameters));
            this.debug("decrypt :", "key : " + SnmpTools.binary2ascii(dESKeySpec.getKey()));
        }
        object = null;
        try {
            object = this.cipher_decrypt.doFinal(snmpEncryptionPair.encryptedData);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", illegalBlockSizeException.getMessage());
            }
            throw new SnmpUsmPrivException("IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", badPaddingException.getMessage());
            }
            throw new SnmpUsmPrivException("BadPaddingException");
        }
        catch (Exception exception) {
            if (this.isDebugOn()) {
                this.debug("decrypt :", exception.getMessage());
            }
            throw new SnmpUsmPrivException(exception.getMessage());
        }
        if (this.isDebugOn()) {
            this.debug("decrypt :", " Decryption input : " + SnmpTools.binary2ascii(snmpEncryptionPair.encryptedData));
            this.debug("decrypt :", " Decryption output : " + SnmpTools.binary2ascii((byte[])object));
        }
        return object;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

