/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.snmp.usm.SnmpUsmAlgorithm;
import com.sun.jdmk.trace.Trace;
import java.util.Enumeration;
import java.util.Hashtable;

public class SnmpUsmAlgorithmManager {
    private Hashtable algos = new Hashtable();
    private Hashtable algosOid = new Hashtable();
    String dbgTag = "SnmpUsmAlgorithmManager";

    public String[] getManagedAlgorithms() {
        String[] stringArray = new String[this.algos.size()];
        int n = 0;
        Enumeration enumeration = this.algos.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            stringArray[n] = string = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void addAlgorithm(SnmpUsmAlgorithm snmpUsmAlgorithm) {
        if (this.isTraceOn()) {
            this.trace("addAlgorithm", "algo name : " + snmpUsmAlgorithm.getAlgorithm());
        }
        this.algos.put(snmpUsmAlgorithm.getAlgorithm(), snmpUsmAlgorithm);
        this.algosOid.put(snmpUsmAlgorithm.getOid(), snmpUsmAlgorithm);
    }

    public SnmpUsmAlgorithm removeAlgorithm(String string) {
        SnmpUsmAlgorithm snmpUsmAlgorithm = (SnmpUsmAlgorithm)this.algos.remove(string);
        if (snmpUsmAlgorithm != null) {
            this.algosOid.remove(snmpUsmAlgorithm.getOid());
        }
        return snmpUsmAlgorithm;
    }

    public SnmpUsmAlgorithm getAlgorithm(String string) {
        SnmpUsmAlgorithm snmpUsmAlgorithm;
        if (this.isTraceOn()) {
            this.trace("getAlgorithm", "algo name : " + string);
        }
        if ((snmpUsmAlgorithm = (SnmpUsmAlgorithm)this.algos.get(string)) == null) {
            snmpUsmAlgorithm = (SnmpUsmAlgorithm)this.algosOid.get(string);
        }
        return snmpUsmAlgorithm;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

