/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.internal.snmp.SnmpDecryptedPdu;
import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.internal.snmp.SnmpModelImpl;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.internal.snmp.SnmpSecurityCache;
import com.sun.jdmk.internal.snmp.SnmpSubSystem;
import com.sun.jdmk.internal.snmp.SnmpTools;
import com.sun.jdmk.snmp.SnmpUnknownMsgProcModelException;
import com.sun.jdmk.snmp.usm.SnmpUsm;
import com.sun.jdmk.snmp.usm.SnmpUsmAuthAlgorithmException;
import com.sun.jdmk.snmp.usm.SnmpUsmAuthModule;
import com.sun.jdmk.snmp.usm.SnmpUsmEngineIdException;
import com.sun.jdmk.snmp.usm.SnmpUsmEnginePeer;
import com.sun.jdmk.snmp.usm.SnmpUsmException;
import com.sun.jdmk.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.jdmk.snmp.usm.SnmpUsmLcd;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.jdmk.snmp.usm.SnmpUsmPrivModule;
import com.sun.jdmk.snmp.usm.SnmpUsmSecureUser;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityCache;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.jdmk.snmp.usm.SnmpUsmSecurityParametersImpl;
import com.sun.jdmk.snmp.usm.SnmpUsmTimelinessModule;
import com.sun.jdmk.snmp.usm.SnmpUsmUserNameException;
import com.sun.jdmk.trace.Trace;
import java.util.Hashtable;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpSecurityException;
import javax.management.snmp.SnmpSecurityParameters;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;

public class SnmpUserSecurityModel
extends SnmpModelImpl
implements SnmpUsm {
    private Hashtable peers = new Hashtable();
    private SnmpUsmLcd lcd = null;
    private SnmpUsmExceptionGenerator genExp = null;
    private SnmpUsmTimelinessModule timeModule = null;
    private SnmpUsmAuthModule authModule = null;
    private SnmpUsmPrivModule privModule = null;
    private static int unsupportedSecLevelsCounter = 0;
    private static int notInTimeWindowsCounter = 0;
    private static int unknownUserNamesCounter = 0;
    private static int unknownEngineIdsCounter = 0;
    private static int wrongDigestsCounter = 0;
    private static int decryptionErrorsCounter = 0;
    SnmpMsgProcessingSubSystem sys = null;
    SnmpEngineImpl engine = null;
    private String DISCOVERY_USER = "";
    String dbgTag = "SnmpUserSecurityModel";

    public SnmpUserSecurityModel(SnmpSubSystem snmpSubSystem, SnmpUsmLcd snmpUsmLcd) {
        super(snmpSubSystem, "Usm");
        this.lcd = snmpUsmLcd;
        this.genExp = new SnmpUsmExceptionGenerator(this);
        this.timeModule = new SnmpUsmTimelinessModule(this.genExp);
        this.authModule = new SnmpUsmAuthModule(this, this.lcd, this.genExp);
        this.privModule = new SnmpUsmPrivModule(this, this.lcd, this.genExp);
        snmpSubSystem.addModel(3, this);
        this.engine = (SnmpEngineImpl)snmpSubSystem.getEngine();
        this.sys = this.engine.getMsgProcessingSubSystem();
    }

    public int getTimelinessWindow() {
        return this.timeModule.getTimelinessWindow();
    }

    public void setTimelinessWindow(int n) {
        this.timeModule.setTimelinessWindow(n);
    }

    public SnmpUsmLcd getLcd() {
        return this.lcd;
    }

    public void setLcd(SnmpUsmLcd snmpUsmLcd) {
        this.lcd = snmpUsmLcd;
    }

    public Long getUnsupportedSecLevelsCounter() {
        return new Long(unsupportedSecLevelsCounter);
    }

    public Long getNotInTimeWindowsCounter() {
        return new Long(notInTimeWindowsCounter);
    }

    public Long getUnknownUserNamesCounter() {
        return new Long(unknownUserNamesCounter);
    }

    public Long getUnknownEngineIdsCounter() {
        return new Long(unknownEngineIdsCounter);
    }

    public Long getWrongDigestsCounter() {
        return new Long(wrongDigestsCounter);
    }

    public Long getDecryptionErrorsCounter() {
        return new Long(decryptionErrorsCounter);
    }

    public synchronized SnmpUsmEnginePeer getEnginePeer(SnmpEngineId snmpEngineId) {
        SnmpUsmEnginePeer snmpUsmEnginePeer = (SnmpUsmEnginePeer)this.peers.get(snmpEngineId.toString());
        if (snmpUsmEnginePeer == null) {
            snmpUsmEnginePeer = new SnmpUsmEnginePeer(snmpEngineId);
            this.peers.put(snmpEngineId.toString(), snmpUsmEnginePeer);
        }
        return snmpUsmEnginePeer;
    }

    public SnmpUsmSecurityParameters createUsmSecurityParameters() {
        SnmpUsmSecurityParametersImpl snmpUsmSecurityParametersImpl = new SnmpUsmSecurityParametersImpl();
        return snmpUsmSecurityParametersImpl;
    }

    public SnmpSecurityCache createSecurityCache() {
        return new SnmpUsmSecurityCache();
    }

    public void releaseSecurityCache(SnmpSecurityCache snmpSecurityCache) {
    }

    public int generateResponseMsg(SnmpSecurityCache snmpSecurityCache, int n, int n2, int n3, byte by, int n4, SnmpSecurityParameters snmpSecurityParameters, byte[] byArray, byte[] byArray2, byte[] byArray3, int n5, byte[] byArray4) throws SnmpTooBigException, SnmpStatusException, SnmpSecurityException {
        if (this.isDebugOn()) {
            this.debug("generateResponseMsg", "Sending a response");
        }
        SnmpUsmSecurityCache snmpUsmSecurityCache = (SnmpUsmSecurityCache)snmpSecurityCache;
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpSecurityParameters;
        snmpUsmSecurityParameters.setAuthoritativeEngineBoots(this.engine.getEngineBoots());
        snmpUsmSecurityParameters.setAuthoritativeEngineTime(this.engine.getEngineTime());
        try {
            return this.processOutgoingMessage(this.sys, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray, byArray2, byArray3, n5, byArray4, true);
        }
        catch (SnmpUsmUserNameException snmpUsmUserNameException) {
            throw new SnmpSecurityException(snmpUsmUserNameException.toString());
        }
        catch (SnmpUsmAuthAlgorithmException snmpUsmAuthAlgorithmException) {
            throw new SnmpSecurityException(snmpUsmAuthAlgorithmException.toString());
        }
        catch (SnmpUsmPrivAlgorithmException snmpUsmPrivAlgorithmException) {
            throw new SnmpSecurityException(snmpUsmPrivAlgorithmException.toString());
        }
        catch (SnmpUsmException snmpUsmException) {
            throw new SnmpSecurityException(snmpUsmException.toString());
        }
    }

    public int generateRequestMsg(SnmpSecurityCache snmpSecurityCache, int n, int n2, int n3, byte by, int n4, SnmpSecurityParameters snmpSecurityParameters, byte[] byArray, byte[] byArray2, byte[] byArray3, int n5, byte[] byArray4) throws SnmpTooBigException, SnmpStatusException, SnmpSecurityException {
        if (this.isDebugOn()) {
            this.debug("generateRequestMsg", "Sending a request.");
        }
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = null;
        SnmpUsmSecurityCache snmpUsmSecurityCache = (SnmpUsmSecurityCache)snmpSecurityCache;
        snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpSecurityParameters;
        if ((by & 1) != 0) {
            if (!this.engine.getEngineId().equals(snmpUsmSecurityParameters.getAuthoritativeEngineId())) {
                SnmpUsmEnginePeer snmpUsmEnginePeer = (SnmpUsmEnginePeer)this.peers.get(snmpUsmSecurityParameters.getAuthoritativeEngineId().toString());
                if (snmpUsmEnginePeer != null) {
                    snmpUsmSecurityParameters.setAuthoritativeEngineBoots(snmpUsmEnginePeer.getAuthoritativeEngineBoots());
                    snmpUsmSecurityParameters.setAuthoritativeEngineTime(snmpUsmEnginePeer.getAuthoritativeEngineTime());
                    if (this.isDebugOn()) {
                        this.debug("generateRequestMsg", "Setting security parameters to outgoing request using Peer parameters : \nBoot : " + snmpUsmSecurityParameters.getAuthoritativeEngineBoots() + "\n Time : " + snmpUsmSecurityParameters.getAuthoritativeEngineTime());
                    }
                }
            } else {
                snmpUsmSecurityParameters.setAuthoritativeEngineBoots(this.engine.getEngineBoots());
                snmpUsmSecurityParameters.setAuthoritativeEngineTime(this.engine.getEngineTime());
            }
        }
        try {
            return this.processOutgoingMessage(this.sys, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray, byArray2, byArray3, n5, byArray4, false);
        }
        catch (SnmpUsmUserNameException snmpUsmUserNameException) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException(snmpUsmUserNameException.toString());
            snmpSecurityException.contextEngineId = byArray;
            snmpSecurityException.contextName = byArray2;
            snmpSecurityException.flags = by;
            snmpSecurityException.params = snmpSecurityParameters;
            snmpSecurityException.status = 244;
            throw snmpSecurityException;
        }
        catch (SnmpUsmAuthAlgorithmException snmpUsmAuthAlgorithmException) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException(snmpUsmAuthAlgorithmException.toString());
            snmpSecurityException.contextEngineId = byArray;
            snmpSecurityException.contextName = byArray2;
            snmpSecurityException.flags = by;
            snmpSecurityException.params = snmpSecurityParameters;
            snmpSecurityException.status = 245;
            throw snmpSecurityException;
        }
        catch (SnmpUsmPrivAlgorithmException snmpUsmPrivAlgorithmException) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException(snmpUsmPrivAlgorithmException.toString());
            snmpSecurityException.contextEngineId = byArray;
            snmpSecurityException.contextName = byArray2;
            snmpSecurityException.flags = by;
            snmpSecurityException.params = snmpSecurityParameters;
            snmpSecurityException.status = 246;
            throw snmpSecurityException;
        }
        catch (SnmpUsmEngineIdException snmpUsmEngineIdException) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException(snmpUsmEngineIdException.toString());
            snmpSecurityException.contextEngineId = byArray;
            snmpSecurityException.contextName = byArray2;
            snmpSecurityException.flags = by;
            snmpSecurityException.params = snmpSecurityParameters;
            snmpSecurityException.status = 247;
            throw snmpSecurityException;
        }
        catch (SnmpUsmException snmpUsmException) {
            SnmpSecurityException snmpSecurityException = new SnmpSecurityException(snmpUsmException.toString());
            snmpSecurityException.contextEngineId = byArray;
            snmpSecurityException.contextName = byArray2;
            snmpSecurityException.flags = by;
            snmpSecurityException.params = snmpSecurityParameters;
            throw snmpSecurityException;
        }
    }

    public SnmpSecurityParameters processIncomingRequest(SnmpSecurityCache snmpSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, SnmpDecryptedPdu snmpDecryptedPdu) throws SnmpStatusException, SnmpSecurityException {
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = this.decodeParameters(byArray);
        return this.processIncomingMessage(snmpSecurityCache, n, n2, n3, by, n4, byArray, byArray2, byArray3, byArray4, byArray5, snmpDecryptedPdu);
    }

    public SnmpSecurityParameters processIncomingResponse(SnmpSecurityCache snmpSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, SnmpDecryptedPdu snmpDecryptedPdu) throws SnmpStatusException, SnmpSecurityException {
        return this.processIncomingMessage(snmpSecurityCache, n, n2, n3, by, n4, byArray, byArray2, byArray3, byArray4, byArray5, snmpDecryptedPdu);
    }

    private SnmpSecurityParameters processIncomingMessage(SnmpSecurityCache snmpSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, SnmpDecryptedPdu snmpDecryptedPdu) throws SnmpStatusException, SnmpSecurityException {
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = this.decodeParameters(byArray);
        int n5 = by & 3;
        SnmpUsmSecurityCache snmpUsmSecurityCache = null;
        if (snmpSecurityCache != null) {
            snmpUsmSecurityCache = (SnmpUsmSecurityCache)snmpSecurityCache;
            snmpUsmSecurityCache.userName = snmpUsmSecurityParameters.getUserName();
        }
        if (this.handleEngineIdDiscovery(snmpUsmSecurityParameters, byArray2, byArray3)) {
            if (this.isTraceOn()) {
                this.trace("processIncomingMessage", "Received Engine Id discovery response: [" + snmpUsmSecurityParameters.getAuthoritativeEngineId() + "]");
            }
            return snmpUsmSecurityParameters;
        }
        if (this.isTraceOn()) {
            this.trace("processIncomingMessage", "Received Engine Id : [" + snmpUsmSecurityParameters.getAuthoritativeEngineId() + "] , data : " + byArray4);
        }
        if ((by & 4) == 4 && !this.engine.getEngineId().equals(snmpUsmSecurityParameters.getAuthoritativeEngineId())) {
            if (this.isDebugOn()) {
                this.debug("processIncomingMessage", "Received a reportable message but the received engine Id [" + snmpUsmSecurityParameters.getAuthoritativeEngineId() + "not the local one. Throwing unknownEngineId");
            }
            this.genExp.genEngineIdException(byArray2, byArray3, by, snmpUsmSecurityParameters);
        }
        SnmpUsmSecureUser snmpUsmSecureUser = null;
        if (this.isDebugOn()) {
            this.debug("processIncomingMessage", "Received msg from :" + snmpUsmSecurityParameters.getAuthoritativeEngineId() + ", principal : [" + snmpUsmSecurityParameters.getPrincipal() + "]");
        }
        try {
            snmpUsmSecureUser = this.getUser(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getPrincipal());
        }
        catch (SnmpUsmUserNameException snmpUsmUserNameException) {
            if (this.isDebugOn()) {
                this.debug("processIncomingMessage", "SnmpUsmUserNameException");
            }
            this.genExp.genUserNameException(byArray2, byArray3, by, snmpUsmSecurityParameters);
        }
        catch (SnmpUsmEngineIdException snmpUsmEngineIdException) {
            if (this.isDebugOn()) {
                this.debug("processIncomingMessage", "genEngineIdException, unknown engine ID when looking for user [" + snmpUsmSecurityParameters.getPrincipal() + "]");
            }
            this.genExp.genEngineIdException(byArray2, byArray3, by, snmpUsmSecurityParameters);
        }
        if ((n5 & 3) == 0) {
            if (this.isDebugOn()) {
                this.debug("processIncomingMessage", "noAuthNoPriv message");
            }
            snmpDecryptedPdu.data = byArray4;
            snmpDecryptedPdu.contextName = byArray3;
            snmpDecryptedPdu.contextEngineId = byArray2;
            return snmpUsmSecurityParameters;
        }
        if (n5 == 1) {
            if (this.isDebugOn()) {
                this.debug("processIncomingMessage", "authNoPriv message, authModule : " + this.authModule);
            }
            this.authModule.authMsg(this.sys, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray2, byArray3, byArray4);
            this.handleTimeliness(snmpUsmSecurityParameters);
            snmpDecryptedPdu.data = byArray4;
            snmpDecryptedPdu.contextName = byArray3;
            snmpDecryptedPdu.contextEngineId = byArray2;
            return snmpUsmSecurityParameters;
        }
        if (n5 == 3) {
            if (this.isDebugOn()) {
                this.debug("processIncomingMessage", "authPriv message");
            }
            this.authModule.authMsg(this.sys, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray5);
            this.handleTimeliness(snmpUsmSecurityParameters);
            SnmpDecryptedPdu snmpDecryptedPdu2 = this.privModule.decrypt(this.sys, n, snmpUsmSecurityParameters, snmpUsmSecurityCache, byArray5, by);
            snmpDecryptedPdu.data = snmpDecryptedPdu2.data;
            snmpDecryptedPdu.contextName = snmpDecryptedPdu2.contextName;
            snmpDecryptedPdu.contextEngineId = snmpDecryptedPdu2.contextEngineId;
        }
        return snmpUsmSecurityParameters;
    }

    private int processOutgoingMessage(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpUsmSecurityParameters snmpUsmSecurityParameters, SnmpUsmSecurityCache snmpUsmSecurityCache, int n, int n2, int n3, byte by, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3, int n5, byte[] byArray4, boolean bl) throws SnmpUsmException, SnmpStatusException, SnmpTooBigException {
        try {
            int n6 = by & 3;
            boolean bl2 = false;
            switch (n6) {
                case 0: {
                    if (!this.DISCOVERY_USER.equals(snmpUsmSecurityParameters.getPrincipal()) && snmpUsmSecurityParameters.getAuthoritativeEngineId() != null && !bl) {
                        try {
                            if (this.isDebugOn()) {
                                this.debug("processOutgoingMessage", "Sending noAuthNoPriv from :" + snmpUsmSecurityParameters.getAuthoritativeEngineId() + ", principal : [" + snmpUsmSecurityParameters.getPrincipal() + "]");
                            }
                            this.lcd.getUser(snmpUsmSecurityParameters.getAuthoritativeEngineId(), snmpUsmSecurityParameters.getPrincipal());
                            if (this.isDebugOn()) {
                                this.debug("processOutgoingMessage", "OK noAuthNoPriv msg");
                            }
                        }
                        catch (SnmpUsmEngineIdException snmpUsmEngineIdException) {
                            if (this.isDebugOn()) {
                                this.debug("processOutgoingMessage", "SnmpUsmEngineIdException");
                            }
                            throw new SnmpUsmUserNameException("Unknown user :" + snmpUsmSecurityParameters.getPrincipal());
                        }
                    }
                    return snmpMsgProcessingSubSystem.encode(n, n2, n3, by, n4, snmpUsmSecurityParameters, byArray, byArray2, byArray3, n5, byArray4);
                }
                case 1: {
                    byte[] byArray5 = this.authModule.signMsg(snmpMsgProcessingSubSystem, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray, byArray2, byArray3, n5);
                    snmpUsmSecurityParameters.setAuthParameters(byArray5);
                    int n7 = snmpMsgProcessingSubSystem.encode(n, n2, n3, by, n4, snmpUsmSecurityParameters, byArray, byArray2, byArray3, n5, byArray4);
                    return n7;
                }
                case 3: {
                    byte[] byArray6 = new byte[n3];
                    byte[] byArray7 = new byte[n3];
                    SnmpDecryptedPdu snmpDecryptedPdu = new SnmpDecryptedPdu();
                    snmpDecryptedPdu.data = byArray3;
                    snmpDecryptedPdu.dataLength = n5;
                    snmpDecryptedPdu.contextEngineId = byArray;
                    snmpDecryptedPdu.contextName = byArray2;
                    if (this.isDebugOn()) {
                        this.debug("processOutgoingMessage", "Flat pdu to encrypt : length : " + snmpDecryptedPdu.data.length + "Engine Id :" + SnmpTools.binary2ascii(snmpDecryptedPdu.contextEngineId) + " Contexte name :" + (snmpDecryptedPdu.contextName == null ? "Unknown context name" : new String(snmpDecryptedPdu.contextName)));
                    }
                    int n8 = snmpMsgProcessingSubSystem.encode(n, snmpDecryptedPdu, byArray6);
                    byte[] byArray8 = this.privModule.encrypt(snmpUsmSecurityCache, snmpUsmSecurityParameters, byArray6, n8);
                    byte[] byArray9 = this.authModule.signMsg(snmpMsgProcessingSubSystem, snmpUsmSecurityParameters, snmpUsmSecurityCache, n, n2, n3, by, n4, byArray8);
                    snmpUsmSecurityParameters.setAuthParameters(byArray9);
                    int n9 = snmpMsgProcessingSubSystem.encodePriv(n, n2, n3, by, n4, snmpUsmSecurityParameters, byArray8, byArray4);
                    return n9;
                }
            }
            throw new SnmpUsmException("Bad Security Level.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.isDebugOn()) {
                this.debug("processOutgoingMessage", arrayIndexOutOfBoundsException);
            }
            throw new SnmpTooBigException();
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (this.isDebugOn()) {
                this.debug("processOutgoingMessage", snmpUnknownMsgProcModelException);
            }
            throw new SnmpUsmException("unknown MsgProcModel Exception");
        }
    }

    SnmpUsmSecureUser getUser(SnmpEngineId snmpEngineId, String string) throws SnmpUsmUserNameException, SnmpUsmEngineIdException {
        SnmpUsmSecureUser snmpUsmSecureUser = null;
        if (this.isDebugOn()) {
            this.debug("getUser", "Getting user infos for :" + snmpEngineId + ", principal : [" + string + "]");
        }
        snmpUsmSecureUser = this.lcd.getUser(snmpEngineId, string);
        if (this.isDebugOn()) {
            this.debug("getUser", "OK Found user");
        }
        return snmpUsmSecureUser;
    }

    boolean handleEngineIdDiscovery(SnmpUsmSecurityParameters snmpUsmSecurityParameters, byte[] byArray, byte[] byArray2) throws SnmpSecurityException, SnmpStatusException {
        if (this.isDebugOn()) {
            this.debug("handleEngineIdDiscovery", "principal :" + snmpUsmSecurityParameters.getPrincipal() + ", engine Id" + snmpUsmSecurityParameters.getAuthoritativeEngineId());
        }
        if (snmpUsmSecurityParameters.getAuthoritativeEngineId() == null) {
            if (this.isTraceOn()) {
                this.trace("handleEngineIdDiscovery", "Engine Id Discovery. Will send back :" + this.engine.getEngineId());
            }
            snmpUsmSecurityParameters.setAuthoritativeEngineId(this.engine.getEngineId());
            snmpUsmSecurityParameters.setAuthoritativeEngineTime(0);
            snmpUsmSecurityParameters.setAuthoritativeEngineBoots(0);
            this.genExp.genEngineIdException(byArray, byArray2, (byte)4, snmpUsmSecurityParameters);
            return false;
        }
        if (this.DISCOVERY_USER.equals(snmpUsmSecurityParameters.getPrincipal())) {
            if (!this.engine.getEngineId().equals(snmpUsmSecurityParameters.getAuthoritativeEngineId())) {
                if (this.isTraceOn()) {
                    this.trace("handleEngineIdDiscovery", "Engine Id Discovery response : [" + snmpUsmSecurityParameters.getAuthoritativeEngineId());
                }
                this.lcd.addEngine(snmpUsmSecurityParameters.getAuthoritativeEngineId());
                SnmpUsmEnginePeer snmpUsmEnginePeer = (SnmpUsmEnginePeer)this.peers.get(snmpUsmSecurityParameters.getAuthoritativeEngineId().toString());
                if (snmpUsmEnginePeer == null) {
                    if (this.isDebugOn()) {
                        this.debug("handleEngineIdDiscovery", "Create peer.");
                    }
                    snmpUsmEnginePeer = new SnmpUsmEnginePeer(snmpUsmSecurityParameters.getAuthoritativeEngineId());
                    this.peers.put(snmpUsmSecurityParameters.getAuthoritativeEngineId().toString(), snmpUsmEnginePeer);
                }
            } else {
                if (this.isTraceOn()) {
                    this.trace("handleEngineIdDiscovery", "Received a response with engine Id == Local One. Throwing exception.");
                }
                SnmpSecurityException snmpSecurityException = new SnmpSecurityException("Engine Id discovery failed, Received engine Id [" + snmpUsmSecurityParameters.getAuthoritativeEngineId() + "] is equals to local one!");
                snmpSecurityException.status = 247;
                throw snmpSecurityException;
            }
            return true;
        }
        return false;
    }

    void handleTimeliness(SnmpUsmSecurityParameters snmpUsmSecurityParameters) throws SnmpSecurityException, SnmpStatusException {
        if (this.engine.getEngineId().equals(snmpUsmSecurityParameters.getAuthoritativeEngineId())) {
            if (this.isDebugOn()) {
                this.debug("handleTimeliness", "Check Request timeliness.");
            }
            this.timeModule.handleTimeliness(this.engine, snmpUsmSecurityParameters);
        } else {
            SnmpUsmEnginePeer snmpUsmEnginePeer = (SnmpUsmEnginePeer)this.peers.get(snmpUsmSecurityParameters.getAuthoritativeEngineId().toString());
            if (snmpUsmEnginePeer == null) {
                if (this.isDebugOn()) {
                    this.debug("handleTimeliness", "Received an authenticated unconfirmed pdu from an unknown authoritative. Create peer.");
                }
                snmpUsmEnginePeer = new SnmpUsmEnginePeer(snmpUsmSecurityParameters.getAuthoritativeEngineId());
                this.peers.put(snmpUsmSecurityParameters.getAuthoritativeEngineId().toString(), snmpUsmEnginePeer);
            }
            if (this.isDebugOn()) {
                this.debug("handleTimeliness", "Check Response timeliness.");
            }
            this.timeModule.handleResponseTimeliness(snmpUsmEnginePeer, snmpUsmSecurityParameters);
        }
    }

    SnmpUsmSecurityParameters decodeParameters(byte[] byArray) throws SnmpStatusException {
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = this.createUsmSecurityParameters();
        snmpUsmSecurityParameters.decode(byArray);
        return snmpUsmSecurityParameters;
    }

    synchronized long incUnsupportedSecLevelsCounter(int n) {
        return unsupportedSecLevelsCounter += n;
    }

    synchronized long incNotInTimeWindowsCounter(int n) {
        return notInTimeWindowsCounter += n;
    }

    synchronized long incUnknownUserNamesCounter(int n) {
        return unknownUserNamesCounter += n;
    }

    synchronized long incUnknownEngineIdsCounter(int n) {
        return unknownEngineIdsCounter += n;
    }

    synchronized long incWrongDigestsCounter(int n) {
        return wrongDigestsCounter += n;
    }

    synchronized long incDecryptionErrorsCounter(int n) {
        return decryptionErrorsCounter += n;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

