/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.usm;

import com.sun.jdmk.internal.snmp.SnmpPersistRowFile;
import com.sun.jdmk.snmp.usm.SnmpUsmSecureUser;
import com.sun.jdmk.snmp.usm.SnmpUsmSecureUserImpl;
import com.sun.jdmk.trace.Trace;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.snmp.SnmpEngineId;

class LcdEngine {
    Hashtable users = new Hashtable();
    SnmpEngineId engineId = null;
    String dbgTag = "LcdEngine";

    LcdEngine(SnmpEngineId snmpEngineId) {
        this.engineId = snmpEngineId;
    }

    void storeUsers(SnmpEngineId snmpEngineId, FileWriter fileWriter, SnmpPersistRowFile snmpPersistRowFile) {
        Enumeration enumeration = this.users.elements();
        while (enumeration.hasMoreElements()) {
            SnmpUsmSecureUserImpl snmpUsmSecureUserImpl = (SnmpUsmSecureUserImpl)enumeration.nextElement();
            if (snmpUsmSecureUserImpl.getStorageType() < 3) continue;
            try {
                if (this.isDebugOn()) {
                    this.debug("storeUsers", " user.getConf() :" + snmpUsmSecureUserImpl.getConf());
                }
                snmpPersistRowFile.write(fileWriter, snmpUsmSecureUserImpl.getConf() + "\n\n");
            }
            catch (IOException iOException) {
                if (!this.isDebugOn()) break;
                this.debug("storeUsers", iOException);
                break;
            }
        }
    }

    SnmpUsmSecureUser addSecureUser(SnmpUsmSecureUser snmpUsmSecureUser) {
        if (this.isDebugOn()) {
            this.debug("addSecureUser", " adding user :" + snmpUsmSecureUser.getName());
        }
        return this.users.put(snmpUsmSecureUser.getName(), snmpUsmSecureUser);
    }

    SnmpUsmSecureUser getSecureUser(String string) {
        return (SnmpUsmSecureUser)this.users.get(string);
    }

    SnmpUsmSecureUser removeSecureUser(String string) {
        return (SnmpUsmSecureUser)this.users.remove(string);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

