/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.mpm;

import com.sun.jdmk.internal.snmp.SnmpDecryptedPdu;
import com.sun.jdmk.internal.snmp.SnmpIncomingRequest;
import com.sun.jdmk.internal.snmp.SnmpIncomingResponse;
import com.sun.jdmk.internal.snmp.SnmpModelImpl;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingModel;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.internal.snmp.SnmpOutgoingRequest;
import com.sun.jdmk.internal.snmp.SnmpSecuritySubSystem;
import com.sun.jdmk.internal.snmp.SnmpSubSystem;
import com.sun.jdmk.snmp.mpm.SnmpIncomingRequestImpl;
import com.sun.jdmk.snmp.mpm.SnmpIncomingResponseImpl;
import com.sun.jdmk.snmp.mpm.SnmpMsgTranslator;
import com.sun.jdmk.snmp.mpm.SnmpMsgTranslatorV3;
import com.sun.jdmk.snmp.mpm.SnmpOutgoingRequestImpl;
import com.sun.jdmk.trace.Trace;
import javax.management.snmp.BerDecoder;
import javax.management.snmp.BerEncoder;
import javax.management.snmp.BerException;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpScopedPduBulk;
import javax.management.snmp.SnmpScopedPduPacket;
import javax.management.snmp.SnmpScopedPduRequest;
import javax.management.snmp.SnmpSecurityParameters;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpV3Message;
import javax.management.snmp.manager.SnmpParams;
import javax.management.snmp.manager.SnmpV3Parameters;

public class SnmpMsgProcessingModelV3
extends SnmpModelImpl
implements SnmpMsgProcessingModel {
    private int bufferSize = 1024;
    private SnmpMsgTranslator translator = null;
    String dbgTag = "SnmpMsgProcessingModelV3";

    public synchronized void setMsgTranslator(SnmpMsgTranslator snmpMsgTranslator) {
        this.translator = snmpMsgTranslator;
    }

    public synchronized SnmpMsgTranslator getMsgTranslator() {
        return this.translator;
    }

    private SnmpMsgTranslator createMsgTranslator(SnmpSubSystem snmpSubSystem) {
        return new SnmpMsgTranslatorV3();
    }

    public SnmpMsgProcessingModelV3(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpMsgTranslator snmpMsgTranslator) {
        super(snmpMsgProcessingSubSystem, "Snmp V3");
        this.translator = snmpMsgTranslator == null ? this.createMsgTranslator(snmpMsgProcessingSubSystem) : snmpMsgTranslator;
        snmpMsgProcessingSubSystem.addModel(3, this);
    }

    public SnmpIncomingRequest getIncomingRequest(SnmpPduFactory snmpPduFactory) {
        SnmpSecuritySubSystem snmpSecuritySubSystem = ((SnmpMsgProcessingSubSystem)this.getSubSystem()).getSecuritySubSystem();
        return new SnmpIncomingRequestImpl(snmpSecuritySubSystem, snmpPduFactory, new SnmpV3Message(), new SnmpV3Message(), this.getMsgTranslator());
    }

    public SnmpOutgoingRequest getOutgoingRequest(SnmpPduFactory snmpPduFactory) {
        SnmpSecuritySubSystem snmpSecuritySubSystem = ((SnmpMsgProcessingSubSystem)this.getSubSystem()).getSecuritySubSystem();
        return new SnmpOutgoingRequestImpl(snmpSecuritySubSystem, snmpPduFactory, new SnmpV3Message(), this.getMsgTranslator());
    }

    public SnmpIncomingResponse getIncomingResponse(SnmpPduFactory snmpPduFactory) {
        SnmpSecuritySubSystem snmpSecuritySubSystem = ((SnmpMsgProcessingSubSystem)this.getSubSystem()).getSecuritySubSystem();
        return new SnmpIncomingResponseImpl(snmpSecuritySubSystem, snmpPduFactory, new SnmpV3Message(), this.getMsgTranslator());
    }

    public SnmpPdu getRequestPdu(SnmpParams snmpParams, int n) throws SnmpStatusException {
        SnmpScopedPduPacket snmpScopedPduPacket = null;
        SnmpV3Parameters snmpV3Parameters = (SnmpV3Parameters)snmpParams;
        if (n == 165) {
            SnmpScopedPduBulk snmpScopedPduBulk;
            snmpScopedPduPacket = snmpScopedPduBulk = new SnmpScopedPduBulk();
        } else {
            SnmpScopedPduRequest snmpScopedPduRequest = new SnmpScopedPduRequest();
            snmpScopedPduPacket = snmpScopedPduRequest;
            snmpScopedPduPacket.type = n;
        }
        snmpScopedPduPacket.version = snmpV3Parameters.getProtocolVersion();
        snmpScopedPduPacket.contextEngineId = snmpV3Parameters.getContextEngineId();
        snmpScopedPduPacket.contextName = snmpV3Parameters.getContextName();
        snmpScopedPduPacket.msgFlags = (byte)snmpV3Parameters.getSecurityLevel();
        snmpScopedPduPacket.msgMaxSize = snmpV3Parameters.getMsgMaxSize();
        snmpScopedPduPacket.msgSecurityModel = snmpV3Parameters.getMsgSecurityModel();
        snmpScopedPduPacket.securityParameters = snmpV3Parameters.getSecurityParameters();
        return snmpScopedPduPacket;
    }

    byte[] encodeParameters(SnmpSecurityParameters snmpSecurityParameters) throws SnmpTooBigException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = new byte[this.bufferSize];
            int n = 0;
            n = snmpSecurityParameters.encode(byArray2);
            byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = byArray2[n2];
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
        return byArray;
    }

    public int encodePriv(int n, int n2, int n3, byte by, int n4, SnmpSecurityParameters snmpSecurityParameters, byte[] byArray, byte[] byArray2) throws SnmpTooBigException {
        BerEncoder berEncoder = null;
        boolean bl = false;
        berEncoder = new BerEncoder(byArray2);
        int n5 = 0;
        berEncoder.openSequence();
        berEncoder.putOctetString(byArray);
        byte[] byArray3 = this.encodeParameters(snmpSecurityParameters);
        berEncoder.putOctetString(byArray3);
        berEncoder.openSequence();
        berEncoder.putInteger(n4);
        byte[] byArray4 = new byte[]{by};
        berEncoder.putOctetString(byArray4);
        berEncoder.putInteger(n3);
        berEncoder.putInteger(n2);
        berEncoder.closeSequence();
        berEncoder.putInteger(n);
        berEncoder.closeSequence();
        n5 = berEncoder.trim();
        return n5;
    }

    public int encode(int n, int n2, int n3, byte by, int n4, SnmpSecurityParameters snmpSecurityParameters, byte[] byArray, byte[] byArray2, byte[] byArray3, int n5, byte[] byArray4) throws SnmpTooBigException {
        if (this.isDebugOn()) {
            this.debug("encode", "Version: " + n + ", msgId: " + n2 + ", msgMaxSize: " + n3 + ", msgFlags: " + by + ", msgSecurityModel: " + n4 + ", params: " + snmpSecurityParameters + ", contextEngineId: " + (byArray == null ? null : SnmpEngineId.createEngineId(byArray)) + ", contextName: " + (byArray2 == null ? null : new String(byArray2)) + ", data len: " + n5);
        }
        BerEncoder berEncoder = null;
        berEncoder = new BerEncoder(byArray4);
        int n6 = 0;
        berEncoder.openSequence();
        berEncoder.openSequence();
        berEncoder.putAny(byArray3, n5);
        berEncoder.putOctetString(byArray2 != null ? byArray2 : new byte[]{});
        berEncoder.putOctetString(byArray != null ? byArray : new byte[]{});
        berEncoder.closeSequence();
        byte[] byArray5 = this.encodeParameters(snmpSecurityParameters);
        berEncoder.putOctetString(byArray5);
        berEncoder.openSequence();
        berEncoder.putInteger(n4);
        byte[] byArray6 = new byte[]{by};
        berEncoder.putOctetString(byArray6);
        berEncoder.putInteger(n3);
        berEncoder.putInteger(n2);
        berEncoder.closeSequence();
        berEncoder.putInteger(n);
        berEncoder.closeSequence();
        n6 = berEncoder.trim();
        return n6;
    }

    public SnmpDecryptedPdu decode(byte[] byArray) throws SnmpStatusException {
        SnmpDecryptedPdu snmpDecryptedPdu = new SnmpDecryptedPdu();
        try {
            BerDecoder berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            snmpDecryptedPdu.contextEngineId = berDecoder.fetchOctetString();
            snmpDecryptedPdu.contextName = berDecoder.fetchOctetString();
            snmpDecryptedPdu.data = berDecoder.fetchAny();
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding : " + berException.toString());
        }
        return snmpDecryptedPdu;
    }

    public int encode(SnmpDecryptedPdu snmpDecryptedPdu, byte[] byArray) throws SnmpTooBigException {
        if (this.isDebugOn()) {
            this.debug("encode", "pdu: " + snmpDecryptedPdu + ", output bytes: " + byArray);
        }
        BerEncoder berEncoder = new BerEncoder(byArray);
        berEncoder.openSequence();
        berEncoder.putAny(snmpDecryptedPdu.data, snmpDecryptedPdu.dataLength);
        berEncoder.putOctetString(snmpDecryptedPdu.contextName != null ? snmpDecryptedPdu.contextName : new byte[]{});
        berEncoder.putOctetString(snmpDecryptedPdu.contextEngineId != null ? snmpDecryptedPdu.contextEngineId : new byte[]{});
        berEncoder.closeSequence();
        return berEncoder.trim();
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

