/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.mpm;

import com.sun.jdmk.internal.snmp.SnmpDecryptedPdu;
import com.sun.jdmk.internal.snmp.SnmpIncomingResponse;
import com.sun.jdmk.internal.snmp.SnmpSecurityCache;
import com.sun.jdmk.internal.snmp.SnmpSecuritySubSystem;
import com.sun.jdmk.snmp.SnmpUnknownSecModelException;
import com.sun.jdmk.snmp.mpm.SnmpMsgTranslator;
import com.sun.jdmk.trace.Trace;
import java.net.InetAddress;
import javax.management.snmp.SnmpMsg;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.SnmpSecurityException;
import javax.management.snmp.SnmpSecurityParameters;
import javax.management.snmp.SnmpStatusException;

class SnmpIncomingResponseImpl
implements SnmpIncomingResponse {
    SnmpMsg resp = null;
    SnmpSecuritySubSystem secureSubSys = null;
    SnmpMsgTranslator translator = null;
    SnmpSecurityParameters params = null;
    SnmpSecurityCache cache = null;
    SnmpPduFactory factory = null;
    String dbgTag = "SnmpIncomingResponseImpl";

    public SnmpIncomingResponseImpl(SnmpSecuritySubSystem snmpSecuritySubSystem, SnmpPduFactory snmpPduFactory, SnmpMsg snmpMsg, SnmpMsgTranslator snmpMsgTranslator) {
        this.secureSubSys = snmpSecuritySubSystem;
        this.resp = snmpMsg;
        this.translator = snmpMsgTranslator;
        this.factory = snmpPduFactory;
    }

    public InetAddress getAddress() {
        return this.resp.address;
    }

    public int getPort() {
        return this.resp.port;
    }

    public void setSecurityCache(SnmpSecurityCache snmpSecurityCache) {
        this.cache = snmpSecurityCache;
    }

    public int getSecurityLevel() {
        return this.translator.getSecurityLevel(this.resp);
    }

    public int getSecurityModel() {
        return this.translator.getMsgSecurityModel(this.resp);
    }

    public byte[] getContextName() {
        return this.translator.getContextName(this.resp);
    }

    public SnmpSecurityParameters getSecurityParameters() {
        return this.params;
    }

    public int getRequestId(byte[] byArray) throws SnmpStatusException {
        return this.resp.getRequestId(byArray);
    }

    public SnmpMsg decodeMessage(byte[] byArray, int n, InetAddress inetAddress, int n2) throws SnmpStatusException, SnmpSecurityException {
        this.resp.address = inetAddress;
        this.resp.port = n2;
        this.resp.decodeMessage(byArray, n);
        SnmpDecryptedPdu snmpDecryptedPdu = new SnmpDecryptedPdu();
        try {
            this.params = this.secureSubSys.processIncomingResponse(this.cache, this.resp.version, this.translator.getMsgId(this.resp), this.translator.getMsgMaxSize(this.resp), this.translator.getMsgFlags(this.resp), this.translator.getMsgSecurityModel(this.resp), this.translator.getFlatSecurityParameters(this.resp), this.translator.getContextEngineId(this.resp), this.translator.getContextName(this.resp), this.resp.data, this.translator.getEncryptedPdu(this.resp), snmpDecryptedPdu);
            this.secureSubSys.releaseSecurityCache(this.translator.getMsgSecurityModel(this.resp), this.cache);
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (this.isDebugOn()) {
                this.debug("decodeMessage", snmpUnknownSecModelException.getMessage() + "\n Will fail in timeout!!!");
            }
            return null;
        }
        if (snmpDecryptedPdu.data != null) {
            this.resp.data = snmpDecryptedPdu.data;
            this.translator.setContextName(this.resp, snmpDecryptedPdu.contextName);
            this.translator.setContextEngineId(this.resp, snmpDecryptedPdu.contextEngineId);
        }
        return this.resp;
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        return this.factory.decodeSnmpPdu(this.resp);
    }

    public String printMessage() {
        return this.resp.printMessage();
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

