/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.UserAcl;

import com.sun.jdmk.snmp.UserAcl.AclImpl;
import com.sun.jdmk.snmp.UserAcl.Node;
import com.sun.jdmk.snmp.UserAcl.Parser;
import com.sun.jdmk.snmp.UserAcl.ParserTreeConstants;
import com.sun.jdmk.snmp.UserAcl.PrincipalImpl;
import java.util.Hashtable;

class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser, int n) {
        this(n);
        this.parser = parser;
    }

    public static Node jjtCreate(int n) {
        return new SimpleNode(n);
    }

    public static Node jjtCreate(Parser parser, int n) {
        return new SimpleNode(parser, n);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void buildTrapEntries(Hashtable hashtable) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.buildTrapEntries(hashtable);
                }
                ++n;
            }
        }
    }

    public void buildInformEntries(Hashtable hashtable) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.buildInformEntries(hashtable);
                }
                ++n;
            }
        }
    }

    public void buildAclEntries(PrincipalImpl principalImpl, AclImpl aclImpl) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.buildAclEntries(principalImpl, aclImpl);
                }
                ++n;
            }
        }
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }
}

