/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.UserAcl;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.snmp.UserAcl.AclEntryImpl;
import com.sun.jdmk.snmp.UserAcl.AclImpl;
import com.sun.jdmk.snmp.UserAcl.ParseException;
import com.sun.jdmk.snmp.UserAcl.Parser;
import com.sun.jdmk.snmp.UserAcl.PermissionImpl;
import com.sun.jdmk.snmp.UserAcl.PrincipalImpl;
import com.sun.jdmk.snmp.UserAcl.SimpleNode;
import com.sun.jdmk.trace.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.snmp.UserAcl;

public class JdmkUserAcl
implements UserAcl,
Serializable {
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable trapDestList;
    private Hashtable informDestList;
    private PrincipalImpl owner;

    public JdmkUserAcl(String string) throws IllegalArgumentException {
        block2: {
            this.dbgTag = "JdmkUserAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, string);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
                aclEntryImpl.addPermission(READ);
                aclEntryImpl.addPermission(WRITE);
                this.acl.addEntry(this.owner, aclEntryImpl);
            }
            catch (NotOwnerException notOwnerException) {
                if (!this.isDebugOn()) break block2;
                this.debug("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        this.setDefautFileName();
        this.readAuthorisedListFile();
    }

    public Enumeration entries() {
        return this.acl.entries();
    }

    public String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public void setAuthorizedListFile(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            if (this.isDebugOn()) {
                this.debug("setAuthorizedListFile", "User ACL file not found. Wrong passed file : " + string);
            }
            throw new IllegalArgumentException("The specified file [" + string + "] doesn't exist or is not a file, no configuration loaded");
        }
        if (this.isTraceOn()) {
            this.trace("setAuthorizedListFile", "Default file set to " + string);
        }
        this.authorizedListFile = string;
    }

    public void rereadTheFile() throws NotOwnerException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorisedListFile();
    }

    public String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public boolean checkReadPermission(String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, READ);
    }

    public boolean checkReadPermission(String string, String string2, int n) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, string2, n, READ);
    }

    public boolean checkContextName(String string) {
        return this.acl.checkContextName(string);
    }

    public boolean checkWritePermission(String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    public boolean checkWritePermission(String string, String string2, int n) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, string2, n, WRITE);
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (this.isTraceOn()) {
                this.trace("readAuthorisedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Object object;
            Parser parser = null;
            try {
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorisedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                object = parser.SecurityDefs();
                ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                ((SimpleNode)object).buildTrapEntries(this.trapDestList);
                ((SimpleNode)object).buildInformEntries(this.informDestList);
            }
            catch (ParseException parseException) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorisedListFile", "Parsing exception " + parseException);
                }
                throw new IllegalArgumentException(parseException.getMessage());
            }
            catch (Error error) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorisedListFile", "Error exception");
                }
                throw new IllegalArgumentException(error.getMessage());
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                if (this.isTraceOn()) {
                    this.trace("readAuthorisedListFile", "===> " + aclEntryImpl.getPrincipal().toString());
                }
                Enumeration enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Permission permission = (Permission)enumeration.nextElement();
                    if (!this.isTraceOn()) continue;
                    this.trace("readAuthorisedListFile", "perm = " + permission);
                }
            }
        }
    }

    private void setDefautFileName() throws IllegalArgumentException {
        String string = null;
        File file = null;
        string = System.getProperty("jdmk.uacl.file");
        if (string == null) {
            string = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.uacl");
            if (this.isDebugOn()) {
                this.debug("setDefautFileName", "Default File name is : " + string);
            }
            if ((file = new File(string)).isFile()) {
                if (this.isTraceOn()) {
                    this.trace("setDefautFileName", "Default User ACL file found : " + string);
                }
            } else if (this.isDebugOn()) {
                this.debug("setDefautFileName", "Default User ACL file not found.");
            }
        } else {
            file = new File(string);
            if (!file.isFile()) {
                if (this.isDebugOn()) {
                    this.debug("setDefautFileName", "User ACL file not found. Wrong java property : jdmk.uacl.file=" + string);
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
            }
            if (this.isTraceOn()) {
                this.trace("setDefautFileName", "User ACL file found : " + string);
            }
        }
        this.authorizedListFile = string;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

