/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.UserAcl;

import com.sun.jdmk.snmp.UserAcl.AclEntryImpl;
import com.sun.jdmk.snmp.UserAcl.OwnerImpl;
import com.sun.jdmk.snmp.UserAcl.PrincipalImpl;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclImpl
extends OwnerImpl
implements Acl,
Serializable {
    private Vector entryList = new Vector();
    private String aclName = null;

    public AclImpl(PrincipalImpl principalImpl, String string) {
        super(principalImpl);
        this.aclName = string;
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.aclName = string;
    }

    public String getName() {
        return this.aclName;
    }

    public boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        if (this.entryList.contains(aclEntry)) {
            return false;
        }
        this.entryList.addElement(aclEntry);
        return true;
    }

    public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        return this.entryList.removeElement(aclEntry);
    }

    public void removeAll(Principal principal) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.entryList.removeAllElements();
    }

    public Enumeration getPermissions(Principal principal) {
        Vector vector = new Vector();
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            if (!aclEntry.getPrincipal().equals(principal)) continue;
            return aclEntry.permissions();
        }
        return vector.elements();
    }

    public Enumeration entries() {
        return this.entryList.elements();
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            if (!aclEntry.getPrincipal().equals(principal) || !aclEntry.checkPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPermission(Principal principal, String string, int n, Permission permission) {
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
            int n2 = aclEntryImpl.getSecurityLevel();
            if (!aclEntryImpl.getPrincipal().equals(principal) || !aclEntryImpl.checkPermission(permission) || !aclEntryImpl.checkContextName(string) || !aclEntryImpl.checkSecurityLevel(n)) continue;
            return true;
        }
        return false;
    }

    public boolean checkContextName(String string) {
        Enumeration enumeration = this.entryList.elements();
        while (enumeration.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
            if (!aclEntryImpl.checkContextName(string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AclImpl: " + this.getName();
    }
}

