/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.UserAcl;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclEntryImpl
implements AclEntry,
Serializable {
    private int securityLevel = -1;
    private Principal princ = null;
    private boolean neg = false;
    private Vector permList = null;
    private Vector commList = null;

    private AclEntryImpl(AclEntryImpl aclEntryImpl) {
        this.setPrincipal(aclEntryImpl.getPrincipal());
        this.setSecurityLevel(aclEntryImpl.getSecurityLevel());
        this.permList = new Vector();
        this.commList = new Vector();
        Enumeration enumeration = aclEntryImpl.contextNames();
        while (enumeration.hasMoreElements()) {
            this.addContextName((String)enumeration.nextElement());
        }
        Enumeration enumeration2 = aclEntryImpl.permissions();
        while (enumeration2.hasMoreElements()) {
            this.addPermission((Permission)enumeration2.nextElement());
        }
        if (aclEntryImpl.isNegative()) {
            this.setNegativePermissions();
        }
    }

    public AclEntryImpl() {
        this.princ = null;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public AclEntryImpl(Principal principal) {
        this.princ = principal;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public Object clone() {
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this);
        return aclEntryImpl;
    }

    public boolean isNegative() {
        return this.neg;
    }

    public boolean addPermission(Permission permission) {
        if (this.permList.contains(permission)) {
            return false;
        }
        this.permList.addElement(permission);
        return true;
    }

    public boolean removePermission(Permission permission) {
        if (!this.permList.contains(permission)) {
            return false;
        }
        this.permList.removeElement(permission);
        return true;
    }

    public boolean checkPermission(Permission permission) {
        return this.permList.contains(permission);
    }

    public Enumeration permissions() {
        return this.permList.elements();
    }

    public void setNegativePermissions() {
        this.neg = true;
    }

    public Principal getPrincipal() {
        return this.princ;
    }

    public boolean setPrincipal(Principal principal) {
        if (this.princ != null) {
            return false;
        }
        this.princ = principal;
        return true;
    }

    public String toString() {
        return "AclEntry:" + this.princ.toString();
    }

    public Enumeration contextNames() {
        return this.commList.elements();
    }

    public boolean addContextName(String string) {
        if (this.commList.contains(string)) {
            return false;
        }
        this.commList.addElement(string);
        return true;
    }

    public boolean removeContextName(String string) {
        if (!this.commList.contains(string)) {
            return false;
        }
        this.commList.removeElement(string);
        return true;
    }

    public boolean checkContextName(String string) {
        return this.commList.contains(string);
    }

    public boolean checkSecurityLevel(int n) {
        return this.securityLevel == n;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int n) {
        this.securityLevel = n;
    }
}

