/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.IPAcl;

import com.sun.jdmk.snmp.IPAcl.PrincipalImpl;
import com.sun.jdmk.trace.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

class NetMaskImpl
extends PrincipalImpl
implements Group,
Serializable {
    protected byte[] subnet = null;
    protected int prefix = -1;
    String dbgTag = "NetMaskImpl";

    public NetMaskImpl() throws UnknownHostException {
    }

    private byte[] extractSubNet(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        byte[] byArray2 = null;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "BINARY ARRAY :");
            StringBuffer stringBuffer = new StringBuffer();
            n2 = 0;
            while (n2 < n3) {
                stringBuffer.append((byArray[n2] & 0xFF) + ":");
                ++n2;
            }
            this.debug("extractSubNet", stringBuffer.toString());
        }
        if ((n = this.prefix / 8) == n3) {
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " The mask is the complete address, strange..." + n3);
            }
            byArray2 = byArray;
            return byArray2;
        }
        if (n > n3) {
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " The number of covered byte is longer than the address. BUG");
            }
            throw new IllegalArgumentException("The number of covered byte is longer than the address.");
        }
        n2 = n;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Partialy covered index : " + n2);
        }
        byte by = byArray[n2];
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Partialy covered byte : " + by);
        }
        int n4 = this.prefix % 8;
        int n5 = 0;
        n5 = n4 == 0 ? n2 : n2 + 1;
        if (this.isDebugOn()) {
            this.debug("extractSubNet", " Remains : " + n4);
        }
        byte by2 = 0;
        int n6 = 0;
        while (n6 < n4) {
            by2 = (byte)(by2 | 1 << 7 - n6);
            ++n6;
        }
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Mask value" + (by2 & 0xFF));
        }
        byte by3 = (byte)(by & by2);
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Masked byte :" + (by3 & 0xFF));
        }
        byArray2 = new byte[n5];
        if (this.isDebugOn()) {
            this.debug("extractSubNet", "Resulting subnet : ");
        }
        int n7 = 0;
        while (n7 < n2) {
            byArray2[n7] = byArray[n7];
            if (this.isDebugOn()) {
                this.debug("extractSubNet", (byArray2[n7] & 0xFF) + ":");
            }
            ++n7;
        }
        if (n4 != 0) {
            byArray2[n2] = by3;
            if (this.isDebugOn()) {
                this.debug("extractSubNet", " Last subnet byte : " + (byArray2[n2] & 0xFF));
            }
        }
        return byArray2;
    }

    public NetMaskImpl(String string, int n) throws UnknownHostException {
        super(string);
        this.prefix = n;
        this.subnet = this.extractSubNet(this.getAddress().getAddress());
    }

    public boolean addMember(Principal principal) {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PrincipalImpl || object instanceof NetMaskImpl) {
            PrincipalImpl principalImpl = (PrincipalImpl)object;
            InetAddress inetAddress = principalImpl.getAddress();
            if (this.isDebugOn()) {
                this.debug("equals", "Received Address : " + inetAddress);
            }
            byte[] byArray = inetAddress.getAddress();
            int n = 0;
            while (n < this.subnet.length) {
                if (this.isDebugOn()) {
                    this.debug("equals", "(recAddr[i]) :" + (byArray[n] & 0xFF));
                    this.debug("equals", "(recAddr[i] & subnet[i]) :" + (byArray[n] & this.subnet[n] & 0xFF) + "subnet[i] :" + (this.subnet[n] & 0xFF));
                }
                if ((byArray[n] & this.subnet[n]) != this.subnet[n]) {
                    if (this.isDebugOn()) {
                        this.debug("equals", "FALSE");
                    }
                    return false;
                }
                ++n;
            }
            if (this.isDebugOn()) {
                this.debug("equals", "TRUE");
            }
            return true;
        }
        return false;
    }

    public boolean isMember(Principal principal) {
        return (principal.hashCode() & super.hashCode()) == principal.hashCode();
    }

    public Enumeration members() {
        Vector<NetMaskImpl> vector = new Vector<NetMaskImpl>(1);
        vector.addElement(this);
        return vector.elements();
    }

    public boolean removeMember(Principal principal) {
        return true;
    }

    public String toString() {
        return "NetMaskImpl :" + super.getAddress().toString() + "/" + this.prefix;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

