/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp.IPAcl;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.snmp.IPAcl.AclEntryImpl;
import com.sun.jdmk.snmp.IPAcl.AclImpl;
import com.sun.jdmk.snmp.IPAcl.IPAcl;
import com.sun.jdmk.snmp.IPAcl.ParseException;
import com.sun.jdmk.snmp.IPAcl.Parser;
import com.sun.jdmk.snmp.IPAcl.PermissionImpl;
import com.sun.jdmk.snmp.IPAcl.PrincipalImpl;
import com.sun.jdmk.snmp.IPAcl.SimpleNode;
import com.sun.jdmk.trace.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JdmkAcl
implements IPAcl,
Serializable {
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable trapDestList;
    private Hashtable informDestList;
    private PrincipalImpl owner;

    public JdmkAcl(String string) throws UnknownHostException, IllegalArgumentException {
        block2: {
            this.dbgTag = "JdmkAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, string);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
                aclEntryImpl.addPermission(READ);
                aclEntryImpl.addPermission(WRITE);
                this.acl.addEntry(this.owner, aclEntryImpl);
            }
            catch (NotOwnerException notOwnerException) {
                if (!this.isDebugOn()) break block2;
                this.debug("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        this.setDefautFileName();
        this.readAuthorisedListFile();
    }

    public Enumeration entries() {
        return this.acl.entries();
    }

    public String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public void setAuthorizedListFile(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (!file.isFile()) {
            if (this.isDebugOn()) {
                this.debug("setAuthorizedListFile", "Ip ACL file not found. Wrong passed file : " + string);
            }
            throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
        }
        if (this.isTraceOn()) {
            this.trace("setAuthorizedListFile", "Default file set to " + string);
        }
        this.authorizedListFile = string;
    }

    public void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorisedListFile();
    }

    public String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public boolean checkReadPermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, READ);
    }

    public boolean checkReadPermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, READ);
    }

    public boolean checkCommunity(String string) {
        return this.acl.checkCommunity(string);
    }

    public boolean checkWritePermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    public boolean checkWritePermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, WRITE);
    }

    public Enumeration getTrapDestinations() {
        return this.trapDestList.keys();
    }

    public Enumeration getTrapCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.trapDestList.get(inetAddress);
        if (vector != null) {
            if (this.isTraceOn()) {
                this.trace("getTrapCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (this.isTraceOn()) {
            this.trace("getTrapCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    public Enumeration getInformDestinations() {
        return this.informDestList.keys();
    }

    public Enumeration getInformCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.informDestList.get(inetAddress);
        if (vector != null) {
            if (this.isTraceOn()) {
                this.trace("getInformCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (this.isTraceOn()) {
            this.trace("getInformCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (this.isTraceOn()) {
                this.trace("readAuthorisedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Object object;
            Parser parser = null;
            try {
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorisedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                object = parser.SecurityDefs();
                ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                ((SimpleNode)object).buildTrapEntries(this.trapDestList);
                ((SimpleNode)object).buildInformEntries(this.informDestList);
            }
            catch (ParseException parseException) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorisedListFile", "Parsing exception " + parseException);
                }
                throw new IllegalArgumentException(parseException.getMessage());
            }
            catch (Error error) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorisedListFile", "Error exception");
                }
                throw new IllegalArgumentException(error.getMessage());
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                if (this.isTraceOn()) {
                    this.trace("readAuthorisedListFile", "===> " + aclEntryImpl.getPrincipal().toString());
                }
                Enumeration enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Permission permission = (Permission)enumeration.nextElement();
                    if (!this.isTraceOn()) continue;
                    this.trace("readAuthorisedListFile", "perm = " + permission);
                }
            }
        }
    }

    private void setDefautFileName() throws IllegalArgumentException {
        String string = null;
        File file = null;
        string = System.getProperty("jdmk.acl.file");
        if (string == null) {
            string = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.acl");
            if (this.isDebugOn()) {
                this.debug("setDefautFileName", "Default File name is : " + string);
            }
            if ((file = new File(string)).isFile()) {
                if (this.isTraceOn()) {
                    this.trace("setDefautFileName", "Default Ip ACL file found : " + string);
                }
            } else if (this.isDebugOn()) {
                this.debug("setDefautFileName", "Default Ip ACL file not found.");
            }
        } else {
            file = new File(string);
            if (!file.isFile()) {
                if (this.isDebugOn()) {
                    this.debug("setDefautFileName", "Ip ACL file not found. Wrong java property : jdmk.acl.file=" + string);
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
            }
            if (this.isTraceOn()) {
                this.trace("setDefautFileName", "Ip ACL file found : " + string);
            }
        }
        this.authorizedListFile = string;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

