/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp;

import com.sun.jdmk.Enumerated;
import java.io.Serializable;
import java.util.Hashtable;
import javax.management.snmp.SnmpInt;

public class EnumRowStatus
extends Enumerated
implements Serializable {
    public static final int unspecified = 0;
    public static final int active = 1;
    public static final int notInService = 2;
    public static final int notReady = 3;
    public static final int createAndGo = 4;
    public static final int createAndWait = 5;
    public static final int destroy = 6;
    static final Hashtable intTable = new Hashtable();
    static final Hashtable stringTable = new Hashtable();

    public EnumRowStatus(int n) throws IllegalArgumentException {
        super(n);
    }

    public EnumRowStatus(Enumerated enumerated) throws IllegalArgumentException {
        this(enumerated.intValue());
    }

    public EnumRowStatus(long l) throws IllegalArgumentException {
        this((int)l);
    }

    public EnumRowStatus(Integer n) throws IllegalArgumentException {
        super(n);
    }

    public EnumRowStatus(Long l) throws IllegalArgumentException {
        this((long)l);
    }

    public EnumRowStatus() throws IllegalArgumentException {
        this(0);
    }

    public EnumRowStatus(String string) throws IllegalArgumentException {
        super(string);
    }

    public EnumRowStatus(SnmpInt snmpInt) throws IllegalArgumentException {
        this(snmpInt.intValue());
    }

    public SnmpInt toSnmpValue() throws IllegalArgumentException {
        if (this.value == 0) {
            throw new IllegalArgumentException("`unspecified' is not a valid SNMP value.");
        }
        return new SnmpInt(this.value);
    }

    public static boolean isValidValue(int n) {
        if (n < 0) {
            return false;
        }
        return n <= 6;
    }

    protected Hashtable getIntTable() {
        return EnumRowStatus.getRSIntTable();
    }

    protected Hashtable getStringTable() {
        return EnumRowStatus.getRSStringTable();
    }

    static final Hashtable getRSIntTable() {
        return intTable;
    }

    static final Hashtable getRSStringTable() {
        return stringTable;
    }

    static {
        intTable.put(new Integer(0), "unspecified");
        intTable.put(new Integer(3), "notReady");
        intTable.put(new Integer(6), "destroy");
        intTable.put(new Integer(2), "notInService");
        intTable.put(new Integer(5), "createAndWait");
        intTable.put(new Integer(1), "active");
        intTable.put(new Integer(4), "createAndGo");
        stringTable.put("unspecified", new Integer(0));
        stringTable.put("notReady", new Integer(3));
        stringTable.put("destroy", new Integer(6));
        stringTable.put("notInService", new Integer(2));
        stringTable.put("createAndWait", new Integer(5));
        stringTable.put("active", new Integer(1));
        stringTable.put("createAndGo", new Integer(4));
    }
}

