/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal.snmp;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.internal.snmp.SnmpLcd;
import com.sun.jdmk.trace.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import javax.management.snmp.SnmpEngineId;

public class SnmpJdmkLcd
extends SnmpLcd {
    String engineId = null;
    File file = null;
    int engineBoots = -1;
    private String header = "\n# #####APPENDED PROPERTY####\n";
    String dbgTag = "SnmpJdmkLcd";

    public SnmpJdmkLcd(String string) throws IllegalArgumentException {
        this.handleSecurityFileLocation(string);
    }

    private void handleSecurityFileLocation(String string) throws IllegalArgumentException {
        String string2 = null;
        if (string == null) {
            string2 = System.getProperty("jdmk.security.file");
            if (string2 == null) {
                if (this.isDebugOn()) {
                    this.debug("constructor", "Security file not found. Use default one.");
                }
                string2 = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.security");
                this.file = new File(string2);
                if (!this.file.exists()) {
                    this.file = null;
                    if (this.isTraceOn()) {
                        this.trace("SnmpJdmkLcd", "The default file [" + string2 + "] doesn't exist.");
                    }
                    return;
                }
            } else {
                this.file = new File(string2);
                if (!this.file.exists() && this.isTraceOn()) {
                    this.trace("handleSecurityFileLocation", "The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                    throw new IllegalArgumentException("The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                }
            }
        } else {
            this.file = new File(string);
            if (!this.file.exists() && this.isTraceOn()) {
                this.trace("handleSecurityFileLocation", "The specified file [" + this.file + "] doesn't exist, no configuration loaded");
                throw new IllegalArgumentException("The specified file [" + this.file + "] doesn't exist, no configuration loaded");
            }
        }
    }

    File getFile() {
        return this.file;
    }

    public void storeEngineBoots(int n) {
        if (this.getFile() == null) {
            return;
        }
        String string = "localEngineBoots";
        this.flushProperty(string, String.valueOf(n));
    }

    public void storeEngineId(SnmpEngineId snmpEngineId) {
        if (this.getFile() == null) {
            return;
        }
        String string = "localEngineID";
        this.flushProperty(string, snmpEngineId.getReadableId() == null ? snmpEngineId.toString() : snmpEngineId.getReadableId());
    }

    public int getEngineBoots() {
        String string;
        if (this.getFile() == null) {
            return -1;
        }
        if (this.engineBoots == -1 && (string = this.getProperty("localEngineBoots")) != null) {
            this.engineBoots = Integer.parseInt(string);
        }
        return this.engineBoots;
    }

    public String getEngineId() {
        if (this.getFile() == null) {
            return null;
        }
        if (this.engineId == null) {
            this.engineId = this.getProperty("localEngineID");
        }
        return this.engineId;
    }

    /*
     * Unable to fully structure code
     */
    private String getProperty(String var1_1) {
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        if (!this.file.exists()) {
            if (this.isTraceOn()) {
                this.trace("getProperty", "The specified file [" + this.file + "] doesn't exist, the property " + var1_1 + "] can't be loaded.");
            }
            return null;
        }
        try {
            var3_3 = new FileReader(this.file);
            var4_4 = new BufferedReader(var3_3);
        }
        catch (IOException var5_5) {
            if (this.isDebugOn()) {
                this.debug("getProperty", "The specified file was not found, no configuration loaded");
            }
            return null;
        }
        try {
            var2_2 = var4_4.readLine();
            if (true) ** GOTO lbl36
        }
        catch (IOException var5_6) {
            if (this.isTraceOn()) {
                this.trace("getProperty", var5_6.toString());
            }
            return null;
        }
        do {
            try {
                if (var2_2.startsWith(var1_1 + "=")) {
                    var4_4.close();
                    var5_8 = var2_2.indexOf("=");
                    if (var5_8 == var2_2.length() - 1) {
                        return null;
                    }
                    return var2_2.substring(var5_8 + 1);
                }
                var2_2 = var4_4.readLine();
            }
            catch (IOException var5_7) {
                if (!this.isDebugOn()) continue;
                this.debug("getProperty", var5_7);
            }
lbl36:
            // 4 sources

        } while (var2_2 != null);
        try {
            var4_4.close();
        }
        catch (IOException var5_9) {
            if (this.isDebugOn()) {
                this.debug("getProperty", var5_9);
            }
            return null;
        }
        return null;
    }

    private void flushProperty(String string, String string2) {
        block19: {
            BufferedWriter bufferedWriter = null;
            BufferedReader bufferedReader = null;
            OutputStreamWriter outputStreamWriter = null;
            InputStreamReader inputStreamReader = null;
            try {
                String string3;
                String string4 = null;
                boolean bl = false;
                String string5 = this.file.getParent();
                boolean bl2 = false;
                String string6 = this.file.getName();
                File file = File.createTempFile(string6, null, this.file.getParentFile());
                if (this.isDebugOn()) {
                    this.debug("flushProperty", "tmp file : " + file);
                }
                outputStreamWriter = new FileWriter(file);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                inputStreamReader = new FileReader(this.file);
                bufferedReader = new BufferedReader(inputStreamReader);
                string4 = bufferedReader.readLine();
                while (string4 != null) {
                    string3 = string4;
                    if (!bl2 && string4.startsWith(string + "=")) {
                        if (this.isDebugOn()) {
                            this.debug("flushProperty", "Found property [" + string + "], new value [" + string2 + "]");
                        }
                        string3 = string + "=" + string2;
                        bl2 = true;
                    }
                    bufferedWriter.write(string3, 0, string3.length());
                    bufferedWriter.newLine();
                    string4 = bufferedReader.readLine();
                }
                if (!bl2) {
                    string3 = string + "=" + string2;
                    if (this.isDebugOn()) {
                        this.debug("flushProperty", "Property not found!");
                    }
                    bufferedWriter.write(this.header, 0, this.header.length());
                    bufferedWriter.write(string3, 0, string3.length());
                }
                bufferedWriter.close();
                bufferedReader.close();
                inputStreamReader.close();
                outputStreamWriter.close();
                this.file.delete();
                if (!file.renameTo(this.file)) {
                    if (this.isDebugOn()) {
                        this.debug("flushProperty", "Unable to rename the tmp file, property [" + string + "] can't be flushed");
                    }
                } else if (this.isDebugOn()) {
                    this.debug("flushProperty", "Tmp file renamed, property [" + string + "] flushed, value [" + string2 + "]");
                }
            }
            catch (Exception exception) {
                if (this.isDebugOn()) {
                    this.debug("flushProperty", exception);
                }
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (Exception exception2) {
                    if (!this.isDebugOn()) break block19;
                    this.debug("flushProperty", exception);
                }
            }
        }
    }

    private void storeProperty(String string, String string2) {
        String string3 = null;
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        if (!this.file.exists()) {
            if (this.isTraceOn()) {
                this.trace("storeProperty", "The specified file [" + this.file + "] doesn't exist, the property " + string + "] can't be stored.");
            }
            return;
        }
        try {
            randomAccessFile = new RandomAccessFile(this.file, "rw");
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("storeProperty", "No file to read");
            }
            return;
        }
        try {
            byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.seek(0L);
            string3 = randomAccessFile.readLine();
            while (string3 != null) {
                if (string3.startsWith(string + "=")) {
                    int n = string3.substring(string3.indexOf("=") + 1).length();
                    System.out.println("CUR :" + n);
                    int n2 = n - string2.length();
                    System.out.println("DELTA :" + n2);
                    int n3 = (int)randomAccessFile.getFilePointer();
                    System.out.println("SAVE :" + n3);
                    System.out.println("save - row.length() - 1 : " + (n3 - string3.length() - 1));
                    randomAccessFile.seek(n3 - string3.length() - 1);
                    randomAccessFile.writeBytes(string + "=" + string2);
                    int n4 = (int)randomAccessFile.getFilePointer() + n2;
                    int n5 = byArray.length - ((int)randomAccessFile.getFilePointer() + n2);
                    randomAccessFile.write(byArray, n4, n5);
                    if (n2 > 0) {
                        randomAccessFile.setLength(randomAccessFile.length() - (long)n2);
                    }
                    bl = true;
                    break;
                }
                string3 = randomAccessFile.readLine();
            }
            if (!bl) {
                randomAccessFile.writeBytes("\n# #####APPENDED PROPERTY####\n");
                randomAccessFile.writeBytes(string + "=" + string2 + "\n");
            }
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("storeProperty", iOException);
            }
            return;
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

