/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal.snmp;

import com.sun.jdmk.internal.snmp.SnmpAccessControlModel;
import com.sun.jdmk.internal.snmp.SnmpModelImpl;
import com.sun.jdmk.internal.snmp.SnmpSubSystem;
import com.sun.jdmk.snmp.IPAcl.IPAcl;
import com.sun.jdmk.trace.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPdu;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.UserAcl;

public class SnmpJdmkAcm
extends SnmpModelImpl
implements SnmpAccessControlModel {
    private IPAcl ipacl = null;
    private boolean activatev3 = true;
    private boolean v1v2setrequest = false;
    private UserAcl useracl = null;
    String dbgTag = "SnmpJdmkAcm";

    public SnmpJdmkAcm(SnmpSubSystem snmpSubSystem, IPAcl iPAcl, UserAcl userAcl, boolean bl) {
        super(snmpSubSystem, "User based");
        this.ipacl = iPAcl;
        this.useracl = userAcl;
        snmpSubSystem.addModel(0, this);
        snmpSubSystem.addModel(1, this);
        this.activatev3 = bl;
        if (bl) {
            snmpSubSystem.addModel(3, this);
        }
    }

    private boolean isV3Activated() {
        return this.activatev3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPduAccess(int n, String string, int n2, int n3, int n4, byte[] byArray, SnmpPdu snmpPdu) throws SnmpStatusException {
        if (this.isTraceOn()) {
            this.trace("checkPduAccess", "sender is " + string + " with " + new String(byArray));
        }
        if (byArray == null) {
            throw new SnmpStatusException(16);
        }
        switch (n) {
            case 0: 
            case 1: {
                if (this.isV3Activated()) {
                    if (n3 == 163) {
                        SnmpJdmkAcm snmpJdmkAcm = this;
                        synchronized (snmpJdmkAcm) {
                            if (!this.isSnmpV1V2SetRequestAuthorized()) {
                                if (this.isTraceOn()) {
                                    this.trace("checkPduAccess", "sender is " + string + " with " + new String(byArray) + " \n SNMP V1 and V2 set requests disable. Access not granted.");
                                }
                                throw new SnmpStatusException(16);
                            }
                        }
                    }
                    this.checkIPAcl(byArray, string, n3);
                    break;
                }
                this.checkIPAcl(byArray, string, n3);
                break;
            }
            case 3: {
                this.checkUserAcl(byArray, string, n3, n2);
                break;
            }
            default: {
                if (this.isDebugOn()) {
                    this.debug("checkPduAccess", "Unsupported protocol version.");
                }
                throw new SnmpStatusException(4);
            }
        }
    }

    public void checkAccess(int n, String string, int n2, int n3, int n4, byte[] byArray, SnmpOid snmpOid) throws SnmpStatusException {
    }

    private void checkIPAcl(byte[] byArray, String string, int n) throws SnmpStatusException {
        String string2 = new String(byArray);
        if (this.isTraceOn()) {
            this.trace("checkIPAcl", "sender is " + string + " with " + string2);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (this.isTraceOn()) {
                this.trace("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                this.trace("checkIPAcl", "Bad IP address");
            }
            throw new SnmpStatusException(4);
        }
        if (this.ipacl != null) {
            if (n == 163) {
                if (!this.ipacl.checkWritePermission(inetAddress, string2)) {
                    if (this.isTraceOn()) {
                        this.trace("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                        this.trace("checkIPAcl", "sender has no write permission");
                    }
                    throw new SnmpStatusException(4);
                }
                if (this.isTraceOn()) {
                    this.trace("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                    this.trace("checkIPAcl", "sender has write permission");
                }
            } else {
                if (!this.ipacl.checkReadPermission(inetAddress, string2)) {
                    if (this.isTraceOn()) {
                        this.trace("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                        this.trace("checkIPAcl", "sender has no read permission");
                    }
                    throw new SnmpStatusException(2);
                }
                if (this.isTraceOn()) {
                    this.trace("checkIPAcl", "sender is " + inetAddress + " with " + string2);
                    this.trace("checkIPAcl", "sender has read permission");
                }
            }
        }
    }

    private void checkUserAcl(byte[] byArray, String string, int n, int n2) throws SnmpStatusException {
        String string2 = null;
        if (byArray.length != 0) {
            string2 = new String(byArray);
        } else {
            if (this.isTraceOn()) {
                this.trace("checkUserAcl", "Received a null context");
            }
            string2 = "null";
        }
        if (this.isTraceOn()) {
            this.trace("checkUserAcl", "sender is " + string + " with [" + string2 + "], security level : " + n2);
        }
        if (this.useracl != null) {
            if (n == 163) {
                if (!this.useracl.checkWritePermission(string, string2, n2)) {
                    if (this.isTraceOn()) {
                        this.trace("checkUserAcl", "sender is " + string + " with " + string2);
                        this.trace("checkUserAcl", "sender has no write permission");
                    }
                    throw new SnmpStatusException(16);
                }
                if (this.isTraceOn()) {
                    this.trace("checkUserAcl", "sender is " + string + " with " + string2);
                    this.trace("checkUserAcl", "sender has write permission");
                }
            } else {
                if (!this.useracl.checkReadPermission(string, string2, n2)) {
                    if (this.isTraceOn()) {
                        this.trace("checkUserAcl", "sender is " + string + " with " + string2);
                        this.trace("checkUserAcl", "sender has no read permission");
                    }
                    throw new SnmpStatusException(16);
                }
                if (this.isTraceOn()) {
                    this.trace("checkUserAcl", "sender is " + string + " with " + string2);
                    this.trace("checkUserAcl", "sender has read permission");
                }
            }
        }
    }

    public synchronized boolean enableSnmpV1V2SetRequest() {
        this.v1v2setrequest = true;
        return true;
    }

    public synchronized boolean disableSnmpV1V2SetRequest() {
        this.v1v2setrequest = false;
        return true;
    }

    public synchronized boolean isSnmpV1V2SetRequestAuthorized() {
        return this.v1v2setrequest;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

