/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal.snmp;

import com.sun.jdmk.internal.snmp.SnmpAccessControlSubSystem;
import com.sun.jdmk.internal.snmp.SnmpLcd;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.internal.snmp.SnmpSecuritySubSystem;
import com.sun.jdmk.snmp.SnmpBadSecurityLevelException;
import com.sun.jdmk.trace.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineFactory;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpUsmKeyHandler;

public class SnmpEngineImpl
implements SnmpEngine,
Serializable {
    public static final int noAuthNoPriv = 0;
    public static final int authNoPriv = 1;
    public static final int authPriv = 3;
    public static final int reportableFlag = 4;
    public static final int authMask = 1;
    public static final int privMask = 2;
    public static final int authPrivMask = 3;
    private SnmpEngineId engineid = null;
    private SnmpEngineFactory factory = null;
    private long startTime = 0L;
    private int boot = 0;
    private boolean checkOid = false;
    private transient SnmpUsmKeyHandler usmKeyHandler = null;
    private transient SnmpLcd lcd = null;
    private transient SnmpSecuritySubSystem securitySub = null;
    private transient SnmpMsgProcessingSubSystem messageSub = null;
    private transient SnmpAccessControlSubSystem accessSub = null;
    String dbgTag = "SnmpEngineImpl";

    public synchronized int getEngineTime() {
        long l = System.currentTimeMillis() / 1000L - this.startTime;
        if (l > Integer.MAX_VALUE) {
            this.startTime = System.currentTimeMillis() / 1000L;
            if (this.boot != Integer.MAX_VALUE) {
                ++this.boot;
            }
            this.storeNBBoots(this.boot);
        }
        return (int)(System.currentTimeMillis() / 1000L - this.startTime);
    }

    public SnmpEngineId getEngineId() {
        return this.engineid;
    }

    public SnmpUsmKeyHandler getUsmKeyHandler() {
        return this.usmKeyHandler;
    }

    public SnmpLcd getLcd() {
        return this.lcd;
    }

    public int getEngineBoots() {
        return this.boot;
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd, SnmpEngineId snmpEngineId) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = snmpEngineId != null ? snmpEngineId : SnmpEngineId.createEngineId();
        }
        snmpLcd.storeEngineId(this.engineid);
        if (this.isTraceOn()) {
            this.trace("SnmpEngine", "LOCAL ENGINE ID: " + this.engineid);
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd, InetAddress inetAddress, int n) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId(inetAddress, n);
        }
        snmpLcd.storeEngineId(this.engineid);
        if (this.isTraceOn()) {
            this.trace("SnmpEngine", "LOCAL ENGINE ID: " + this.engineid + " / " + "LOCAL ENGINE NB BOOTS: " + this.boot + " / " + "LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd, int n) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId(n);
        }
        snmpLcd.storeEngineId(this.engineid);
        if (this.isTraceOn()) {
            this.trace("SnmpEngine", "LOCAL ENGINE ID: " + this.engineid + " / " + "LOCAL ENGINE NB BOOTS: " + this.boot + " / " + "LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory snmpEngineFactory, SnmpLcd snmpLcd) throws UnknownHostException {
        this.init(snmpLcd, snmpEngineFactory);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId();
        }
        snmpLcd.storeEngineId(this.engineid);
        if (this.isTraceOn()) {
            this.trace("SnmpEngine", "LOCAL ENGINE ID: " + this.engineid + " / " + "LOCAL ENGINE NB BOOTS: " + this.boot + " / " + "LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public synchronized void activateCheckOid() {
        this.checkOid = true;
    }

    public synchronized void deactivateCheckOid() {
        this.checkOid = false;
    }

    public synchronized boolean isCheckOidActivated() {
        return this.checkOid;
    }

    private void storeNBBoots(int n) {
        if (n < 0 || n == Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
            this.lcd.storeEngineBoots(n);
        } else {
            this.lcd.storeEngineBoots(n + 1);
        }
    }

    private void init(SnmpLcd snmpLcd, SnmpEngineFactory snmpEngineFactory) {
        this.factory = snmpEngineFactory;
        this.lcd = snmpLcd;
        this.boot = snmpLcd.getEngineBoots();
        if (this.boot == -1 || this.boot == 0) {
            this.boot = 1;
        }
        this.storeNBBoots(this.boot);
        this.startTime = System.currentTimeMillis() / 1000L;
    }

    void setUsmKeyHandler(SnmpUsmKeyHandler snmpUsmKeyHandler) {
        this.usmKeyHandler = snmpUsmKeyHandler;
    }

    private void initEngineID() throws UnknownHostException {
        String string = this.lcd.getEngineId();
        if (string != null) {
            this.engineid = SnmpEngineId.createEngineId(string);
        }
    }

    public SnmpMsgProcessingSubSystem getMsgProcessingSubSystem() {
        return this.messageSub;
    }

    public void setMsgProcessingSubSystem(SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem) {
        this.messageSub = snmpMsgProcessingSubSystem;
    }

    public SnmpSecuritySubSystem getSecuritySubSystem() {
        return this.securitySub;
    }

    public void setSecuritySubSystem(SnmpSecuritySubSystem snmpSecuritySubSystem) {
        this.securitySub = snmpSecuritySubSystem;
    }

    public void setAccessControlSubSystem(SnmpAccessControlSubSystem snmpAccessControlSubSystem) {
        this.accessSub = snmpAccessControlSubSystem;
    }

    public SnmpAccessControlSubSystem getAccessControlSubSystem() {
        return this.accessSub;
    }

    public static void checkSecurityLevel(byte by) throws SnmpBadSecurityLevelException {
        int n = by & 3;
        if ((n & 2) != 0 && (n & 1) == 0) {
            throw new SnmpBadSecurityLevelException("Security level: noAuthPriv!!!");
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 64, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

