/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal.snmp;

import com.sun.jdmk.internal.snmp.SnmpEngineImpl;
import com.sun.jdmk.internal.snmp.SnmpJdmkLcd;
import com.sun.jdmk.internal.snmp.SnmpLcd;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingModel;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSysImpl;
import com.sun.jdmk.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.jdmk.internal.snmp.SnmpSecurityModel;
import com.sun.jdmk.internal.snmp.SnmpSecurityModelV1V2;
import com.sun.jdmk.internal.snmp.SnmpSecuritySubSysImpl;
import com.sun.jdmk.internal.snmp.SnmpSecuritySubSystem;
import com.sun.jdmk.internal.snmp.SnmpSubSystem;
import com.sun.jdmk.internal.snmp.SnmpUsmKeyHandlerImpl;
import com.sun.jdmk.snmp.mpm.SnmpMsgProcessingModelV1V2;
import com.sun.jdmk.snmp.mpm.SnmpMsgProcessingModelV3;
import com.sun.jdmk.snmp.usm.SnmpUserSecurityModel;
import com.sun.jdmk.snmp.usm.SnmpUsm;
import com.sun.jdmk.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.jdmk.snmp.usm.SnmpUsmDesAlgorithm;
import com.sun.jdmk.snmp.usm.SnmpUsmException;
import com.sun.jdmk.snmp.usm.SnmpUsmHmacMd5;
import com.sun.jdmk.snmp.usm.SnmpUsmHmacSha;
import com.sun.jdmk.snmp.usm.SnmpUsmLcd;
import com.sun.jdmk.snmp.usm.SnmpUsmPasswordLcd;
import com.sun.jdmk.trace.Trace;
import java.net.UnknownHostException;
import javax.management.snmp.InetAddressAcl;
import javax.management.snmp.SnmpEngine;
import javax.management.snmp.SnmpEngineFactory;
import javax.management.snmp.SnmpEngineId;
import javax.management.snmp.SnmpEngineParameters;

public class SnmpBaseEngineFactory
implements SnmpEngineFactory {
    private String dbgTag = "SnmpBaseEngineFactory";

    public SnmpEngine createEngine(SnmpEngineParameters snmpEngineParameters) throws IllegalArgumentException {
        String string = snmpEngineParameters.getSecurityFile();
        SnmpEngineId snmpEngineId = snmpEngineParameters.getEngineId();
        SnmpLcd snmpLcd = this.createEngineLcd(string);
        SnmpEngineImpl snmpEngineImpl = null;
        try {
            snmpEngineImpl = new SnmpEngineImpl((SnmpEngineFactory)this, snmpLcd, snmpEngineId);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(unknownHostException.getMessage());
        }
        this.init(snmpEngineParameters, snmpEngineImpl, snmpLcd);
        return snmpEngineImpl;
    }

    public SnmpEngine createEngine(SnmpEngineParameters snmpEngineParameters, InetAddressAcl inetAddressAcl) {
        return this.createEngine(snmpEngineParameters);
    }

    protected SnmpLcd createEngineLcd(String string) throws IllegalArgumentException {
        return new SnmpJdmkLcd(string);
    }

    protected SnmpUsmAlgorithmManager createAlgorithmManager(SnmpEngine snmpEngine) {
        return new SnmpUsmAlgorithmManager();
    }

    protected SnmpSecuritySubSystem createSecuritySubSystem(SnmpEngine snmpEngine) {
        return new SnmpSecuritySubSysImpl(snmpEngine);
    }

    protected SnmpMsgProcessingSubSystem createMsgProcessingSubSystem(SnmpEngine snmpEngine) {
        return new SnmpMsgProcessingSubSysImpl(snmpEngine);
    }

    protected SnmpUsmLcd createUsmLcd(SnmpEngine snmpEngine, SnmpLcd snmpLcd, SnmpSecuritySubSystem snmpSecuritySubSystem, String string) throws IllegalArgumentException {
        return new SnmpUsmPasswordLcd(snmpEngine, snmpSecuritySubSystem, snmpLcd, string);
    }

    protected SnmpUsm createUsmSecurityModel(SnmpEngine snmpEngine, SnmpUsmLcd snmpUsmLcd, SnmpSecuritySubSystem snmpSecuritySubSystem) {
        SnmpUserSecurityModel snmpUserSecurityModel = new SnmpUserSecurityModel((SnmpSubSystem)snmpSecuritySubSystem, snmpUsmLcd);
        return snmpUserSecurityModel;
    }

    void fillAlgorithmManager(SnmpEngineParameters snmpEngineParameters, SnmpUsmAlgorithmManager snmpUsmAlgorithmManager, SnmpEngineImpl snmpEngineImpl) {
        if (snmpUsmAlgorithmManager.getAlgorithm("usmHMACMD5AuthProtocol") == null) {
            snmpUsmAlgorithmManager.addAlgorithm(new SnmpUsmHmacMd5());
        }
        if (snmpUsmAlgorithmManager.getAlgorithm("usmHMACSHAAuthProtocol") == null) {
            snmpUsmAlgorithmManager.addAlgorithm(new SnmpUsmHmacSha());
        }
        if (snmpEngineParameters.isEncryptionEnabled()) {
            block8: {
                if (this.isDebugOn()) {
                    this.debug("init", "Usm encryption activated.");
                }
                try {
                    if (snmpUsmAlgorithmManager.getAlgorithm("usmDESPrivProtocol") == null) {
                        snmpUsmAlgorithmManager.addAlgorithm(new SnmpUsmDesAlgorithm(snmpEngineImpl));
                    }
                }
                catch (SnmpUsmException snmpUsmException) {
                    if (!this.isTraceOn()) break block8;
                    this.trace("init", "Problemm initializing encryption, check your classpath", snmpUsmException.toString());
                }
            }
            if (this.isDebugOn()) {
                this.debug("init", "Usm encryption algos added.");
            }
        }
    }

    protected SnmpSecurityModel createCommunityStringSecurityModel(SnmpEngine snmpEngine, SnmpSecuritySubSystem snmpSecuritySubSystem) {
        return new SnmpSecurityModelV1V2(snmpSecuritySubSystem);
    }

    protected SnmpMsgProcessingModel createSnmpV1MsgProcessingModel(SnmpEngine snmpEngine, SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem) {
        return new SnmpMsgProcessingModelV1V2(snmpMsgProcessingSubSystem, null);
    }

    protected SnmpMsgProcessingModel createSnmpV2MsgProcessingModel(SnmpEngine snmpEngine, SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpMsgProcessingModel snmpMsgProcessingModel) {
        return snmpMsgProcessingModel;
    }

    protected SnmpMsgProcessingModel createSnmpV3MsgProcessingModel(SnmpEngine snmpEngine, SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem, SnmpMsgProcessingModel snmpMsgProcessingModel) {
        return new SnmpMsgProcessingModelV3(snmpMsgProcessingSubSystem, null);
    }

    private void init(SnmpEngineParameters snmpEngineParameters, SnmpEngineImpl snmpEngineImpl, SnmpLcd snmpLcd) {
        if (this.isDebugOn()) {
            this.debug("init", "Starting...");
        }
        SnmpSecuritySubSystem snmpSecuritySubSystem = this.createSecuritySubSystem(snmpEngineImpl);
        SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.createMsgProcessingSubSystem(snmpEngineImpl);
        snmpMsgProcessingSubSystem.setSecuritySubSystem(snmpSecuritySubSystem);
        snmpEngineImpl.setSecuritySubSystem(snmpSecuritySubSystem);
        snmpEngineImpl.setMsgProcessingSubSystem(snmpMsgProcessingSubSystem);
        if (this.isDebugOn()) {
            this.debug("init", "Sub Systems created.");
        }
        SnmpUsmLcd snmpUsmLcd = this.createUsmLcd(snmpEngineImpl, snmpLcd, snmpSecuritySubSystem, snmpEngineParameters.getSecurityFile());
        snmpLcd.addModelLcd(snmpSecuritySubSystem, 3, snmpUsmLcd);
        if (this.isDebugOn()) {
            this.debug("init", "Usm Lcd added.");
        }
        SnmpUsm snmpUsm = this.createUsmSecurityModel(snmpEngineImpl, snmpUsmLcd, snmpSecuritySubSystem);
        SnmpSecurityModel snmpSecurityModel = this.createCommunityStringSecurityModel(snmpEngineImpl, snmpSecuritySubSystem);
        if (this.isDebugOn()) {
            this.debug("init", "Security models V1 V2 v3 added.");
        }
        SnmpUsmAlgorithmManager snmpUsmAlgorithmManager = this.createAlgorithmManager(snmpEngineImpl);
        this.fillAlgorithmManager(snmpEngineParameters, snmpUsmAlgorithmManager, snmpEngineImpl);
        if (this.isDebugOn()) {
            this.debug("init", "Usm algos added.");
        }
        snmpUsmLcd.setAlgorithmManager(snmpUsmAlgorithmManager);
        snmpUsmLcd.syncDataSource();
        if (this.isDebugOn()) {
            this.debug("init", "Usm configuration sync.");
        }
        SnmpMsgProcessingModel snmpMsgProcessingModel = this.createSnmpV1MsgProcessingModel(snmpEngineImpl, snmpMsgProcessingSubSystem);
        SnmpMsgProcessingModel snmpMsgProcessingModel2 = this.createSnmpV2MsgProcessingModel(snmpEngineImpl, snmpMsgProcessingSubSystem, snmpMsgProcessingModel);
        if (this.isDebugOn()) {
            this.debug("init", "V1 V2 processing model added. Can speak V1V2");
        }
        SnmpMsgProcessingModel snmpMsgProcessingModel3 = null;
        snmpMsgProcessingModel3 = this.createSnmpV3MsgProcessingModel(snmpEngineImpl, snmpMsgProcessingSubSystem, snmpMsgProcessingModel2);
        if (this.isDebugOn()) {
            this.debug("init", "V3 processing model added. Can speak V3");
        }
        SnmpUsmKeyHandlerImpl snmpUsmKeyHandlerImpl = new SnmpUsmKeyHandlerImpl(snmpUsmAlgorithmManager);
        snmpEngineImpl.setUsmKeyHandler(snmpUsmKeyHandlerImpl);
    }

    private boolean isTraceOn() {
        return Trace.isSelected(1, 1024);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 1024, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 1024);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 1024, string, string2, string3);
    }

    private void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

