/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.proxygen;

import com.sun.jdmk.tools.proxygen.Def;
import com.sun.jdmk.tools.proxygen.ImportList;
import com.sun.jdmk.tools.proxygen.Interface;
import com.sun.jdmk.tools.proxygen.MessageHandler;
import com.sun.jdmk.tools.proxygen.Trace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

public abstract class Generator
implements Serializable {
    private static Hashtable ConstructedName = new Hashtable();
    protected ImportList imports = new ImportList();
    protected String pkgName = "";
    protected String cName;
    protected String rName;
    protected String targetDir;
    protected String jConst = "";
    protected String extend = "";
    protected String interf = "";
    protected RandomAccessFile out;
    private static final String sccs_id = "@(#)Generator.java 4.13 05/22/02 SMI";

    public Generator(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            this.pkgName = string.substring(0, n);
        }
        this.rName = this.cName = string.substring(n + 1, string.length());
        this.targetDir = string2;
    }

    public abstract void generateCode() throws IOException;

    public void setPackageName(String string) {
        this.pkgName = string;
    }

    public String getPackageName() {
        return this.pkgName;
    }

    public void setClassName(String string) {
        this.cName = string;
    }

    public String getClassName() {
        return this.cName;
    }

    public static String getCPkg(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String getCName(Class clazz) {
        return clazz.getName();
    }

    public static String getCName(Class clazz, String string) {
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(".");
        string2 = string2.substring(n + 1, string2.length());
        if (string != null && string.length() != 0) {
            string2 = string + "." + string2;
        }
        return string2;
    }

    public static String getCNameWithoutPkg(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1, string.length());
    }

    public static String getIName(Interface interface_) {
        return interface_.getName();
    }

    public static String getIName(Interface interface_, String string) {
        String string2 = interface_.getName();
        int n = string2.lastIndexOf(".");
        string2 = string2.substring(n + 1, string2.length());
        if (string != null && string.length() != 0) {
            string2 = string + "." + string2;
        }
        return string2;
    }

    public static String getConstructedName(Class clazz) {
        return (String)ConstructedName.get(clazz);
    }

    protected RandomAccessFile openFile(String string) throws IOException {
        String string2 = this.targetDir + string;
        this.checkFile(string2);
        return new RandomAccessFile(string2, "rw");
    }

    protected void writeHeader(String string) throws IOException {
        String string2 = this.rName;
        if (this.pkgName != null) {
            string2 = this.pkgName + "." + this.rName;
        }
        String string3 = new Date().toString();
        this.write("\n//\n// " + MessageHandler.getMessage("gen.comment.header", string2, string3) + "\n//\n\n");
        if (this.pkgName != null && this.pkgName.length() != 0) {
            this.write("package " + this.pkgName + Def.COMMA + "\n\n");
        }
        this.write(this.imports.toString() + "\n\n");
        this.write(string);
        this.write(Def.PUBLIC + this.jConst + this.cName + this.extend + this.interf + "{\n\n");
    }

    private boolean checkFile(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            String string2 = string + "~";
            File file2 = new File(string2);
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                Trace.error(MessageHandler.getMessage("compile.error.noWritePermission", file.getName()));
                throw new IOException("The file " + file.getName() + " belongs to another user");
            }
        }
        return true;
    }

    protected synchronized void write(String string) throws IOException {
        try {
            this.out.writeBytes(string);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
    }

    protected synchronized void closeFile() throws IOException {
        try {
            this.out.getFD().sync();
            this.out.close();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
    }

    protected String getCommentsMO(String string) {
        return "/**\n * " + MessageHandler.getMessage("gen.comment.header.MO", string) + "\n" + " *\n" + " * @see com.sun.jdmk.tools.ProxyGen \n" + " */\n";
    }

    protected String getCommentsMOStub(String string) {
        return "/**\n * " + MessageHandler.getMessage("gen.comment.header.MOStub", string) + "\n" + " *\n" + " * @see com.sun.jdmk.tools.ProxyGen \n" + " */\n";
    }

    protected String getCommentsStub(String string) {
        return "/**\n * " + MessageHandler.getMessage("gen.comment.header.Stub", string) + "\n" + " *\n" + " * @see com.sun.jdmk.tools.ProxyGen \n" + " */\n";
    }

    static {
        ConstructedName.put(Boolean.TYPE, "Boolean");
        ConstructedName.put(Character.TYPE, "Character");
        ConstructedName.put(Byte.TYPE, "Byte");
        ConstructedName.put(Short.TYPE, "Short");
        ConstructedName.put(Integer.TYPE, "Integer");
        ConstructedName.put(Long.TYPE, "Long");
        ConstructedName.put(Float.TYPE, "Float");
        ConstructedName.put(Double.TYPE, "Double");
        ConstructedName.put(Boolean.TYPE, "Boolean");
        ConstructedName.put(Boolean.TYPE, "Boolean");
        ConstructedName.put(Boolean.TYPE, "Boolean");
        ConstructedName.put(Boolean.TYPE, "Boolean");
    }
}

