/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.proxygen;

import com.sun.jdmk.tools.proxygen.Def;
import com.sun.jdmk.tools.proxygen.Generator;
import com.sun.jdmk.tools.proxygen.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;

public abstract class CBeanGenerator
extends Generator {
    protected Class theClass;
    protected boolean notifs;
    protected MBeanAttributeInfo[] props;
    protected Hashtable interfaces;
    protected MBeanOperationInfo[] perf;
    protected String GET_EXCEPTION = new String("InstanceNotFoundException, AttributeNotFoundException,\n" + Def.TAB2 + "ReflectionException, MBeanException");
    protected String PER_EXCEPTION = new String("InstanceNotFoundException, ReflectionException,\n" + Def.TAB2 + "MBeanException");
    protected String SET_EXCEPTION = new String("InstanceNotFoundException, ReflectionException,\n" + Def.TAB2 + "AttributeNotFoundException," + "InvalidAttributeValueException,\n" + Def.TAB2 + "MBeanException");
    protected String LIS_ADD_EXCEPTION = new String("InstanceNotFoundException");
    protected String LIS_REM_EXCEPTION = new String("InstanceNotFoundException, ListenerNotFoundException");
    private static final String sccs_id = "@(#)CBeanGenerator.java 4.13 02/03/00 SMI";

    public CBeanGenerator(Class clazz, MBeanInfo mBeanInfo, Class clazz2, String string, String string2) {
        super(mBeanInfo.getClassName(), string2);
        int n;
        this.theClass = clazz;
        this.pkgName = string;
        if (this.pkgName == null && (n = mBeanInfo.getClassName().lastIndexOf(".")) != -1) {
            this.pkgName = mBeanInfo.getClassName().substring(0, n);
            if (this.pkgName.startsWith("java.") || this.pkgName.startsWith("javax.")) {
                this.pkgName = null;
            }
        }
        this.props = mBeanInfo.getAttributes();
        this.perf = mBeanInfo.getOperations();
        this.notifs = this.hasNotifications(clazz);
        this.interfaces = Parser.getInterfaceHandler(clazz).getInterfaceList();
        this.imports.addImport(Def.IMP_J_J_ATNF);
        this.imports.addImport(Def.IMP_J_J_INNF);
        this.imports.addImport(Def.IMP_J_J_IAV);
        this.imports.addImport(Def.IMP_J_J_MBE);
        this.imports.addImport(Def.IMP_J_J_MBRE);
        this.imports.addImport(Def.IMP_J_J_REFL);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < this.props.length) {
            if (!arrayList.contains(this.props[n2].getType())) {
                arrayList.add(this.props[n2].getType());
            }
            ++n2;
        }
        this.imports.addImport(arrayList.iterator());
    }

    public abstract void generateCode() throws IOException;

    protected boolean hasNotifications(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        boolean bl = false;
        while (clazz != null) {
            classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (this.isBroadcaster(classArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
            if (bl) break;
        }
        return bl;
    }

    private boolean isBroadcaster(Class clazz) {
        if (clazz.getName().compareTo("javax.management.NotificationBroadcaster") == 0) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getName().compareTo("javax.management.NotificationBroadcaster") == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

