/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.SimpleNode;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SymbolHandler {
    protected Hashtable unresolved;
    protected Hashtable resolved;
    protected String mibName;
    private static final String sccs_id = "@(#)SymbolHandler.java 4.4 02/03/00 SMI";

    public SymbolHandler(String string) {
        this.mibName = string;
        this.resolved = new Hashtable();
        this.unresolved = new Hashtable();
    }

    public void addResolution(String string, SimpleNode simpleNode) {
        SimpleNode simpleNode2 = (SimpleNode)this.resolved.get(string);
        if (simpleNode2 != null) {
            Trace.warning(MessageHandler.getMessage("compile.w.resolve", string));
            return;
        }
        this.resolved.put(string, simpleNode);
        Vector vector = (Vector)this.unresolved.get(string);
        if (vector == null) {
            return;
        }
        this.unresolved.remove(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode3 = (SimpleNode)enumeration.nextElement();
            simpleNode3.setResolver(simpleNode);
        }
    }

    public SimpleNode lookupIdentifier(String string) {
        return (SimpleNode)this.resolved.get(string);
    }

    public boolean printUnresolved() {
        if (this.unresolved.isEmpty()) {
            return true;
        }
        Enumeration enumeration = this.unresolved.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Trace.error(MessageHandler.getMessage("compile.error.undef", string, this.mibName));
        }
        return false;
    }

    public void resolve(Hashtable hashtable) {
        if (this.unresolved.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.unresolved.keys();
        block0: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                SymbolHandler symbolHandler = (SymbolHandler)hashtable.get(string2);
                SimpleNode simpleNode = symbolHandler.lookupIdentifier(string);
                if (simpleNode == null) continue;
                Trace.info(MessageHandler.getMessage("compile.resolve.info", string, this.mibName, symbolHandler.getModuleName()));
                this.addResolution(string, simpleNode);
                continue block0;
            }
        }
    }

    public static String getClassVersion() {
        return sccs_id;
    }

    public String getModuleName() {
        return this.mibName;
    }
}

