/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTOidValue;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MibTree {
    private MibNode root;
    private String moduleName;

    public MibTree(String string) {
        this.moduleName = string;
        this.root = new MibNode("");
    }

    public boolean buildTree(Hashtable hashtable, Hashtable hashtable2) {
        return this.handleObjectList(hashtable) && this.handleObjectList(hashtable2);
    }

    public void dump(String string) {
        Trace.info("MIB MODULE= " + this.moduleName);
        this.root.dump(string);
    }

    public MibNode getRoot() {
        return this.root;
    }

    private boolean handleObjectList(Hashtable hashtable) {
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ASTObjectTypeDefinition aSTObjectTypeDefinition;
            String string = (String)enumeration.nextElement();
            if (this.register(string, aSTObjectTypeDefinition = (ASTObjectTypeDefinition)hashtable.get(string))) continue;
            bl = false;
        }
        return bl;
    }

    private boolean register(String string, ASTObjectTypeDefinition aSTObjectTypeDefinition) {
        ObjectTypeDefinition objectTypeDefinition = aSTObjectTypeDefinition.getDefinition();
        ASTOidValue aSTOidValue = objectTypeDefinition.getOidNode();
        StringBuffer stringBuffer = aSTOidValue.getDotNotation();
        return this.addNode(stringBuffer.toString(), string, aSTObjectTypeDefinition);
    }

    private boolean addNode(String string, String string2, ASTObjectTypeDefinition aSTObjectTypeDefinition) {
        Object[] objectArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        MibNode mibNode = this.root;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            mibNode = mibNode.getId((String)objectArray);
        }
        if (mibNode.isAssociated()) {
            objectArray = new Object[]{mibNode.getSymbolName(), string2, string, this.moduleName};
            Trace.error(MessageHandler.getMessage("compile.error.duplicate.oid", objectArray));
            return false;
        }
        mibNode.setAssociation(string, string2, aSTObjectTypeDefinition);
        return true;
    }
}

