/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.RegisteredObject;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MibStoreGenerator
extends Generator
implements Serializable {
    protected String module = "";
    protected String fileName = "";
    protected StringBuffer metadata = new StringBuffer();
    protected boolean entrySet = false;
    private String varName = "varList";

    public MibStoreGenerator(ResourceManager resourceManager, ASTMib aSTMib, Context context) throws IOException {
        super(resourceManager, context);
        this.mib = aSTMib;
        this.context.mib = aSTMib;
        this.module = aSTMib.getModuleName();
        this.fileName = this.prefix + this.translateMibName() + Def.OIDTABLESUFFIX;
        this.out = this.openFile(this.fileName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.writeConstructor();
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.mib = context.mib;
    }

    private void generateSymbolCode(ASTMib aSTMib) throws IOException {
        if (aSTMib.registrationTable == null) {
            return;
        }
        Enumeration enumeration = aSTMib.registrationTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RegisteredObject registeredObject = (RegisteredObject)aSTMib.registrationTable.get(string);
            switch (registeredObject.getNodeType()) {
                case 2: {
                    this.addMibEntry(string, aSTMib.resolveOidSymbol(string), SyntaxMapper.MibStoreIdentitySymbol);
                    break;
                }
                case 3: {
                    this.addMibEntry(string, aSTMib.resolveOidSymbol(string), SyntaxMapper.MibStoreNotificationSymbol);
                    break;
                }
            }
        }
    }

    public void generateCode() throws IOException {
        this.initMeta();
        MibNode mibNode = this.mib.getMibTree().getRoot();
        this.generateCode(mibNode);
        this.generateSymbolCode(this.mib);
        this.endCodeGeneration();
    }

    private void endCodeGeneration() throws IOException {
        if (this.entrySet) {
            this.closeMeta();
        } else {
            this.closeMeta();
        }
        this.write(this.metadata.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    private void generateCode(MibNode mibNode) throws IOException {
        Object object;
        Object object2;
        if (mibNode.isAssociated()) {
            Hashtable hashtable;
            object2 = mibNode.getComputedOid();
            object = SyntaxMapper.getMibStoreSyntax(SyntaxMapper.getTypeName(this.accessNodeSyntax(mibNode)));
            if (((String)object).equals(SyntaxMapper.MibStoreSequenceSymbol) && !(hashtable = mibNode.getChildren()).isEmpty()) {
                Enumeration enumeration = hashtable.elements();
                if (enumeration.hasMoreElements()) {
                    MibNode mibNode2 = (MibNode)enumeration.nextElement();
                    if (mibNode2.getChildren().isEmpty()) {
                        object = SyntaxMapper.MibStoreEntrySymbol;
                    }
                }
            }
            this.addMibEntry(mibNode.getRealSymbolName(), (String)object2, (String)object);
        }
        object2 = mibNode.getChildren();
        object = ((Hashtable)object2).elements();
        while (object.hasMoreElements()) {
            this.generateCode((MibNode)object.nextElement());
        }
    }

    protected void addMibEntry(String string, String string2, String string3) throws IOException {
        if (this.entrySet) {
            this.metadata.append(",\n");
        }
        this.metadata.append(Def.TAB2 + "new SnmpOidRecord(\"" + string + "\", \"" + string2 + "\", \"" + string3 + "\")");
        this.entrySet = true;
    }

    protected void closeMeta() throws IOException {
        this.metadata.append(Def.TAB + "};\n");
    }

    protected void initMeta() throws IOException {
        this.metadata.append(Def.TAB + "static SnmpOidRecord " + this.varName + " [] = {\n");
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.miboidtable.comment.header", this.module) + "\n" + " * " + MessageHandler.getMessage("generate.miboidtable.comment.header2", this.fileName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.fileName + Def.EXTEND + Def.SNMP_OID_TABLE + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeVersion() throws IOException {
        String string = "generate.version";
        this.write("\n//\n// " + MessageHandler.getMessage(string, this.mib.getModuleName()) + "\n//\n\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_OID_RECORD + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_OID_TABLE_SUPPORT + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        this.write("\n");
    }

    protected void writeConstructor() throws IOException {
        this.write(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.const") + "\n" + Def.TAB + " */\n");
        this.write(Def.TAB + Def.PUBLIC + this.fileName + "()" + Def.LBRACE + Def.TAB2 + "super(\"" + this.translateMibName() + "\")" + Def.SEMICOLON + Def.TAB2 + "loadMib(" + this.varName + ")" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    private String translateMibName() throws IOException {
        String string = this.module.trim();
        string = string.replace('-', '_');
        string = string.replace('.', '_');
        string = string.replace(',', '_');
        string = string.replace(',', '_');
        string = string.replace(' ', '_');
        return string;
    }

    private String accessNodeSyntax(MibNode mibNode) {
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        return aSTNamedType.getSnmpSyntax();
    }
}

