/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import java.io.IOException;
import java.io.Serializable;

public class MibGenerator
extends Generator
implements Serializable {
    protected String module = "";
    protected String translatedMibName = "";
    protected String fileName = "";
    protected int gentype = 0;
    protected StringBuffer init_impl = new StringBuffer();
    protected StringBuffer regmeta_impl = new StringBuffer();
    protected StringBuffer getmeta_impl = new StringBuffer();
    protected StringBuffer objsrv_impl = new StringBuffer();
    protected StringBuffer initprereg_impl = new StringBuffer();
    protected StringBuffer populate_impl = new StringBuffer();
    protected StringBuffer factory_impl = new StringBuffer();
    protected StringBuffer var_def = new StringBuffer();
    private String domainSeparator = ".";
    private static final String OBJSRV = "objectserver";
    private static final String ISINIT = "isInitialized";
    private static final String METAS = "metadatas";

    public MibGenerator(ResourceManager resourceManager, ASTMib aSTMib, Context context) throws IOException {
        super(resourceManager, context);
        this.mib = aSTMib;
        this.gentype = context.gentype;
        this.context.mib = aSTMib;
        this.context.mibgen = this;
        this.module = aSTMib.getModuleName();
        this.translatedMibName = this.translateMibName();
        this.fileName = MibGenerator.getMibClassName(this.prefix, aSTMib);
        this.out = this.openFile(this.fileName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.writeConstructor();
        this.buildInitHeader();
        this.buildPopulateHeader();
        this.buildInitPreRegHeader();
        this.buildRegisterTableMeta(this.regmeta_impl);
        this.buildGetRegisteredMeta(this.getmeta_impl);
        if (this.isStandard()) {
            this.buildGetStandardObjectServer(this.objsrv_impl);
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.mib = context.mib;
        this.gentype = context.gentype;
        context.mibgen = this;
    }

    protected String getMetaFactoryName(String string) {
        return "create" + string + "Node";
    }

    protected String getBeanFactoryName(String string) {
        return "create" + string + Def.MBEANSUFFIX;
    }

    protected String getBeanFactoryResult(Context context, String string, String string2) {
        if (MibGenerator.isGeneric(context, string)) {
            return "Object";
        }
        return "Object";
    }

    protected String getBeanInterfaceName(Context context, String string, String string2) {
        return string2 + Def.MBEANSUFFIX;
    }

    public void generateFactoryComments(String string, String string2, String string3, String string4, StringBuffer stringBuffer) {
        stringBuffer.append("\n" + Def.TAB + "/**");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.abstract." + string4, string));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text1." + string4));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text2." + string4));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.name", string));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.oid"));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.objname"));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.server"));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return1." + string4));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return2." + string4, string, string2));
        stringBuffer.append("\n" + Def.TAB + " * ");
        if (string3 != null) {
            if (this.isStandard()) {
                stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
                stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", string3));
                stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            } else {
                stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
                stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", string3));
                stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            }
        }
        stringBuffer.append("\n" + Def.TAB + " **/" + "\n");
    }

    protected void createMeta(String string, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB2 + Def.RETURN + "new " + string + "(this, " + OBJSRV + ")" + Def.SEMICOLON);
    }

    protected void generateMetaFactory(Context context, String string, String string2, String string3, String string4, String string5, StringBuffer stringBuffer) {
        this.generateFactoryComments(string, string3, null, "meta", stringBuffer);
        String string6 = this.getMetaFactoryName(string3);
        stringBuffer.append(Def.TAB + Def.PROTECTED + string3 + " " + string6 + "(String groupName,\n" + Def.TAB4 + "String groupOid," + " ObjectName groupObjname, MBeanServer server) " + Def.LBRACE);
        this.createMeta(string3, stringBuffer);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void generateBeanFactory(Context context, String string, String string2, String string3, String string4, String string5, StringBuffer stringBuffer) {
        String string6 = this.getBeanFactoryName(string4);
        String string7 = this.getBeanInterfaceName(context, string, string4);
        String string8 = this.getBeanFactoryResult(context, string, string4);
        this.generateFactoryComments(string, string4, string7, "bean", stringBuffer);
        stringBuffer.append(Def.TAB + Def.PROTECTED + string8 + " " + string6 + "(String groupName,\n" + Def.TAB4 + "String groupOid, " + " ObjectName groupObjname, MBeanServer server) " + Def.LBRACE);
        if (this.isStandard()) {
            stringBuffer.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
            stringBuffer.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", string7));
            stringBuffer.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            stringBuffer.append("\n" + Def.TAB2 + "//\n");
        } else {
            stringBuffer.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
            stringBuffer.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", string7));
            stringBuffer.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            stringBuffer.append("\n" + Def.TAB2 + "//\n");
        }
        stringBuffer.append(Def.TAB2 + "if (server != null) \n" + Def.TAB3 + Def.RETURN + "new " + string4 + "(this,server)" + Def.SEMICOLON + Def.TAB2 + "else \n" + Def.TAB3 + Def.RETURN + "new " + string4 + "(this)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    public String getInitMethodName(Context context, String string) {
        if (context.gentype == 2) {
            return Def.INIT + context.genericPrefix + string;
        }
        if (context.gentype == 1) {
            return Def.INIT + context.standardPrefix + string;
        }
        return Def.INIT + string;
    }

    public void generateInitNodeMethod(Context context, String string, String string2, String string3, String string4, String string5, StringBuffer stringBuffer) {
        stringBuffer.append("\n" + Def.TAB + "/**");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init.group", string));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init.support1"));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init.support2", this.getMetaFactoryName(string3)));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.param.server"));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " **/\n");
        stringBuffer.append(Def.TAB + Def.PROTECTED + Def.VOID + this.getInitMethodName(context, string) + "(" + Def.MBEANSERVER + " server) " + "\n" + Def.TAB2 + Def.THROWS + "Exception" + Def.LBRACE);
        this.populateMib(context, string, string2, string3, string4, string5, stringBuffer);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    public void populateMib(Context context, String string, String string2, String string3, String string4, String string5, StringBuffer stringBuffer) {
        String string6 = "objname";
        String string7 = "server";
        String string8 = this.getMetaFactoryName(string3);
        String string9 = this.getBeanFactoryName(string4);
        String string10 = this.getBeanInterfaceName(context, string, string4);
        String string11 = this.getBeanFactoryResult(context, string, string4);
        stringBuffer.append(Def.TAB2 + "final String oid = " + Def.METH_T_GETOID + "(\"" + string + "\", \"" + string2 + "\")" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + "ObjectName " + string6 + " = null" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + "if (" + string7 + " != null) " + Def.N_LBRACE);
        stringBuffer.append(Def.TAB3 + string6 + " = " + Def.METH_T_GETOBJNAME + "(\"" + string + "\", oid, " + string5 + ")" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + Def.RBRACE);
        stringBuffer.append(Def.TAB2 + "final " + string3 + " meta = " + string8 + "(\"" + string + "\", oid, " + string6 + ", " + string7 + ")" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + "if (meta != null) " + Def.N_LBRACE);
        stringBuffer.append(Def.TAB3 + "meta." + Def.METH_T_REGTABLES + "( this, server )" + Def.SEMICOLON);
        if (this.isGeneric()) {
            stringBuffer.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.gen"));
            stringBuffer.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.gen", string10));
            stringBuffer.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.gen"));
            stringBuffer.append("\n" + Def.TAB3 + "//\n");
            stringBuffer.append(Def.TAB3 + "final " + string11 + " group = " + string9 + "(\"" + string + "\", oid, " + string6 + ", " + string7 + ")" + Def.SEMICOLON);
        } else {
            stringBuffer.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return3.std"));
            stringBuffer.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return4.std", string10));
            stringBuffer.append("\n" + Def.TAB3 + "// " + MessageHandler.getMessage("generate.mib.comment.factory.note.return5.std"));
            stringBuffer.append("\n" + Def.TAB3 + "//\n");
            stringBuffer.append(Def.TAB3 + "final " + string10 + " group = (" + string10 + ") " + string9 + "(\"" + string + "\", oid, " + string6 + ", " + string7 + ")" + Def.SEMICOLON);
        }
        if (MibGenerator.isStandard(context, string)) {
            stringBuffer.append(Def.TAB3 + "meta." + Def.SET_MOI + "( group )" + Def.SEMICOLON);
        }
        if (MibGenerator.isGeneric(context, string)) {
            stringBuffer.append(Def.TAB3 + "meta." + Def.SET_OBJNAME + "( " + string6 + " )" + Def.SEMICOLON);
        }
        stringBuffer.append(Def.TAB3 + Def.METH_T_REGGROUP + "(\"" + string + "\", oid, " + string6 + ", meta, group, " + string7 + ")" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + Def.RBRACE);
    }

    public void registerNode(MibNode mibNode, Context context, String string) throws IOException {
        String string2 = mibNode.getSymbolName();
        if (string2 == null) {
            string2 = this.getClassName(mibNode.getComputedOid());
        }
        String string3 = mibNode.getComputedOid();
        String string4 = MetaBeanGenerator.buildMetaName(this.context, this.context.prefix, string2);
        String string5 = this.prefix + string2;
        String string6 = this.packageName.length() != 0 ? "." : "";
        string = string == null ? "" : this.domainSeparator + string;
        String string7 = new String("mibName + \"" + string + ":name=" + this.packageName + string6 + string5 + "\"");
        this.populate_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.group", string2) + "\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.support1") + "\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.init.support2", this.getMetaFactoryName(string4)) + "\n" + Def.TAB2 + "//\n");
        this.populate_impl.append(Def.TAB2 + this.getInitMethodName(context, string2) + "(server)" + Def.SEMICOLON);
        this.populate_impl.append("\n");
        this.factory_impl.append("\n" + Def.TAB + Def.LINE);
        this.factory_impl.append("\n" + Def.TAB + "// ");
        this.factory_impl.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.init.group", string2));
        this.factory_impl.append("\n" + Def.TAB + "// ");
        this.factory_impl.append("\n" + Def.TAB + Def.LINE + "\n\n");
        this.generateInitNodeMethod(context, string2, string3, string4, string5, string7, this.factory_impl);
        this.generateMetaFactory(context, string2, string3, string4, string5, string7, this.factory_impl);
        this.generateBeanFactory(context, string2, string3, string4, string5, string7, this.factory_impl);
    }

    public void endMib() throws IOException {
        this.closeInit();
        this.closeInitPreReg();
        this.closePopulate();
        this.write(this.init_impl.toString());
        this.write(this.initprereg_impl.toString());
        this.write(this.populate_impl.toString());
        this.write(this.factory_impl.toString());
        this.write(this.regmeta_impl.toString());
        this.write(this.getmeta_impl.toString());
        if (this.isStandard()) {
            this.write(this.objsrv_impl.toString());
        }
        this.writeVariableDefinition();
        this.write(Def.RBRACE);
        this.closeIO();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mib.comment.header", this.module) + "\n" + " * " + MessageHandler.getMessage("generate.mib.comment.modif") + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.fileName + Def.EXTEND + Def.SNMP_MIB + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        String[] stringArray;
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_HASHTABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_OBJECT_NAME + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_INSTANCE_ALREADY_EXISTS_EXCEPTION + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB_NODE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_TABLE + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        if ((stringArray = this.getInterfacePkgs()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.write(Def.IMPORT + stringArray[n] + Def.SEMICOLON);
                ++n;
            }
        }
        this.write("\n");
    }

    protected void writeConstructor() throws IOException {
        this.write(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.const") + "\n" + Def.TAB + " */\n");
        this.write(Def.TAB + Def.PUBLIC + this.fileName + "()" + Def.LBRACE + Def.TAB2 + "mibName = \"" + this.translatedMibName + "\"" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildInitHeader() throws IOException {
        this.init_impl.append(Def.TAB + "/**\n");
        this.init_impl.append(Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init") + "\n");
        this.init_impl.append(Def.TAB + " */\n");
        this.init_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_INIT + "() " + Def.THROWS + Def.EXCP_ILLEGAL + Def.LBRACE);
        this.init_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n");
        this.init_impl.append(Def.TAB2 + "//\n");
        this.init_impl.append(Def.TAB2 + "if (" + ISINIT + " == true)" + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + Def.RETURN + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.RBRACE + "\n");
        this.init_impl.append(Def.TAB2 + "try " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + Def.METH_T_POPULATE + "(null, null)" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(" + Def.EXCP_ILLEGAL + " x) " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + "throw x" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(RuntimeException x) " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + "throw x" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.N_RBRACE + " catch(Exception x) " + Def.LBRACE);
        this.init_impl.append(Def.TAB3 + Def.THROW_NEW + "Error(x.getMessage())" + Def.SEMICOLON);
        this.init_impl.append(Def.TAB2 + Def.RBRACE + "\n");
    }

    static boolean isStandard(Context context, String string) {
        return (context.gentype & 1) != 0;
    }

    static boolean isGeneric(Context context, String string) {
        return (context.gentype & 2) != 0;
    }

    protected String getObjectServerClass() {
        if (this.isStandard()) {
            return Def.SNMP_STANDARD_OSRV;
        }
        if (this.isGeneric()) {
            return Def.SNMP_GENERIC_OSRV;
        }
        return "Object";
    }

    protected String[] getInterfacePkgs() {
        int n = 0;
        if (this.isStandard()) {
            ++n;
        }
        if (this.isGeneric()) {
            ++n;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        if (this.isGeneric()) {
            stringArray[--n] = Def.PKG_SNMP_GENERIC_OSRV;
        }
        if (this.isStandard()) {
            stringArray[--n] = Def.PKG_SNMP_STANDARD_OSRV;
        }
        return stringArray;
    }

    protected void createObjectServer(StringBuffer stringBuffer) {
        if (this.isStandard()) {
            this.createStandardObjectServer(stringBuffer);
        }
        if (this.isGeneric()) {
            this.createGenericObjectServer(stringBuffer);
        }
    }

    protected void createStandardObjectServer(StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB2 + "if (" + OBJSRV + " == null) \n");
        stringBuffer.append(Def.TAB3 + OBJSRV + " = new " + this.getObjectServerClass() + "()" + Def.SEMICOLON);
    }

    protected void createGenericObjectServer(StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB2 + "if (" + OBJSRV + " == null) \n");
        stringBuffer.append(Def.TAB3 + OBJSRV + " = new " + this.getObjectServerClass() + "(server)" + Def.SEMICOLON);
    }

    protected void buildPopulateHeader() throws IOException {
        this.populate_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.init") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_POPULATE + "(MBeanServer server, ObjectName name) " + "\n" + Def.TAB2 + Def.THROWS + "Exception" + Def.LBRACE + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n" + Def.TAB2 + "//\n" + Def.TAB2 + "if (" + ISINIT + " == true)" + Def.LBRACE + Def.TAB3 + Def.RETURN + Def.SEMICOLON + Def.TAB2 + Def.RBRACE + "\n");
        this.createObjectServer(this.populate_impl);
        this.populate_impl.append("\n");
    }

    protected void buildGetStandardObjectServer(StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB + Def.PUBLIC + this.getObjectServerClass() + " " + Def.METH_T_GETSTDOBJSRV + "()" + Def.LBRACE);
        this.createStandardObjectServer(stringBuffer);
        stringBuffer.append(Def.TAB2 + Def.RETURN + OBJSRV + Def.SEMICOLON);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildRegisterTableMeta(StringBuffer stringBuffer) {
        stringBuffer.append("\n" + Def.TAB + Def.LINE);
        stringBuffer.append("\n" + Def.TAB + "// ");
        stringBuffer.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", Def.METH_T_REGTABLEMETA, Def.SNMP_MIB));
        stringBuffer.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_MIB));
        stringBuffer.append("\n" + Def.TAB + "// ");
        stringBuffer.append("\n" + Def.TAB + Def.LINE + "\n\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REGTABLEMETA + "( String name, " + Def.SNMP_TABLE + " meta)" + Def.LBRACE);
        stringBuffer.append(Def.TAB2 + "if (" + METAS + " == null) return" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + "if (name == null) return" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + METAS + ".put(name,meta)" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildGetRegisteredMeta(StringBuffer stringBuffer) {
        stringBuffer.append("\n" + Def.TAB + Def.LINE);
        stringBuffer.append("\n" + Def.TAB + "// ");
        stringBuffer.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", Def.METH_T_GETTABLEMETA, Def.SNMP_MIB));
        stringBuffer.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", Def.SNMP_MIB));
        stringBuffer.append("\n" + Def.TAB + "// ");
        stringBuffer.append("\n" + Def.TAB + Def.LINE + "\n\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + Def.SNMP_TABLE + " " + Def.METH_T_GETTABLEMETA + "( String name )" + Def.LBRACE);
        stringBuffer.append(Def.TAB2 + "if (" + METAS + " == null) return null" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + "if (name == null) return null" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB2 + Def.RETURN + "(" + Def.SNMP_TABLE + ") " + METAS + ".get(name)" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildInitPreRegHeader() throws IOException {
        this.initprereg_impl.append(Def.TAB + "/**\n");
        this.initprereg_impl.append(Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.preRegister") + "\n");
        this.initprereg_impl.append(Def.TAB + " */\n");
        this.initprereg_impl.append(Def.TAB + Def.PUBLIC + "ObjectName " + "preRegister(MBeanServer server, " + "ObjectName name)\n");
        this.initprereg_impl.append(Def.TAB3 + Def.THROWS + "Exception" + Def.LBRACE);
        this.initprereg_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.oneCall") + "\n");
        this.initprereg_impl.append(Def.TAB2 + "//\n");
        this.initprereg_impl.append(Def.TAB2 + "if (" + ISINIT + " == true)" + Def.LBRACE);
        this.initprereg_impl.append(Def.TAB3 + Def.THROW_NEW + "InstanceAlreadyExistsException()" + Def.SEMICOLON);
        this.initprereg_impl.append(Def.TAB2 + Def.RBRACE + "\n");
        this.initprereg_impl.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.mib.comment.cmf") + "\n");
        this.initprereg_impl.append(Def.TAB2 + "//\n");
        this.initprereg_impl.append(Def.TAB2 + "this.server = server" + Def.SEMICOLON + "\n");
        this.initprereg_impl.append(Def.TAB2 + Def.METH_T_POPULATE + "(server, name)" + Def.SEMICOLON + "\n");
    }

    protected void closeInit() throws IOException {
        this.init_impl.append(Def.TAB2 + ISINIT + " = true" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closePopulate() throws IOException {
        this.populate_impl.append(Def.TAB2 + ISINIT + " = true" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeInitPreReg() throws IOException {
        this.initprereg_impl.append(Def.TAB2 + ISINIT + " = true" + Def.SEMICOLON + Def.TAB2 + Def.RETURN + "name" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void writeVariableDefinition() throws IOException {
        this.write(Def.TAB + Def.PRIVATE + Def.BOOLEAN + ISINIT + " = false" + Def.SEMICOLON + "\n");
        this.write(Def.TAB + Def.PROTECTED + this.getObjectServerClass() + " " + OBJSRV + Def.SEMICOLON + "\n");
        this.write(Def.TAB + Def.PROTECTED + Def.FINAL + "Hashtable " + METAS + " = new Hashtable()" + Def.SEMICOLON);
    }

    private String translateMibName() throws IOException {
        return MibGenerator.translateMibName(this.module);
    }

    public static String translateMibName(String string) throws IOException {
        String string2 = string.trim();
        string2 = string2.replace('-', '_');
        string2 = string2.replace('.', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace(' ', '_');
        return string2;
    }

    public static String getMibClassName(String string, ASTMib aSTMib) throws IOException {
        return string + MibGenerator.translateMibName(aSTMib.getModuleName());
    }

    public String setDomainSeparator(String string) {
        if (string != null) {
            this.domainSeparator = string;
        }
        return this.domainSeparator;
    }
}

