/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTIdentifier;
import com.sun.jdmk.tools.mibgen.ASTIndexParts;
import com.sun.jdmk.tools.mibgen.ASTIndexTypesV2;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinitionV1;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinitionV2;
import com.sun.jdmk.tools.mibgen.BeanGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MbeanGenerator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MetaEntryGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.Node;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.TableBeanGenerator;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MetaTableGenerator
extends BeanGenerator
implements Serializable {
    protected int gentype = 0;
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer table_impl = new StringBuffer();
    protected StringBuffer getReq_impl = new StringBuffer();
    protected StringBuffer validateVar_impl = new StringBuffer();
    protected StringBuffer readableVar_impl = new StringBuffer();
    protected StringBuffer getNextVarId_impl = new StringBuffer();
    protected StringBuffer setReq_impl = new StringBuffer();
    protected StringBuffer checkReq_impl = new StringBuffer();
    protected StringBuffer constructor = new StringBuffer();
    protected StringBuffer create_req_impl = new StringBuffer();
    protected StringBuffer factory_impl = new StringBuffer();
    private String entryName = "";
    private String realName = "";
    private MibNode entryNode;
    private MetaEntryGenerator entryGen = null;
    public static final String OBJSRV = "objectserver";
    public static final String NODE = "node";

    public static String buildMetaName(Context context, String string, String string2) {
        if (context.gentype == 2) {
            return string + string2 + context.genericPrefix + Def.TABLEMETA;
        }
        if (context.gentype == 1) {
            return string + string2 + context.standardPrefix + Def.TABLEMETA;
        }
        return string + string2 + Def.METAPREFIX;
    }

    public MetaTableGenerator(ResourceManager resourceManager, MibNode mibNode, Context context) throws IOException {
        super(resourceManager, mibNode, context);
        this.gentype = context.gentype;
        this.varName = this.node.getSymbolName();
        this.realName = this.node.getRealSymbolName();
        this.oid = this.node.getOid();
        this.symboleName = MetaTableGenerator.buildMetaName(context, context.prefix, this.varName);
    }

    public void generateCode() throws IOException {
        this.processEntry();
        this.processTable();
    }

    protected void processEntry() throws IOException {
        Hashtable hashtable = this.node.getChildren();
        if (hashtable.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", this.realName));
            throw new IOException();
        }
        Enumeration enumeration = hashtable.elements();
        this.entryNode = (MibNode)enumeration.nextElement();
        this.entryName = MbeanGenerator.getNodeSymbolName(this.context, this.entryNode);
        this.entryGen = new MetaEntryGenerator(this.manager, this.entryNode, this.context);
        Enumeration enumeration2 = this.entryNode.getChildren().elements();
        while (enumeration2.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration2.nextElement();
            this.entryGen.handleNode(mibNode);
        }
        this.entryGen.endOfGroup();
    }

    protected void processTable() throws IOException {
        this.out = this.openFile(this.symboleName + Def.JAVA);
        try {
            try {
                this.writeHeader();
                this.writeClassDeclaration();
                this.buildMethods();
                this.writeBuffers();
            }
            catch (RuntimeException runtimeException) {
                this.closeIO();
                throw runtimeException;
            }
            catch (IOException iOException) {
                this.closeIO();
                throw iOException;
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.closeIO();
            throw throwable;
        }
        this.closeIO();
    }

    protected void buildRowStatus() throws IOException {
        if (this.entryGen == null) {
            throw new NullPointerException("Can't find entry generator");
        }
        if (this.entryGen.implementsRowStatus()) {
            String string = this.entryGen.getRowStatusId();
            String string2 = this.entryGen.getRowStatusName();
            this.generateRowStatus(string, string2, this.table_impl);
        } else {
            this.generateRowStatus();
        }
    }

    protected void genMethodCall(String string, String string2, String string3, StringBuffer stringBuffer) throws IOException {
        String string4 = null;
        if (this.isStandard()) {
            stringBuffer.append(string + this.entryName + Def.MBEANSUFFIX + " entry = (" + this.entryName + Def.MBEANSUFFIX + ") " + Def.GET_ENTRY + "(rowOid)" + Def.SEMICOLON);
            string4 = Def.SET_MOI;
        }
        if (this.isGeneric()) {
            stringBuffer.append(string + "ObjectName entry = " + Def.GET_ENTRYNAME + "(rowOid)" + Def.SEMICOLON);
            string4 = Def.SET_OBJNAME;
        }
        stringBuffer.append(string + Def.SYNCHRONIZE + "(this)" + Def.LBRACE);
        if (string4 != null) {
            stringBuffer.append(string + Def.TAB + NODE + "." + string4 + "(entry)" + Def.SEMICOLON);
        }
        stringBuffer.append(string + Def.TAB + string3 + NODE + "." + string2 + Def.SEMICOLON + string + Def.RBRACE);
    }

    protected void genCatchedMethodCall(String string, String string2, String string3, StringBuffer stringBuffer) throws IOException {
        String string4 = null;
        if (this.isStandard()) {
            stringBuffer.append(string + this.entryName + Def.MBEANSUFFIX + " entry = null" + Def.SEMICOLON);
            stringBuffer.append(string + "try " + Def.LBRACE);
            stringBuffer.append(string + Def.TAB + "entry = (" + this.entryName + Def.MBEANSUFFIX + ") " + Def.GET_ENTRY + "(rowOid)" + Def.SEMICOLON);
            stringBuffer.append(string + Def.N_RBRACE + " catch (" + Def.EXCP_SNMP + " x) " + Def.LBRACE);
            stringBuffer.append(string + Def.TAB + "entry = null" + Def.SEMICOLON);
            stringBuffer.append(string + Def.RBRACE);
            string4 = Def.SET_MOI;
        }
        if (this.isGeneric()) {
            stringBuffer.append(string + "ObjectName entry = null" + Def.SEMICOLON);
            stringBuffer.append(string + "try " + Def.LBRACE);
            stringBuffer.append(string + Def.TAB + "entry = " + Def.GET_ENTRYNAME + "(rowOid)" + Def.SEMICOLON);
            stringBuffer.append(string + Def.N_RBRACE + " catch (" + Def.EXCP_SNMP + " x) " + Def.LBRACE);
            stringBuffer.append(string + Def.TAB + "entry = null" + Def.SEMICOLON);
            stringBuffer.append(string + Def.RBRACE);
            string4 = Def.SET_OBJNAME;
        }
        stringBuffer.append(string + Def.SYNCHRONIZE + "(this)" + Def.LBRACE);
        if (string4 != null) {
            stringBuffer.append(string + Def.TAB + NODE + "." + string4 + "(entry)" + Def.SEMICOLON);
        }
        stringBuffer.append(string + Def.TAB + string3 + NODE + "." + string2 + Def.SEMICOLON + string + Def.RBRACE);
    }

    protected void generateRowStatus() throws IOException {
    }

    protected void generateRowStatus(String string, String string2, StringBuffer stringBuffer) throws IOException {
        this.genAbstractMethodComment(Def.METH_T_ISRS, Def.SNMP_TABLE, stringBuffer);
        stringBuffer.append("\n" + Def.TAB + Def.PUBLIC + " boolean " + Def.METH_T_ISRS + "(" + Def.SNMP_OID + " rowOid, " + "long var, " + Def.SNMP_USERDATA + " userData) " + Def.LBRACE);
        stringBuffer.append(Def.TAB2 + Def.RETURN + "(var == " + string + ")" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_HASRS, Def.SNMP_TABLE, stringBuffer);
        stringBuffer.append("\n" + Def.TAB + Def.PUBLIC + " boolean " + Def.METH_T_HASRS + "() " + Def.LBRACE);
        stringBuffer.append(Def.TAB2 + Def.RETURN + "true" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_SETRS, Def.SNMP_TABLE, stringBuffer);
        stringBuffer.append("\n" + Def.TAB + Def.PUBLIC + " SnmpValue " + Def.METH_T_SETRS + "(" + Def.SNMP_OID + " rowOid, " + "int status, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, Def.METH_T_SETRS + "(status, userData)", "return ", stringBuffer);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_ISROWREADY, Def.SNMP_TABLE, stringBuffer);
        stringBuffer.append("\n" + Def.TAB + Def.PUBLIC + " boolean " + Def.METH_T_ISROWREADY + "(" + Def.SNMP_OID + " rowOid, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, Def.METH_T_ISROWREADY + "(userData)", "return ", stringBuffer);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_MAPRSVALUE, Def.SNMP_TABLE, stringBuffer);
        stringBuffer.append("\n" + Def.TAB + Def.PUBLIC + " int " + Def.METH_T_MAPRSVALUE + "(" + Def.SNMP_OID + " rowOid, " + Def.SNMP_VARBIND + " vbstatus, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genCatchedMethodCall(Def.TAB2, Def.METH_T_MAPRSVALUE + "(vbstatus, userData)", "return ", stringBuffer);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
        stringBuffer.append("\n" + Def.TAB + Def.PUBLIC + " int " + Def.METH_T_GETRS + "(" + Def.SNMP_OID + " rowOid, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, Def.METH_T_GETRS + "(userData)", "return ", stringBuffer);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildMethods() throws IOException {
        this.buildCreateReqHeader();
        this.processIndex();
        this.buildTable();
        this.buildRowStatus();
        this.buildConstructorHeader();
        this.buildGetReqHeader();
        this.buildSetReqHeader();
        this.buildCheckReqHeader();
        this.buildValidateVarHeader();
        this.buildIsReadableVarHeader();
        this.buildGetNextVarIdHeader();
        this.generateMetaFactory(this.factory_impl);
    }

    protected void writeBuffers() throws IOException {
        this.write(this.constructor.toString());
        this.write(this.factory_impl.toString());
        this.write(this.create_req_impl.toString());
        this.write(this.table_impl.toString());
        this.write(this.getReq_impl.toString());
        this.write(this.setReq_impl.toString());
        this.write(this.checkReq_impl.toString());
        this.write(this.validateVar_impl.toString());
        this.write(this.readableVar_impl.toString());
        this.write(this.getNextVarId_impl.toString());
        this.write(this.var_list.toString());
        this.write("\n" + Def.RBRACE);
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.gentype = context.gentype;
    }

    boolean isStandard() {
        return (this.gentype & 1) != 0;
    }

    boolean isGeneric() {
        return (this.gentype & 2) != 0;
    }

    public String getTableClassName() {
        return this.symboleName + " ";
    }

    public String getSymbolName() {
        return this.varName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbean.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.symboleName + Def.EXTEND + Def.SNMP_TABLE + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        String[] stringArray;
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_VECTOR + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_OBJECT_NAME + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER64 + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_GAUGE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_INT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_UINT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_IP_ADDR + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_TIME_TICKS + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OPAQUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING_FIXED + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OID + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_NULL + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VALUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VARBIND + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_INDEX + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB_TABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_SUBREQ + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        if ((stringArray = this.getInterfacePkgs()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.write(Def.IMPORT + stringArray[n] + Def.SEMICOLON);
                ++n;
            }
        }
        this.write("\n");
    }

    protected String getObjectServerClass() {
        if (this.isStandard()) {
            return Def.SNMP_STANDARD_OSRV;
        }
        if (this.isGeneric()) {
            return Def.SNMP_GENERIC_OSRV;
        }
        return "Object";
    }

    protected String[] getInterfacePkgs() {
        int n = 0;
        if (this.isStandard()) {
            ++n;
        }
        if (this.isGeneric()) {
            ++n;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        if (this.isGeneric()) {
            stringArray[--n] = Def.PKG_SNMP_GENERIC_OSRV;
        }
        if (this.isStandard()) {
            stringArray[--n] = Def.PKG_SNMP_STANDARD_OSRV;
        }
        return stringArray;
    }

    private void buildTable() throws IOException {
        this.table_impl.append("\n");
        this.genAbstractMethodComment(Def.METH_T_ISNAMEREQ, Def.SNMP_TABLE, this.table_impl);
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.BOOLEAN + Def.METH_T_ISNAMEREQ + "() " + Def.LBRACE);
        if (this.isGeneric()) {
            this.table_impl.append(Def.TAB2 + Def.RETURN + "true" + Def.SEMICOLON);
        } else {
            this.table_impl.append(Def.TAB2 + Def.RETURN + "false" + Def.SEMICOLON);
        }
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n\n");
        String string = MetaBeanGenerator.buildMetaName(this.context, "", this.entryName);
        this.table_impl.append("\n");
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_REGENTRY + "(" + Def.SNMP_MIB + " mib, " + Def.MBEANSERVER + " server) " + Def.LBRACE);
        this.table_impl.append(Def.TAB2 + NODE + " = " + this.getMetaFactoryName(string) + "(" + "\"" + this.entryName + "\", \"" + this.varName + "\", mib, server)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.genAbstractMethodComment(Def.METH_T_ADD, Def.SNMP_TABLE, this.table_impl);
        this.table_impl.append(Def.TAB + Def.PUBLIC + Def.SYNCHRONIZE + Def.VOID + Def.METH_T_ADD + "(" + Def.SNMP_OID + " rowOid, " + Def.OBJECT_NAME + " objname,\n" + Def.TAB4 + " Object entry)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        if (this.isGeneric()) {
            this.table_impl.append(Def.TAB2 + Def.METH_T_ADD + "(rowOid, objname, entry, true)" + Def.SEMICOLON);
        } else {
            String string2 = TableBeanGenerator.getEntryInterfaceName(this.context, this.entryName);
            this.table_impl.append(Def.TAB2 + "if (! (entry instanceof " + string2 + ") )\n");
            this.table_impl.append(Def.TAB3 + "throw new ClassCastException(" + "\"Entries for Table \\\"\" + \n");
            this.table_impl.append(Def.TAB3 + "               " + "\"" + this.varName + "\" + \"\\\" must implement the \\\"\" + \n");
            this.table_impl.append(Def.TAB3 + "               " + "\"" + string2 + "\" + \"\\\" interface.\")" + Def.SEMICOLON);
            this.table_impl.append(Def.TAB2 + "super." + Def.METH_T_ADD + "(rowOid, objname, entry)" + Def.SEMICOLON);
        }
        this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        if (this.isGeneric()) {
            this.table_impl.append(Def.TAB + Def.PUBLIC + Def.SYNCHRONIZE + Def.VOID + Def.METH_T_ADD + "(" + Def.SNMP_OID + " rowOid," + Def.OBJECT_NAME + " objname," + " Object entry," + " boolean registerFlag)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
            this.table_impl.append(Def.TAB2 + "if (" + "objname == null" + ")\n");
            this.table_impl.append(Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_INCONSISTENTNAME + ")" + Def.SEMICOLON);
            this.table_impl.append(Def.TAB2 + "if (" + "entry != null" + " && " + "registerFlag" + ")" + Def.LBRACE);
            this.table_impl.append(Def.TAB3 + OBJSRV + ".registerTableEntry" + "(this, rowOid, objname, entry)" + Def.SEMICOLON + Def.TAB3 + Def.RBRACE);
            this.table_impl.append(Def.TAB2 + "super." + Def.METH_T_ADD + "(rowOid, objname, entry)" + Def.SEMICOLON);
            this.table_impl.append(Def.TAB + Def.RBRACE + "\n");
        }
    }

    private void processIndex() throws IOException {
        this.getIndexFromEntry(null);
    }

    private void getIndexFromEntry(MibNode mibNode) throws IOException {
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode != null ? mibNode.getObjectType() : this.entryNode.getObjectType();
        if (!(aSTObjectTypeDefinition.getDefinition() instanceof ASTObjectTypeDefinitionV1)) {
            this.getV2IndexFromEntry((ASTObjectTypeDefinitionV2)aSTObjectTypeDefinition.getDefinition(), mibNode);
            return;
        }
        this.getV1IndexFromEntry((ASTObjectTypeDefinitionV1)aSTObjectTypeDefinition.getDefinition(), mibNode);
    }

    private void getV1IndexFromEntry(ASTObjectTypeDefinitionV1 aSTObjectTypeDefinitionV1, MibNode mibNode) throws IOException {
        this.processIndexes(aSTObjectTypeDefinitionV1.getIndex(), mibNode);
    }

    private void processIndexes(Node node, MibNode mibNode) throws IOException {
        Object object;
        String string;
        Object object2;
        if (node == null) {
            Trace.error(MessageHandler.getMessage("generate.error.table.noIndex", this.realName));
            throw new IOException();
        }
        int n = node.jjtGetNumChildren();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            object2 = (ASTIdentifier)node.jjtGetChild(n2);
            string = ((ASTIdentifier)object2).getName();
            object = mibNode == null ? this.entryNode.getChildWithName(string) : mibNode.getChildWithName(string);
            if (object == null) {
                object = this.mib.getModuleHandler().findNodeWithName(string);
                if (object == null) {
                    Trace.error(MessageHandler.getMessage("generate.error.table.index", string, this.realName));
                    throw new IOException();
                }
                this.node.addExternalIndex((MibNode)object);
            }
            if (mibNode != null) {
                this.node.addExternalIndex((MibNode)object);
            }
            ASTObjectTypeDefinition aSTObjectTypeDefinition = ((MibNode)object).getObjectType();
            String string2 = ((MibNode)object).getSymbolName();
            ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
            String string3 = aSTNamedType.getSnmpSyntax();
            String string4 = SyntaxMapper.getTypeName(string3);
            stringArray[n2] = string2;
            ++n2;
        }
        object2 = this.packageName.length() != 0 ? "." : "";
        string = "\"" + this.symboleName + ":name=" + this.packageName + (String)object2 + this.entryName + "\"";
        object = "\"" + this.symboleName + ":name=" + this.packageName + (String)object2 + this.entryName + "\"";
        int n3 = 0;
        while (n3 < n) {
            string = string + " + \"," + stringArray[n3] + "=\" + " + "entry." + stringArray[n3];
            object = (String)object + " + \"," + stringArray[n3] + "=\" + " + "_key" + stringArray[n3];
            ++n3;
        }
    }

    private void getV2IndexFromEntry(ASTObjectTypeDefinitionV2 aSTObjectTypeDefinitionV2, MibNode mibNode) throws IOException {
        ASTIndexParts aSTIndexParts = (ASTIndexParts)aSTObjectTypeDefinitionV2.getIndex();
        if (aSTIndexParts.type == 11) {
            String string = aSTIndexParts.getAugmentIdentifier();
            MibNode mibNode2 = this.mib.getModuleHandler().findNodeWithName(string);
            if (mibNode2 == null) {
                Trace.error(MessageHandler.getMessage("generate.error.table.index", string, this.realName));
                throw new IOException();
            }
            this.getIndexFromEntry(mibNode2);
            return;
        }
        ASTIndexTypesV2 aSTIndexTypesV2 = (ASTIndexTypesV2)aSTIndexParts.jjtGetChild(0);
        this.processIndexes(aSTIndexTypesV2, mibNode);
    }

    public void generateFactoryComments(String string, String string2, String string3, String string4, StringBuffer stringBuffer) {
        stringBuffer.append("\n" + Def.TAB + "/**");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.abstract." + string4, string));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text1." + string4));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.text2." + string4));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.name", string));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.tablename", string3));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.mib"));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.param.server"));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.return1." + string4));
        stringBuffer.append("\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.factory.entry.return2." + string4, string, string2));
        stringBuffer.append("\n" + Def.TAB + " * ");
        stringBuffer.append("\n" + Def.TAB + " **/" + "\n");
    }

    protected String getMetaFactoryName(String string) {
        return new String("create" + string + "Node");
    }

    protected void createMeta(String string, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB2 + Def.RETURN + "new " + string + "(mib, " + OBJSRV + ")" + Def.SEMICOLON);
    }

    protected void generateMetaFactory(StringBuffer stringBuffer) {
        String string = MetaBeanGenerator.buildMetaName(this.context, "", this.entryName);
        this.generateFactoryComments(this.entryName, string, this.varName, "meta", stringBuffer);
        String string2 = this.getMetaFactoryName(string);
        stringBuffer.append(Def.TAB + Def.PROTECTED + string + " " + string2 + "(String snmpEntryName, " + "String tableName, " + Def.SNMP_MIB + " mib, MBeanServer server) " + Def.LBRACE);
        this.createMeta(string, stringBuffer);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.registration") + "\n" + Def.TAB + " */\n");
        this.constructor.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib, " + this.getObjectServerClass() + " objserv)" + Def.LBRACE);
        String string = MetaBeanGenerator.buildMetaName(this.context, "", this.entryName);
        this.constructor.append(Def.TAB2 + "super(myMib)" + Def.SEMICOLON + Def.TAB2 + OBJSRV + " = objserv" + Def.SEMICOLON);
        this.constructor.append(Def.TAB + Def.RBRACE + "\n");
        this.var_list.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.var") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PRIVATE + string + " " + NODE + Def.SEMICOLON + "\n");
        this.var_list.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.objserver") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PROTECTED + this.getObjectServerClass() + " " + OBJSRV + Def.SEMICOLON);
    }

    protected void buildValidateVarHeader() throws IOException {
        this.validateVar_impl.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.validatevarid", "var") + "\n" + Def.TAB + " */\n");
        this.validateVar_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_VALIDATE + "( " + Def.SNMP_OID + " rowOid, long var, " + Def.SNMP_USERDATA + " data )\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.validateVar_impl.append(Def.TAB2 + NODE + ".validateVarId(var, data)" + Def.SEMICOLON + Def.TAB + Def.RBRACE);
    }

    protected void buildIsReadableVarHeader() throws IOException {
        this.readableVar_impl.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.isreadable", "var") + "\n" + Def.TAB + " */\n");
        this.readableVar_impl.append(Def.TAB + Def.PUBLIC + Def.BOOLEAN + Def.METH_T_READABLE + "( " + Def.SNMP_OID + " rowOid, long var, " + Def.SNMP_USERDATA + " data )\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.readableVar_impl.append(Def.TAB2 + Def.RETURN + NODE + "." + Def.METH_IS_READABLE + "(var)" + Def.SEMICOLON + Def.TAB + Def.RBRACE);
    }

    protected void buildGetNextVarIdHeader() throws IOException {
        this.getNextVarId_impl.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.getnextvarid", "var") + "\n" + Def.TAB + " */\n");
        this.getNextVarId_impl.append(Def.TAB + Def.PUBLIC + "long " + Def.METH_T_GETNEXTVARID + "( " + Def.SNMP_OID + " rowOid, long var, " + Def.SNMP_USERDATA + " data )\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.getNextVarId_impl.append(Def.TAB2 + "long nextvar = " + NODE + ".getNextVarId(var, data)" + Def.SEMICOLON);
        this.getNextVarId_impl.append(Def.TAB2 + "while (!" + Def.METH_T_READABLE + "(rowOid, nextvar, data))\n");
        this.getNextVarId_impl.append(Def.TAB3 + "nextvar = " + NODE + ".getNextVarId(nextvar, data)" + Def.SEMICOLON);
        this.getNextVarId_impl.append(Def.TAB2 + Def.RETURN + "nextvar" + Def.SEMICOLON + Def.TAB + Def.RBRACE);
    }

    protected void genAbstractMethodComment(String string, String string2, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("\n" + Def.TAB + Def.LINE);
        stringBuffer.append("\n" + Def.TAB + "// ");
        stringBuffer.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", string, string2));
        stringBuffer.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", string2));
        stringBuffer.append("\n" + Def.TAB + "// ");
        stringBuffer.append("\n" + Def.TAB + Def.LINE + "\n\n");
    }

    protected void buildSetReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_SETREQ, Def.SNMP_TABLE, this.getReq_impl);
        this.setReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_SETREQ + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid," + " int depth" + ")\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.setReq_impl.append(Def.TAB2 + "if (req.getSize() == 0) return;\n\n");
        this.genMethodCall(Def.TAB2, "set(req,depth)", "", this.setReq_impl);
        this.setReq_impl.append(Def.TAB + Def.RBRACE);
    }

    protected void buildGetReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_GETREQ, Def.SNMP_TABLE, this.getReq_impl);
        this.getReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_GETREQ + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid," + " int depth" + ")\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.genMethodCall(Def.TAB2, "get(req,depth)", "", this.getReq_impl);
        this.getReq_impl.append(Def.TAB + Def.RBRACE);
    }

    protected void buildCheckReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_CHECKREQ, Def.SNMP_TABLE, this.checkReq_impl);
        this.checkReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_CHECKREQ + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid," + " int depth" + ")\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.checkReq_impl.append(Def.TAB2 + "if (req.getSize() == 0) return;\n\n");
        this.genMethodCall(Def.TAB2, "check(req,depth)", "", this.checkReq_impl);
        this.checkReq_impl.append(Def.TAB + Def.RBRACE);
    }

    protected void buildCreateReqHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_T_CREATE, Def.SNMP_TABLE, this.create_req_impl);
        this.create_req_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_T_CREATE + "(" + Def.SNMP_SUBREQ + " req, " + Def.SNMP_OID + " rowOid, int depth)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.create_req_impl.append(Def.TAB2 + "if (factory != null)\n");
        this.create_req_impl.append(Def.TAB3 + "factory." + Def.METH_T_CREATE + "(req, rowOid, depth, this)" + Def.SEMICOLON);
        this.create_req_impl.append(Def.TAB2 + "else\n");
        this.create_req_impl.append(Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(\n");
        this.create_req_impl.append(Def.TAB4 + Def.EXCP_SNMP + "." + Def.V_NOACCESS + ")" + Def.SEMICOLON);
        this.create_req_impl.append(Def.TAB + Def.RBRACE + "\n");
    }
}

