/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.BeanIfGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MbeanIfGenerator
extends BeanIfGenerator
implements Serializable {
    protected StringBuffer accessors = new StringBuffer();

    public static String buildMBeanIfName(String string, String string2) {
        return string + string2 + Def.MBEANSUFFIX;
    }

    public MbeanIfGenerator(ResourceManager resourceManager, MibNode mibNode, Context context) throws IOException {
        super(resourceManager, mibNode, context);
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = MbeanIfGenerator.buildMBeanIfName(this.prefix, this.varName);
        Trace.info(MessageHandler.getMessage("generate.info.if", this.varName));
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbeanif.comment.desc", this.varName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.INTERFACE + this.symboleName + Def.LBRACE + "\n");
    }

    public void endOfGroup() throws IOException {
        this.write(this.accessors.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    public void handleNode(MibNode mibNode) throws IOException {
        if (mibNode.isGroup() || mibNode.hasNestedGroups()) {
            this.handleNestedGroups(mibNode);
            return;
        }
        if (mibNode.isTable()) {
            this.handleTable(mibNode);
            return;
        }
        String string = mibNode.getSymbolName();
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        if (aSTObjectTypeDefinition == null) {
            return;
        }
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        String string2 = "";
        if (aSTNamedType.isEnumeratedType()) {
            String string3 = aSTNamedType.getEnumeratedDef().getSymbol();
            if (string3.length() == 0) {
                string3 = string;
            }
            string2 = this.prefix + Def.ENUMPREFIX + string3 + " ";
            mibNode.setEnumerated(true);
            mibNode.setEnumeratedType(string2);
        } else {
            string2 = aSTNamedType.getMbeanSyntax();
        }
        this.addAccessors(mibNode, string2, string);
    }

    protected void handleNestedGroups(MibNode mibNode) throws IOException {
    }

    protected void handleTable(MibNode mibNode) throws IOException {
        String string = mibNode.getSymbolName();
        String string2 = this.prefix + Def.TABLEPREFIX + string;
        String string3 = this.getTableEntryName(mibNode);
        this.accessors.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.access", string) + "\n" + Def.TAB + " */\n");
        this.accessors.append(Def.TAB + Def.PUBLIC + string2 + " " + Def.ACCESS + string + "() " + BeanIfGenerator.accessThrows + "\n");
    }

    private String getTableEntryName(MibNode mibNode) throws IOException {
        Hashtable hashtable = mibNode.getChildren();
        if (hashtable.size() != 1) {
            Trace.error(MessageHandler.getMessage("generate.error.table.entry", mibNode.getRealSymbolName()));
            throw new IOException();
        }
        Enumeration enumeration = hashtable.elements();
        MibNode mibNode2 = (MibNode)enumeration.nextElement();
        String string = mibNode2.getSymbolName();
        if (string == null) {
            string = this.getClassName(mibNode2.getComputedOid());
        }
        String string2 = this.prefix + string;
        return string2;
    }

    protected void addGetter(Context context, MibNode mibNode, String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.getter", string3) + "\n" + Def.TAB + " */\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + string2 + Def.GET + string3 + "() " + BeanIfGenerator.accessThrows + "\n");
    }

    protected void addChecker(Context context, MibNode mibNode, String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.checker", string3) + "\n" + Def.TAB + " */\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.CHECK + string3 + "(" + string2 + "x) " + BeanIfGenerator.accessThrows + "\n");
    }

    protected void addSetter(Context context, MibNode mibNode, String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.setter", string3) + "\n" + Def.TAB + " */\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.SET + string3 + "(" + string2 + "x) " + BeanIfGenerator.accessThrows + "\n");
    }

    protected void addAccessors(MibNode mibNode, String string, String string2) throws IOException {
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        String string3 = aSTObjectTypeDefinition.getDefinition().getDescription();
        this.addGetter(this.context, mibNode, string3, string, string2, this.accessors);
        int n = aSTObjectTypeDefinition.getDefinition().getAccess();
        if (n == 68 || n == 85 || n == 66) {
            this.addSetter(this.context, mibNode, string3, string, string2, this.accessors);
            this.addChecker(this.context, mibNode, string3, string, string2, this.accessors);
        }
    }
}

