/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTValue;
import com.sun.jdmk.tools.mibgen.BeanGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.EnumGenerator;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.TableBeanGenerator;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;

public class MbeanGenerator
extends BeanGenerator
implements Serializable {
    protected int gentype = 0;
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer accessors = new StringBuffer();
    protected StringBuffer constructor1 = new StringBuffer();
    protected StringBuffer constructor2 = new StringBuffer();

    public static String getNodeSymbolName(Context context, MibNode mibNode) {
        String string = mibNode.getSymbolName();
        if (string == null) {
            string = Generator.getClassName(context, mibNode.getComputedOid());
        }
        String string2 = context.prefix + string;
        return string2;
    }

    String getNodeSymbolName(MibNode mibNode) {
        return MbeanGenerator.getNodeSymbolName(this.context, mibNode);
    }

    public MbeanGenerator(ResourceManager resourceManager, MibNode mibNode, Context context) throws IOException {
        super(resourceManager, mibNode, context);
        this.gentype = context.gentype;
        this.oid = this.node.getComputedOid();
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = this.getNodeSymbolName(this.node);
        Trace.info(MessageHandler.getMessage("generate.info.var", this.varName));
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.buildConstructorHeader();
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.gentype = context.gentype;
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.mbean.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.symboleName + Def.IMPLEMENT + this.symboleName + Def.MBEANSUFFIX + ", " + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeVersion() throws IOException {
        String string = "generate.version";
        this.write("\n//\n// " + MessageHandler.getMessage(string, this.mib.getModuleName()) + "\n//\n\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        this.write("\n");
    }

    public String getSnmpClassName() {
        return this.symboleName;
    }

    public void endOfGroup() throws IOException {
        this.closeConstructor();
        this.write(this.var_list.toString());
        this.write(this.constructor1.toString());
        this.write(this.constructor2.toString());
        this.write(this.accessors.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    public void handleNode(MibNode mibNode) throws IOException {
        if (mibNode.isGroup() || mibNode.hasNestedGroups()) {
            this.handleNestedGroups(mibNode);
            return;
        }
        if (mibNode.isTable()) {
            this.handleTable(mibNode);
            return;
        }
        String string = mibNode.getSymbolName();
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        if (aSTObjectTypeDefinition == null) {
            return;
        }
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        String string2 = "";
        ASTValue aSTValue = aSTObjectTypeDefinition.getDefValue();
        String string3 = "";
        if (aSTNamedType.isEnumeratedType()) {
            EnumGenerator enumGenerator = new EnumGenerator(this.manager, string, aSTNamedType.getEnumeratedDef(), this.context);
            string2 = enumGenerator.getTypeName();
            if (aSTValue != null) {
                string3 = aSTValue.getDefValInitializer(string2, aSTNamedType, string);
            }
            if (aSTValue == null || string3.equals("")) {
                string3 = " = new " + string2.trim() + "()";
            }
            mibNode.setEnumerated(true);
            mibNode.setEnumeratedType(string2);
        } else {
            string2 = aSTNamedType.getMbeanSyntax();
            if (aSTValue != null) {
                string3 = aSTValue.getDefValInitializer(string2, aSTNamedType, string);
            }
            if (aSTValue == null || string3.equals("")) {
                string3 = SyntaxMapper.getInitializer(aSTNamedType.getSnmpSyntax());
            }
        }
        long l = aSTNamedType.getFixedLength();
        mibNode.setFixedLength(l);
        this.addCacheVar(mibNode, string2, l, string3, string);
        this.addAccessors(mibNode, string2, string);
    }

    protected void handleNestedGroups(MibNode mibNode) throws IOException {
    }

    protected void handleTable(MibNode mibNode) throws IOException {
        TableBeanGenerator tableBeanGenerator = new TableBeanGenerator(this.manager, mibNode, this.context);
        String string = tableBeanGenerator.getEntryName();
        String string2 = tableBeanGenerator.getTableClassName();
        String string3 = tableBeanGenerator.getSymbolName();
        this.addCacheVar(mibNode, string2, -1L, null, string3);
        this.constructor1.append(Def.TAB2 + string3 + " = " + Def.NEW + string2 + "(myMib)" + Def.SEMICOLON);
        this.constructor2.append(Def.TAB2 + string3 + " = " + Def.NEW + string2 + "(myMib, server)" + Def.SEMICOLON);
        this.accessors.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.access", string3) + "\n" + Def.TAB + " */\n");
        this.accessors.append(Def.TAB + Def.PUBLIC + string2 + Def.ACCESS + string3 + "() " + BeanGenerator.accessThrows);
        this.accessors.append(Def.TAB2 + Def.RETURN + string3 + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.accessors.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.table.entry", string3) + "\n" + Def.TAB + " */\n");
        this.accessors.append(Def.TAB + Def.PUBLIC + string + Def.MBEANSUFFIX + "[] " + Def.GET + string3 + "() " + BeanGenerator.accessThrows);
        this.accessors.append(Def.TAB2 + Def.RETURN + string3 + ".getEntries()" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void addGetter(Context context, MibNode mibNode, String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.getter", string3) + "\n" + Def.TAB + " */\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + string2 + Def.GET + string3 + "() " + BeanGenerator.accessThrows);
        stringBuffer.append(Def.TAB2 + Def.RETURN + string3 + Def.SEMICOLON);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void addChecker(Context context, MibNode mibNode, String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.checker", string3) + "\n" + Def.TAB + " */\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.CHECK + string3 + "(" + string2 + "x) " + BeanGenerator.accessThrows);
        stringBuffer.append(Def.TAB2 + "//\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.mbean.comment.checker.policy") + "\n" + Def.TAB2 + "//\n");
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void addSetter(Context context, MibNode mibNode, String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.setter", string3) + "\n" + Def.TAB + " */\n");
        stringBuffer.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.SET + string3 + "(" + string2 + "x) " + BeanGenerator.accessThrows);
        stringBuffer.append(Def.TAB2 + string3 + " = x" + Def.SEMICOLON);
        stringBuffer.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void addAccessors(MibNode mibNode, String string, String string2) throws IOException {
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        String string3 = aSTObjectTypeDefinition.getDefinition().getDescription();
        this.addGetter(this.context, mibNode, string3, string, string2, this.accessors);
        int n = aSTObjectTypeDefinition.getDefinition().getAccess();
        if (n == 68 || n == 85 || n == 66) {
            this.addSetter(this.context, mibNode, string3, string, string2, this.accessors);
            this.addChecker(this.context, mibNode, string3, string, string2, this.accessors);
        }
    }

    protected void addCacheVar(MibNode mibNode, String string, long l, String string2, String string3) throws IOException {
        this.var_list.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.varUse", string3) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.varOid", mibNode.getOid()) + "\n" + Def.TAB);
        if (l != -1L) {
            this.var_list.append(" * " + MessageHandler.getMessage("generate.mbean.comment.varFix", String.valueOf(l)) + "\n" + Def.TAB);
        }
        if (this.mib.isDescriptionOn()) {
            ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
            String string4 = aSTObjectTypeDefinition.getDefinition().getDescription();
            this.var_list.append(this.formatDescription(string4));
        }
        this.var_list.append(" */\n");
        if (string2 == null) {
            string2 = "";
        }
        this.var_list.append(Def.TAB + Def.PROTECTED + string + string3 + string2 + Def.SEMICOLON + "\n");
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor1.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.noRegistration") + "\n" + Def.TAB + " */\n");
        this.constructor1.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib)" + Def.LBRACE);
        this.constructor2.append("\n" + Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.constr", this.symboleName) + "\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mbean.comment.registration") + "\n" + Def.TAB + " */\n");
        this.constructor2.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib, MBeanServer server)" + Def.LBRACE);
    }

    protected void closeConstructor() throws IOException {
        this.constructor1.append(Def.TAB + Def.RBRACE + "\n");
        this.constructor2.append(Def.TAB + Def.RBRACE + "\n");
    }
}

