/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTValue;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.EnumGenerator;
import com.sun.jdmk.tools.mibgen.Enumerated;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MbeanGenerator;
import com.sun.jdmk.tools.mibgen.MbeanIfGenerator;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MetaGroupGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class GroupGenerator
extends Generator
implements Serializable {
    public GroupGenerator(ResourceManager resourceManager, Context context) {
        super(resourceManager, context);
    }

    public void generateCode(MibNode mibNode, Context context) throws IOException {
        MbeanGenerator mbeanGenerator = new MbeanGenerator(this.manager, mibNode, context);
        MbeanIfGenerator mbeanIfGenerator = new MbeanIfGenerator(this.manager, mibNode, context);
        MetaBeanGenerator metaBeanGenerator = this.mkMetaBeanGenerator(this.manager, mibNode, context);
        Enumeration enumeration = mibNode.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode2 = (MibNode)enumeration.nextElement();
            mbeanGenerator.handleNode(mibNode2);
            mbeanIfGenerator.handleNode(mibNode2);
            metaBeanGenerator.handleNode(mibNode2);
        }
        mbeanGenerator.endOfGroup();
        mbeanIfGenerator.endOfGroup();
        metaBeanGenerator.endOfGroup();
    }

    public void buildSymbolTable(MibNode mibNode, Context context) throws IOException {
        Enumeration enumeration = mibNode.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode2 = (MibNode)enumeration.nextElement();
            if (!mibNode2.isAssociated()) continue;
            if (mibNode2.isTable()) {
                this.buildTableSymbolTable(mibNode2, context);
                continue;
            }
            this.buildVariableSymbolTable(mibNode2, context);
        }
    }

    protected void buildTableSymbolTable(MibNode mibNode, Context context) throws IOException {
        Enumeration enumeration = mibNode.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode2 = (MibNode)enumeration.nextElement();
            if (!mibNode2.isAssociated()) continue;
            this.buildSymbolTable(mibNode2, context);
        }
    }

    public void addExternalSymbol(Context context, String string) {
        if (context == null) {
            return;
        }
        if (context.modules == null) {
            return;
        }
        MibNode mibNode = context.modules.findNodeWithName(string);
        if (mibNode == null) {
            return;
        }
        if (mibNode.isVariable()) {
            this.buildVariableSymbolTable(mibNode, context);
        }
    }

    protected void buildVariableSymbolTable(MibNode mibNode, Context context) {
        String string = mibNode.getSymbolName();
        ASTObjectTypeDefinition aSTObjectTypeDefinition = mibNode.getObjectType();
        if (aSTObjectTypeDefinition == null) {
            return;
        }
        ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
        String string2 = null;
        ASTValue aSTValue = aSTObjectTypeDefinition.getDefValue();
        if (aSTNamedType.isEnumeratedType()) {
            string2 = this.getEnumClassName(this.context, string, aSTNamedType.getEnumeratedDef());
            mibNode.setEnumerated(true);
            mibNode.setEnumeratedType(string2);
        } else {
            string2 = aSTNamedType.getMbeanSyntax();
        }
        String string3 = aSTNamedType.getTypeReferenceName();
        if (string3 != null) {
            context.setTypeRef(string, string3);
        }
        context.setJavaSyntax(string, string2);
    }

    public String getEnumClassName(Context context, String string, Enumerated enumerated) {
        return EnumGenerator.getEnumClassName(context, string, enumerated);
    }

    public MetaBeanGenerator mkMetaBeanGenerator(ResourceManager resourceManager, MibNode mibNode, Context context) throws IOException {
        if (mibNode.isGroup()) {
            return new MetaGroupGenerator(resourceManager, mibNode, context);
        }
        return new MetaBeanGenerator(resourceManager, mibNode, context);
    }
}

