/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class Generator
implements Serializable {
    protected ASTMib mib;
    protected String packageName = "";
    protected String prefix = "";
    protected String targetDir = "";
    protected File targetFile;
    protected RandomAccessFile out;
    ResourceManager manager;
    Context context;
    private String defaultOidPrefix = "oid_";

    public Generator(ResourceManager resourceManager, Context context) {
        this.manager = resourceManager;
        this.packageName = context.packageName;
        this.prefix = context.prefix;
        this.targetDir = context.dir;
        this.context = context;
        this.defaultOidPrefix = context.defaultOidPrefix;
    }

    public void setContext(Context context) {
        this.packageName = context.packageName;
        this.prefix = context.prefix;
        this.targetDir = context.dir;
        this.defaultOidPrefix = context.defaultOidPrefix;
        this.context = context;
    }

    public void setMib(ASTMib aSTMib) {
        this.mib = aSTMib;
        this.context.mib = aSTMib;
    }

    protected boolean isRowStatus(Context context, String string) {
        String string2 = context.getTypeRef(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals("RowStatus");
    }

    protected RandomAccessFile openFile(String string) throws IOException {
        File file = this.checkFile(string);
        return new RandomAccessFile(file, "rw");
    }

    protected synchronized void write(String string) throws IOException {
        try {
            this.out.writeBytes(string);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
    }

    protected void writeVersion() throws IOException {
        String string = "generate.version";
        if (this.isGeneric()) {
            string = "generate.version.generic";
        } else if (this.isStandard()) {
            string = "generate.version.standard";
        }
        this.write("\n//\n// " + MessageHandler.getMessage(string, this.mib.getModuleName()) + "\n//\n\n");
    }

    protected void writePkg() throws IOException {
        if (this.packageName.length() != 0) {
            this.write(Def.PACKAGE + this.packageName + Def.SEMICOLON);
        }
        this.writeVersion();
    }

    protected String translateOid(String string) {
        return Generator.translateOid(this.context, string);
    }

    public static String translateOid(Context context, String string) {
        if (context.prefix == null || context.prefix.length() == 0) {
            return context.defaultOidPrefix + string.replace('.', '_');
        }
        return string.replace('.', '_');
    }

    boolean isStandard() {
        return (this.context.gentype & 1) != 0;
    }

    boolean isGeneric() {
        return (this.context.gentype & 2) != 0;
    }

    private File checkFile(String string) throws IOException {
        File file = this.targetDir.length() != 0 ? new File(this.targetDir, string) : new File(string);
        if (file.exists()) {
            String string2 = string + "~";
            File file2 = new File(this.targetDir, string2);
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                Trace.error(MessageHandler.getMessage("compile.error.noWritePermission", file.getName()));
                throw new IOException("The file " + file.getName() + " belongs to another user");
            }
        }
        return file;
    }

    public static String getClassName(Context context, String string) {
        Hashtable hashtable = context.mib.oidTranslation;
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            string2 = Generator.translateOid(context, string);
        }
        String string3 = string2.trim();
        string3 = string3.replace('-', '_');
        string3 = string3.replace('.', '_');
        string3 = string3.replace(',', '_');
        string3 = string3.replace(',', '_');
        string3 = string3.replace(' ', '_');
        return Character.toUpperCase(string3.charAt(0)) + string3.substring(1, string3.length());
    }

    protected String getClassName(String string) {
        return Generator.getClassName(this.context, string);
    }

    protected void closeIO() throws IOException {
        this.out.close();
    }
}

