/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Enumerated;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EnumGenerator
extends Generator
implements Serializable {
    protected StringBuffer var_list = new StringBuffer();
    protected StringBuffer accessors = new StringBuffer();
    protected StringBuffer constructor = new StringBuffer();
    protected Enumerated enum;
    private String typeName;
    private static Hashtable enumList = new Hashtable();

    public EnumGenerator(ResourceManager resourceManager, String string, Enumerated enumerated, Context context) throws IOException {
        super(resourceManager, context);
        this.typeName = EnumGenerator.getRealEnumName(context, string, enumerated);
        this.enum = enumerated;
        this.mib = context.mib;
        EnumGenerator enumGenerator = (EnumGenerator)enumList.get(this.typeName);
        if (enumGenerator == null) {
            this.generateEnum();
            enumList.put(this.typeName, this);
        }
    }

    public static String getRealEnumName(Context context, String string, Enumerated enumerated) {
        String string2 = enumerated.getSymbol();
        if (string2.length() == 0) {
            return string;
        }
        EnumGenerator enumGenerator = (EnumGenerator)enumList.get(string2);
        if (enumGenerator != null) {
            return enumGenerator.getRealName();
        }
        return string2;
    }

    public static String getEnumClassName(Context context, String string, Enumerated enumerated) {
        String string2 = EnumGenerator.getRealEnumName(context, string, enumerated);
        return context.prefix + Def.ENUMPREFIX + string2 + " ";
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.mib = context.mib;
    }

    protected String getRealName() {
        return this.typeName;
    }

    public String getTypeName() {
        return this.prefix + Def.ENUMPREFIX + this.typeName + " ";
    }

    protected void writeVersion() throws IOException {
        String string = "generate.version";
        this.write("\n//\n// " + MessageHandler.getMessage(string, this.mib.getModuleName()) + "\n//\n\n");
    }

    private void generateEnum() throws IOException {
        String string = this.prefix + Def.ENUMPREFIX + this.typeName;
        Trace.info(MessageHandler.getMessage("generate.info.enum", this.typeName));
        this.out = this.openFile(string + Def.JAVA);
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_HASHTABLE + Def.SEMICOLON);
        this.write("\n// RI imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_ENUMERATED + Def.SEMICOLON + "\n");
        this.write("/**\n * " + MessageHandler.getMessage("generate.enum.comment.desc", this.typeName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + string + Def.EXTEND + Def.ENUM_CLASS);
        this.write(Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n" + Def.TAB + "protected static Hashtable intTable = new Hashtable();\n" + Def.TAB + "protected static Hashtable stringTable = new Hashtable();\n");
        this.write(Def.TAB + Def.STATIC + Def.LBRACE);
        Hashtable hashtable = this.enum.getEnum();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            stringBuffer.append(Def.TAB2 + Def.ENUM_INTTAB + ".put(new Integer(" + string3 + "), \"" + string2 + "\");\n");
            stringBuffer2.append(Def.TAB2 + Def.ENUM_STRINGTAB + ".put(\"" + string2 + "\", new Integer(" + string3 + "));\n");
        }
        this.write(stringBuffer.toString());
        this.write(stringBuffer2.toString());
        this.write(Def.TAB + Def.RBRACE + "\n");
        this.write(Def.TAB + Def.PUBLIC + string + "(int valueIndex) " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super(valueIndex)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n" + Def.TAB + Def.PUBLIC + string + "(Integer valueIndex) " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super(valueIndex)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n" + Def.TAB + Def.PUBLIC + string + "() " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super()" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n" + Def.TAB + Def.PUBLIC + string + "(String x) " + Def.THROWS + Def.EXCP_ARGUMENT + Def.LBRACE + Def.TAB2 + "super(x)" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
        this.write(Def.TAB + "protected Hashtable getIntTable() {\n" + Def.TAB2 + "return intTable ;\n" + Def.TAB + Def.RBRACE + "\n" + Def.TAB + "protected Hashtable getStringTable() {\n" + Def.TAB2 + "return stringTable ;\n" + Def.TAB + Def.RBRACE + "\n" + Def.RBRACE);
        this.closeIO();
    }
}

