/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTModuleIdentifier;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTNotificationType;
import com.sun.jdmk.tools.mibgen.ASTObjectIdentity;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ASTOidValue;
import com.sun.jdmk.tools.mibgen.ASTValue;
import com.sun.jdmk.tools.mibgen.IdentifierHandler;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibTree;
import com.sun.jdmk.tools.mibgen.ModulesHandler;
import com.sun.jdmk.tools.mibgen.Node;
import com.sun.jdmk.tools.mibgen.ObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.ParseException;
import com.sun.jdmk.tools.mibgen.Parser;
import com.sun.jdmk.tools.mibgen.RegisteredObject;
import com.sun.jdmk.tools.mibgen.SemanticException;
import com.sun.jdmk.tools.mibgen.SimpleNode;
import com.sun.jdmk.tools.mibgen.SyntaxHandler;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ASTMib
extends SimpleNode {
    protected ASTModuleIdentifier moduleIdentifier;
    protected Hashtable registrationTable = new Hashtable();
    protected Hashtable objectIdentities = new Hashtable();
    protected Hashtable notificationTypes = new Hashtable();
    protected Hashtable valueDefs = new Hashtable();
    protected Hashtable syntaxDefs = new Hashtable();
    protected Hashtable oidTranslation = new Hashtable();
    protected Hashtable symbolTranslation = new Hashtable();
    protected Hashtable v1 = new Hashtable();
    protected Hashtable v2 = new Hashtable();
    protected MibTree tree = null;
    private ModulesHandler modulesHandler;
    private boolean useDescription = true;
    protected IdentifierHandler identifierHandler;
    protected IdentifierHandler indexHandler;
    protected SyntaxHandler syntaxHandler;

    ASTMib(int n) {
        super(n);
    }

    ASTMib(Parser parser, int n) {
        super(parser, n);
    }

    public static Node jjtCreate(int n) {
        return new ASTMib(n);
    }

    public static Node jjtCreate(Parser parser, int n) {
        return new ASTMib(parser, n);
    }

    public void registerValueDef(String string, SimpleNode simpleNode) {
        if (this.valueDefs.containsKey(string)) {
            Trace.warning(MessageHandler.getMessage("compile.w.multiple.value", string, this.getModuleName()));
        }
        this.valueDefs.put(string, simpleNode);
    }

    public void registerSymbol(String string, SimpleNode simpleNode) throws SemanticException {
        if (this.registrationTable.containsKey(string)) {
            throw new SemanticException(MessageHandler.getMessage("compile.error.multiple.register", string, this.getModuleName()));
        }
        this.registrationTable.put(string, simpleNode);
    }

    public void registerObjectIdentity(String string, SimpleNode simpleNode) throws ParseException {
        if (this.objectIdentities.containsKey(string)) {
            Trace.error(MessageHandler.getMessage("compile.error.multiple.objectidentity", string, this.getModuleName()));
        }
        this.objectIdentities.put(string, simpleNode);
        this.registerSymbol(string, simpleNode);
    }

    public void registerNotificationType(String string, SimpleNode simpleNode) throws ParseException {
        if (this.notificationTypes.containsKey(string)) {
            Trace.error(MessageHandler.getMessage("compile.error.multiple.notificationtype", string, this.getModuleName()));
        }
        this.notificationTypes.put(string, simpleNode);
        this.registerSymbol(string, simpleNode);
    }

    public void registerSyntaxDef(String string, SimpleNode simpleNode) {
        if (this.syntaxDefs.containsKey(string)) {
            Trace.warning(MessageHandler.getMessage("compile.w.multiple.syntax", string, this.getModuleName()));
        }
        this.syntaxDefs.put(string, simpleNode);
    }

    public void registerV1ObjectType(String string, ASTObjectTypeDefinition aSTObjectTypeDefinition) throws ParseException {
        if (this.v1.containsKey(string)) {
            throw new SemanticException(MessageHandler.getMessage("compile.w.multiple.v1Object", string, this.getModuleName()));
        }
        this.v1.put(string, aSTObjectTypeDefinition);
        this.registerSymbol(string, aSTObjectTypeDefinition);
    }

    public void registerV2ObjectType(String string, ASTObjectTypeDefinition aSTObjectTypeDefinition) throws ParseException {
        if (this.v2.containsKey(string)) {
            throw new SemanticException(MessageHandler.getMessage("compile.w.multiple.v2Object", string, this.getModuleName()));
        }
        this.v2.put(string, aSTObjectTypeDefinition);
        this.registerSymbol(string, aSTObjectTypeDefinition);
    }

    public void localResolve() {
        this.identifierHandler = new IdentifierHandler(this.getModuleName());
        this.indexHandler = new IdentifierHandler(this.getModuleName());
        this.syntaxHandler = new SyntaxHandler(this.getModuleName());
        Trace.info(MessageHandler.getMessage("compile.resolve.local", this.getModuleName()));
        this.resolveValues();
        this.resolveObjectIdentities();
        this.resolveNotificationTypes();
        this.resolveSyntaxes();
        this.resolveAllObjectTypes();
    }

    public void globalResolve(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        Trace.info(MessageHandler.getMessage("compile.resolve.global", this.getModuleName()));
        this.identifierHandler.resolve(hashtable);
        this.syntaxHandler.resolve(hashtable2);
        this.indexHandler.resolve(hashtable3);
    }

    public String resolveOidSymbol(String string) {
        String string2 = null;
        string2 = this.getAssociatedOid(string);
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        return string2;
    }

    public String translateOid(String string) {
        String string2 = null;
        string2 = this.resolveOidSymbol(string);
        if (string2 != null) {
            return string2;
        }
        Enumeration enumeration = this.getModuleHandler().mibElements();
        while (enumeration.hasMoreElements()) {
            ASTMib aSTMib = (ASTMib)enumeration.nextElement();
            string2 = aSTMib.resolveOidSymbol(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String getValueDef(String string) throws SemanticException {
        SimpleNode simpleNode = (SimpleNode)this.valueDefs.get(string);
        if (simpleNode == null) {
            return null;
        }
        Vector<SimpleNode> vector = new Vector<SimpleNode>();
        vector.addElement(simpleNode);
        return simpleNode.computeValue(vector).toString();
    }

    public String getModuleName() {
        return this.moduleIdentifier.getModuleName();
    }

    public ModulesHandler getModuleHandler() {
        return this.modulesHandler;
    }

    public void setModulesHandler(ModulesHandler modulesHandler) {
        this.modulesHandler = modulesHandler;
    }

    public boolean buildMibTree() {
        this.buildOidTable();
        this.tree = new MibTree(this.getModuleName());
        boolean bl = this.tree.buildTree(this.v1, this.v2);
        return bl;
    }

    public MibTree getMibTree() {
        return this.tree;
    }

    public void buildOidTable() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Enumeration enumeration = this.valueDefs.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            object3 = (SimpleNode)this.valueDefs.get(object4);
            object2 = new Vector<Object>();
            ((Vector)object2).addElement(object3);
            try {
                object = ((SimpleNode)object3).computeValue((Vector)object2);
                if (((StringBuffer)object).length() == 0) continue;
                this.oidTranslation.put(((StringBuffer)object).toString(), object4);
                this.symbolTranslation.put(object4, ((StringBuffer)object).toString());
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
        object4 = this.registrationTable.keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            object2 = (RegisteredObject)this.registrationTable.get(object3);
            object = object2.getOidNode();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(object);
            try {
                StringBuffer stringBuffer = ((ASTOidValue)object).computeValue(vector);
                if (stringBuffer.length() == 0) continue;
                this.oidTranslation.put(stringBuffer.toString(), object3);
                this.symbolTranslation.put(object3, stringBuffer.toString());
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    public void printMibTree(String string) {
        this.tree.dump(string);
    }

    public Hashtable getOidTranslation() {
        return this.oidTranslation;
    }

    public Hashtable getSymbolTranslation() {
        return this.symbolTranslation;
    }

    public String getAssociatedOid(String string) {
        return (String)this.symbolTranslation.get(string);
    }

    public String getAssociatedSymbol(String string) {
        return (String)this.oidTranslation.get(string);
    }

    public boolean computeValues() {
        if (!this.computeAllObjectTypeOid()) {
            return false;
        }
        if (!this.computeObjectIdentityOid()) {
            return false;
        }
        return this.computeNotificationTypeOid();
    }

    public IdentifierHandler getIdResolver() {
        return this.identifierHandler;
    }

    public IdentifierHandler getIndexResolver() {
        return this.indexHandler;
    }

    public SyntaxHandler getRefResolver() {
        return this.syntaxHandler;
    }

    public boolean printUndefinedSymbols() {
        return this.identifierHandler.printUnresolved() && this.syntaxHandler.printUnresolved() && this.indexHandler.printUnresolved();
    }

    private void resolveValues() {
        Enumeration enumeration = this.valueDefs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SimpleNode simpleNode = (SimpleNode)this.valueDefs.get(string);
            simpleNode.resolve(this.identifierHandler, string);
        }
    }

    private void resolveSyntaxes() {
        Enumeration enumeration = this.syntaxDefs.elements();
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode = (SimpleNode)enumeration.nextElement();
            simpleNode.resolve(this.syntaxHandler);
        }
    }

    private void resolveAllObjectTypes() {
        this.resolveObjectType(this.v1);
        this.resolveObjectType(this.v2);
    }

    private void resolveObjectIdentities() {
        Enumeration enumeration = this.objectIdentities.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ASTObjectIdentity aSTObjectIdentity = (ASTObjectIdentity)this.objectIdentities.get(string);
            ASTOidValue aSTOidValue = aSTObjectIdentity.getOidNode();
            aSTOidValue.resolve(this.identifierHandler, string);
        }
    }

    private void resolveNotificationTypes() {
        Enumeration enumeration = this.notificationTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ASTNotificationType aSTNotificationType = (ASTNotificationType)this.notificationTypes.get(string);
            ASTOidValue aSTOidValue = aSTNotificationType.getOidNode();
            aSTOidValue.resolve(this.identifierHandler, string);
        }
    }

    private void resolveObjectType(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Node node;
            String string = (String)enumeration.nextElement();
            ASTObjectTypeDefinition aSTObjectTypeDefinition = (ASTObjectTypeDefinition)hashtable.get(string);
            this.indexHandler.addResolution(string, aSTObjectTypeDefinition);
            ObjectTypeDefinition objectTypeDefinition = aSTObjectTypeDefinition.getDefinition();
            ASTOidValue aSTOidValue = objectTypeDefinition.getOidNode();
            aSTOidValue.resolve(this.identifierHandler, string);
            ASTNamedType aSTNamedType = aSTObjectTypeDefinition.getSyntax();
            aSTNamedType.resolve(this.syntaxHandler);
            ASTValue aSTValue = objectTypeDefinition.getDefValue();
            if (aSTValue != null) {
                aSTValue.setDefValSnmpSyntax(SyntaxMapper.getIntSnmpSyntax(aSTObjectTypeDefinition.getSnmpSyntax()));
                aSTValue.resolve(this.identifierHandler);
            }
            if ((node = objectTypeDefinition.getIndex()) == null) continue;
            this.resolveIndexOfTable(node);
        }
    }

    private void resolveIndexOfTable(Node node) {
        SimpleNode simpleNode = (SimpleNode)node;
        simpleNode.validateIndexNames(this.indexHandler);
    }

    private boolean computeNotificationTypeOid() {
        boolean bl = true;
        Enumeration enumeration = this.notificationTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ASTNotificationType aSTNotificationType = (ASTNotificationType)this.notificationTypes.get(string);
            ASTOidValue aSTOidValue = aSTNotificationType.getOidNode();
            Vector<ASTOidValue> vector = new Vector<ASTOidValue>();
            vector.addElement(aSTOidValue);
            try {
                StringBuffer stringBuffer = aSTOidValue.computeValue(vector);
            }
            catch (SemanticException semanticException) {
                String string2 = semanticException.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", string, string2, this.getModuleName()));
                bl = false;
            }
        }
        return bl;
    }

    private boolean computeObjectIdentityOid() {
        boolean bl = true;
        Enumeration enumeration = this.objectIdentities.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ASTObjectIdentity aSTObjectIdentity = (ASTObjectIdentity)this.objectIdentities.get(string);
            ASTOidValue aSTOidValue = aSTObjectIdentity.getOidNode();
            Vector<ASTOidValue> vector = new Vector<ASTOidValue>();
            vector.addElement(aSTOidValue);
            try {
                StringBuffer stringBuffer = aSTOidValue.computeValue(vector);
            }
            catch (SemanticException semanticException) {
                String string2 = semanticException.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", string, string2, this.getModuleName()));
                bl = false;
            }
        }
        return bl;
    }

    private boolean computeAllObjectTypeOid() {
        return this.computeObjectTypeOid(this.v1) && this.computeObjectTypeOid(this.v2);
    }

    private boolean computeObjectTypeOid(Hashtable hashtable) {
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ASTObjectTypeDefinition aSTObjectTypeDefinition = (ASTObjectTypeDefinition)hashtable.get(string);
            ObjectTypeDefinition objectTypeDefinition = aSTObjectTypeDefinition.getDefinition();
            ASTOidValue aSTOidValue = objectTypeDefinition.getOidNode();
            Vector<ASTOidValue> vector = new Vector<ASTOidValue>();
            vector.addElement(aSTOidValue);
            try {
                StringBuffer stringBuffer = aSTOidValue.computeValue(vector);
            }
            catch (SemanticException semanticException) {
                String string2 = semanticException.getMessage();
                Trace.error(MessageHandler.getMessage("compile.error.loop", string, string2, this.getModuleName()));
                bl = false;
            }
        }
        return bl;
    }

    public void setDescriptionOn() {
        this.useDescription = true;
    }

    public void setDescriptionOff() {
        this.useDescription = false;
    }

    public boolean isDescriptionOn() {
        return this.useDescription;
    }

    public void setDescriptionHandling(boolean bl) {
        this.useDescription = bl;
    }
}

