/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ProxyGenClassLoader
extends ClassLoader {
    private File[] path;
    private Hashtable classes = new Hashtable();
    private Hashtable zips = new Hashtable();

    public ProxyGenClassLoader(String string) {
        this.path = this.split(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.locateClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class locateClass(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string);
        if (clazz != null) {
            return clazz;
        }
        int n = 0;
        while (n < this.path.length) {
            clazz = this.path[n].isDirectory() ? this.locateClassInDir(string, this.path[n]) : this.locateClassInJar(string, this.path[n]);
            if (clazz != null) {
                this.classes.put(string, clazz);
                return clazz;
            }
            ++n;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class locateClassInDir(String string, File file) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        try {
            Class<?> clazz;
            block6: {
                File file2 = new File(file, string2);
                FileInputStream fileInputStream = new FileInputStream(file2);
                try {
                    int n = ((InputStream)fileInputStream).available();
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    while (n2 < byArray.length) {
                        n2 += ((InputStream)fileInputStream).read(byArray, n2, byArray.length - n2);
                    }
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                    Object var11_11 = null;
                    if (fileInputStream == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
            }
            return clazz;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class locateClassInJar(String string, File file) throws ClassNotFoundException {
        String string2 = string.replace('.', '/') + ".class";
        try {
            Class<?> clazz;
            block8: {
                ZipEntry zipEntry;
                ZipFile zipFile = (ZipFile)this.zips.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zips.put(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string2)) == null) {
                    return null;
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    int n = inputStream.available();
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    while (n2 < byArray.length) {
                        n2 += inputStream.read(byArray, n2, byArray.length - n2);
                    }
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                    Object var12_12 = null;
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return clazz;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File[] split(String string) {
        char c = File.pathSeparatorChar;
        Vector vector = new Vector();
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            this.add(string.substring(n, n2), vector);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        if (n != string.length()) {
            this.add(string.substring(n), vector);
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void add(String string, Vector vector) {
        if (string.length() != 0) {
            vector.addElement(new File(string));
        }
    }
}

