/*
 * Copyright (c) 1989-1996, 1999-2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_MD_CRC_H
#define	_SYS_MD_CRC_H

#pragma ident	"@(#)md_crc.h	2.2	01/08/03 SMI"

#include <sys/types.h>

#ifdef	__cplusplus
extern "C" {
#endif

/* md_crc.c */
extern uint_t			crcfunc(uint_t check,
				    uchar_t *record,
				    uint_t *result,
				    size_t size,
				    uchar_t *skip,
				    uint_t skip_size);
extern void			crcfreetab(void);

#ifndef DEBUG
#define	crcgen(record, result, size, skip) \
	(void) crcfunc(0, (uchar_t *)(record), (uint_t *)(result), \
	    (size_t)(size), (uchar_t *)(skip), 12)
#else /* DEBUG */

#ifdef	_KERNEL
#define	crcgen(record, result, size, skip)		{\
	uint_t b = crcfunc(0, (uchar_t *)(record), (uint_t *)(result), \
	    (size_t)(size), (uchar_t *)(skip), 12); \
	(void) crcfunc(0, (uchar_t *)(record), (uint_t *)(result), \
	    (size_t)(size), (uchar_t *)(skip), 12); \
	ASSERT (*((uint_t *)(result)) == b); \
}
#else	/* !_KERNEL */
#define	crcgen(record, result, size, skip)		{\
	uint_t b = crcfunc(0, (uchar_t *)(record), (uint_t *)(result), \
	    (size_t)(size), (uchar_t *)(skip), 12); \
	(void) crcfunc(0, (uchar_t *)(record), (uint_t *)(result), \
	    (size_t)(size), (uchar_t *)(skip), 12); \
	assert (*((uint_t *)(result)) == b); \
}
#endif	/* _KERNEL */
#endif	/* DEBUG */

#define	crcchk(record, result, size, skip) crcfunc(1, (uchar_t *)(record), \
	(uint_t *)(result), (size_t)(size), (uchar_t *)(skip), 12)

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_MD_CRC_H */
