/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.DAAdvertiser;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.Listener;
import com.sun.slp.RequestHandler;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPDgui;
import com.sun.slp.SLPServerHeaderV2;
import com.sun.slp.SLPV1Manager;
import com.sun.slp.SSAAdvert;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceTable;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.StreamListener;
import com.sun.slp.Transact;
import java.awt.TextArea;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class slpd
extends SLPConfig {
    private static final String SERVER_BUNDLE_NAME = "com/sun/slp/Server";
    private static String configFile;
    private static SLPDgui slpdgui;
    private static SLPConfig config;
    private static ServerDATable daTable;
    private static final String serverMsgBundle = "Server";

    protected slpd() {
    }

    static boolean daemonIsDA() throws ServiceLocationException {
        DATable dATable = DATable.getDATable();
        Hashtable hashtable = dATable.findDAScopes(config.getSAConfiguredScopes());
        Vector vector = (Vector)hashtable.get("&&**^^UNICASTxxxKEY^^**&&");
        Vector vector2 = config.getInterfaces();
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            DATable.DARecord dARecord = (DATable.DARecord)vector.elementAt(n2);
            Vector vector3 = dARecord.daAddresses;
            int n3 = vector2.size();
            int n4 = 0;
            while (n4 < n3) {
                if (vector3.contains(vector2.elementAt(n2))) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    static void errorExit(ResourceBundle resourceBundle, ServiceLocationException serviceLocationException) {
        switch (serviceLocationException.getErrorCode()) {
            case 20: {
                System.err.println(SLPConfig.formatMessageInternal("slpd_int_err", new Object[]{serviceLocationException.getMessage()}, resourceBundle));
                break;
            }
            case 17: {
                System.err.println(SLPConfig.formatMessageInternal("slpd_intnet_err", new Object[]{serviceLocationException.getMessage()}, resourceBundle));
                break;
            }
            case 19: {
                System.err.println(SLPConfig.formatMessageInternal("slpd_net_err", new Object[]{serviceLocationException.getMessage()}, resourceBundle));
                break;
            }
            default: {
                System.err.println(SLPConfig.formatMessageInternal("slpd_err", new Object[]{new Integer(serviceLocationException.getErrorCode()), serviceLocationException.getMessage()}, resourceBundle));
            }
        }
        serviceLocationException.printStackTrace();
        System.err.println(SLPConfig.formatMessageInternal("exiting_msg", new Object[0], resourceBundle));
        System.exit(1);
    }

    ResourceBundle getMessageBundle(Locale locale) {
        ResourceBundle resourceBundle = super.getMessageBundle(locale);
        return slpd.getMessageBundleInternal(locale, resourceBundle);
    }

    private static ResourceBundle getMessageBundleInternal(Locale locale, ResourceBundle resourceBundle) {
        ResourceBundle resourceBundle2 = null;
        try {
            resourceBundle2 = ServerBundle.getBundle(resourceBundle, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource bundle ``com/sun/slp/Server'' for locale ``" + locale + "''");
            if (locale.equals(Defaults.locale)) {
                System.out.println("Exiting...");
                System.exit(1);
            }
            System.out.println("Using SLP default locale ``" + Defaults.locale + "''");
            resourceBundle2 = slpd.getMessageBundleInternal(Defaults.locale, resourceBundle);
        }
        return resourceBundle2;
    }

    private static SLPConfig initializeSLPConfig() {
        SLPConfig.isSA = true;
        if (System.getProperty("sun.net.slp.loggerClass") == null) {
            Properties properties = System.getProperties();
            properties.setProperty("sun.net.slp.loggerClass", "com.sun.slp.Syslog");
            System.setProperties(properties);
        }
        SLPConfig.theSLPConfig = new slpd();
        return SLPConfig.theSLPConfig;
    }

    boolean isDA() {
        return Boolean.getBoolean("net.slp.isDA");
    }

    boolean isV1Supported() {
        if (!this.isDA() || super.getSLPv1NotSupported()) {
            return false;
        }
        boolean bl = false;
        try {
            Class.forName("com.sun.slp.SLPV1Manager");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return bl;
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        configFile = null;
        Thread.currentThread().setName("slpd");
        if (stringArray.length > 3) {
            slpd.usage();
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals("-f")) {
                if (configFile != null) {
                    slpd.usage();
                }
                try {
                    object = new File(stringArray[++n2]);
                    configFile = stringArray[n2];
                }
                catch (Exception exception) {
                    slpd.usage();
                }
            } else if (stringArray[n2].equals("monitor")) {
                bl = true;
            } else if (stringArray[n2].equals("stop")) {
                bl2 = true;
            } else {
                slpd.usage();
            }
            ++n2;
        }
        object = slpd.getMessageBundleInternal(Locale.getDefault(), null);
        try {
            Object object2;
            if (configFile != null) {
                object2 = System.getProperties();
                ((Properties)object2).setProperty("sun.net.slp.configURL", "file:" + configFile);
            }
            config = slpd.initializeSLPConfig();
            if (bl) {
                try {
                    slpdgui = new SLPDgui(configFile);
                    object2 = new SLPLog(slpdgui.getTALog());
                    SLPConfig sLPConfig = config;
                    synchronized (sLPConfig) {
                        slpd.config.log = object2;
                    }
                    slpdgui.show();
                }
                catch (Exception exception) {
                    System.err.println(SLPConfig.formatMessageInternal("slpd_no_gui", new Object[0], (ResourceBundle)object));
                }
            }
            if (!bl2) {
                slpd.start();
            } else {
                slpd.stop();
            }
        }
        catch (ServiceLocationException serviceLocationException) {
            slpd.errorExit((ResourceBundle)object, serviceLocationException);
        }
    }

    static void start() throws ServiceLocationException {
        Serializable serializable;
        Object object;
        ServiceTable serviceTable = ServiceTable.getServiceTable();
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("sun.net.slp.DATableClass", "com.sun.slp.SunServerDATable");
        try {
            if (System.in.available() > 0) {
                object = new RequestHandler(System.in, System.out, config);
                ((Thread)object).start();
            }
        }
        catch (IOException iOException) {}
        StreamListener.initializeStreamListenerOnInterface(config.getLoopback());
        daTable = ServerDATable.getServerDATable();
        serviceTable.deserializeTable();
        object = config.getInterfaces();
        int n = ((Vector)object).size();
        int n2 = 0;
        while (n2 < n) {
            serializable = (InetAddress)((Vector)object).elementAt(n2);
            Listener.initializeInterfaceManagers(serializable);
            ++n2;
        }
        if (config.isDA()) {
            DAAdvertiser.initializeDAAdvertiserOnInterface(config.getLocalHost());
        }
        serializable = daTable.findScopes();
        Vector vector = config.getSAConfiguredScopes();
        Vector vector2 = config.getDAAttributes();
        Vector vector3 = config.getSAAttributes();
        if (config.regTest() || config.traceMsg() || config.traceDrop() || config.traceDATraffic()) {
            config.writeLog(config.isDA() ? "hello_da" : "hello", new Object[]{object, vector, serializable, config.isDA() ? vector2 : vector3});
        }
        if (config.isV1Supported()) {
            SLPV1Manager.start(config, daTable, serviceTable);
        }
    }

    static void stop() throws ServiceLocationException {
        if (slpd.daemonIsDA()) {
            slpd.stopDA();
        } else {
            slpd.stopSA();
        }
    }

    private static void stopDA() throws ServiceLocationException {
        ServiceURL serviceURL = new ServiceURL(String.valueOf(String.valueOf(Defaults.DA_SERVICE_TYPE)) + "://" + config.getLocalHost().getHostAddress(), 10800);
        SDAAdvert sDAAdvert = new SDAAdvert(new SLPServerHeaderV2(), 0, 0L, serviceURL, config.getSAConfiguredScopes(), new Vector());
        DAAdvertiser dAAdvertiser = new DAAdvertiser(config.getLocalHost(), sDAAdvert.getHeader());
        dAAdvertiser.sendAdvert();
        System.exit(0);
    }

    private static void stopSA() throws ServiceLocationException {
        block3: {
            ServiceURL serviceURL = new ServiceURL(String.valueOf(String.valueOf(Defaults.SA_SERVICE_TYPE)) + "://" + config.getLocalHost().getHostAddress(), 10800);
            SSAAdvert sSAAdvert = new SSAAdvert(2, 0, SLPConfig.getLocale(), serviceURL, config.getSAConfiguredScopes(), new Vector());
            try {
                SrvLocMsg srvLocMsg = Transact.transactTCPMsg(config.getLoopback(), sSAAdvert, false);
                if (srvLocMsg.getErrorCode() != 0) {
                    config.writeLog("slpd_sa_stop_failure", new Object[]{new Integer(srvLocMsg.getErrorCode())});
                }
            }
            catch (ServiceLocationException serviceLocationException) {
                if (serviceLocationException.getErrorCode() == 19) break block3;
                config.writeLog("slpd_sa_stop_failure", new Object[]{new Integer(serviceLocationException.getErrorCode())});
            }
        }
        System.exit(0);
    }

    private static void usage() {
        ResourceBundle resourceBundle = slpd.getMessageBundleInternal(Locale.getDefault(), null);
        System.err.println(SLPConfig.formatMessageInternal("slpd_usage", new Object[0], resourceBundle));
        System.exit(1);
    }

    static class ServerBundle
    extends ResourceBundle {
        private ResourceBundle bundle = null;

        private ServerBundle(ResourceBundle resourceBundle, Locale locale) throws MissingResourceException {
            if (resourceBundle != null) {
                this.parent = resourceBundle;
            }
            try {
                URL[] uRLArray = null;
                uRLArray = new URL[]{new URL("file:/usr/share/lib/locale/")};
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                this.bundle = ResourceBundle.getBundle(slpd.SERVER_BUNDLE_NAME, locale, uRLClassLoader);
            }
            catch (MalformedURLException malformedURLException) {}
            this.bundle = this.bundle != null ? this.bundle : ResourceBundle.getBundle(slpd.SERVER_BUNDLE_NAME, locale);
        }

        static ResourceBundle getBundle(ResourceBundle resourceBundle, Locale locale) throws MissingResourceException {
            return new ServerBundle(resourceBundle, locale);
        }

        public Enumeration getKeys() {
            return this.bundle.getKeys();
        }

        protected Object handleGetObject(String string) throws MissingResourceException {
            Object object = null;
            try {
                object = this.bundle.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                object = this.parent.getObject(string);
            }
            return object;
        }
    }

    static class SLPLog
    extends Writer {
        private TextArea taLog = null;
        private StringBuffer buf;

        SLPLog(TextArea textArea) {
            this.taLog = textArea;
            this.buf = new StringBuffer();
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            String string = SLPConfig.getDateString();
            this.taLog.append("********" + string + "\n" + this.buf.toString() + "\n" + "********\n");
            this.buf = new StringBuffer();
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.buf.append(cArray, n, n2);
        }
    }
}

