/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.CAttrMsg;
import com.sun.slp.CDAAdvert;
import com.sun.slp.CSAAdvert;
import com.sun.slp.CSrvMsg;
import com.sun.slp.CSrvTypeMsg;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.Locator;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationEnumeration;
import com.sun.slp.ServiceLocationEnumerator;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.SrvLocMsgImpl;
import com.sun.slp.Transact;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

class UARequester
implements Locator {
    private static SLPConfig config = null;
    private static DATable dat = null;
    private Locale locale;

    UARequester(Locale locale) {
        Assert.nonNullParameter(locale, "locale");
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        if (dat == null) {
            dat = DATable.getDATable();
        }
        this.locale = locale;
    }

    private static void addUnique(Vector vector, Vector vector2, int n) {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            if (!vector2.contains(e) && vector2.size() < n) {
                vector2.addElement(e);
            }
            ++n3;
        }
    }

    private static void checkForError(SrvLocMsg srvLocMsg, Vector vector) throws ServiceLocationException {
        short s = srvLocMsg.getErrorCode();
        if (s != 0) {
            if (vector.size() == 1) {
                config.writeLog("single_exception", new Object[]{new Integer(s)});
                throw new ServiceLocationException(s, "remote_error", new Object[0]);
            }
            config.writeLog("multiple_exception", new Object[]{new Integer(s)});
        }
    }

    private Vector createMessages(int n, Object object, Object object2, ServiceType serviceType, Vector vector) throws ServiceLocationException {
        DATable.validateScopes(vector, this.locale);
        SrvLocMsgImpl srvLocMsgImpl = null;
        SrvLocMsgImpl srvLocMsgImpl2 = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Hashtable hashtable = dat.findDAScopes(vector);
        vector3 = (Vector)hashtable.get("&&**^^MULTICASTxxxKEY^^**&&");
        vector2 = (Vector)hashtable.get("&&**^^UNICASTxxxKEY^^**&&");
        if ((n == 1 || n == 6) && (serviceType.equals(Defaults.DA_SERVICE_TYPE) || serviceType.equals(Defaults.SA_SERVICE_TYPE))) {
            vector3 = vector;
            vector2 = null;
            String string = "";
            if (n == 1) {
                string = (String)object2;
            }
            srvLocMsgImpl = new CSrvMsg(this.locale, serviceType, vector3, string);
        } else {
            if (vector3 != null) {
                switch (n) {
                    case 9: {
                        srvLocMsgImpl = new CSrvTypeMsg(this.locale, (String)object, vector3);
                        break;
                    }
                    case 1: {
                        srvLocMsgImpl = new CSrvMsg(this.locale, serviceType, vector3, (String)object2);
                        break;
                    }
                    case 6: {
                        srvLocMsgImpl = object instanceof ServiceURL ? new CAttrMsg(this.locale, (ServiceURL)object, vector3, (Vector)object2) : new CAttrMsg(this.locale, serviceType, vector3, (Vector)object2);
                    }
                }
            }
            if (vector2 != null) {
                switch (n) {
                    case 9: {
                        srvLocMsgImpl2 = new CSrvTypeMsg(this.locale, (String)object, vector);
                        break;
                    }
                    case 1: {
                        srvLocMsgImpl2 = new CSrvMsg(this.locale, serviceType, vector, (String)object2);
                        break;
                    }
                    case 6: {
                        srvLocMsgImpl2 = object instanceof ServiceURL ? new CAttrMsg(this.locale, (ServiceURL)object, vector, (Vector)object2) : new CAttrMsg(this.locale, serviceType, vector, (Vector)object2);
                    }
                }
            }
        }
        return Transact.transactUA(vector2, srvLocMsgImpl2, srvLocMsgImpl, SLPConfig.getMulticastAddress());
    }

    public synchronized ServiceLocationEnumeration findAttributes(ServiceType serviceType, Vector vector, Vector vector2) throws ServiceLocationException {
        Assert.nonNullParameter(serviceType, "URL");
        Assert.nonNullParameter(vector, "scopes");
        Assert.nonNullParameter(vector2, "attributeIds");
        Vector vector3 = this.createMessages(6, serviceType, vector2, serviceType, vector);
        Vector vector4 = new Vector();
        int n = vector3.size();
        int n2 = config.getMaximumResults();
        Hashtable hashtable = new Hashtable();
        int n3 = 0;
        while (n3 < n && vector4.size() < n2) {
            SrvLocMsg srvLocMsg = (SrvLocMsg)vector3.elementAt(n3);
            UARequester.checkForError(srvLocMsg, vector3);
            Vector vector5 = null;
            if (srvLocMsg instanceof CAttrMsg) {
                vector5 = ((CAttrMsg)srvLocMsg).attrList;
            } else if (srvLocMsg instanceof CSAAdvert) {
                vector5 = ((CSAAdvert)srvLocMsg).attrs;
            } else if (srvLocMsg instanceof CDAAdvert) {
                vector5 = ((CDAAdvert)srvLocMsg).attrs;
            }
            int n4 = vector5.size();
            int n5 = 0;
            while (n5 < n4) {
                ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)vector5.elementAt(n5);
                ServiceLocationAttribute.mergeDuplicateAttributes(serviceLocationAttribute, hashtable, vector4, true);
                if (vector4.size() >= n2) break;
                ++n5;
            }
            ++n3;
        }
        return new ServiceLocationEnumerator(vector4);
    }

    public synchronized ServiceLocationEnumeration findAttributes(ServiceURL serviceURL, Vector vector, Vector vector2) throws ServiceLocationException {
        Assert.nonNullParameter(serviceURL, "URL");
        Assert.nonNullParameter(vector, "scopes");
        Assert.nonNullParameter(vector2, "attributeIds");
        Vector vector3 = this.createMessages(6, serviceURL, vector2, serviceURL.getServiceType(), vector);
        Vector vector4 = new Vector();
        int n = vector3.size();
        int n2 = config.getMaximumResults();
        int n3 = 0;
        while (n3 < n) {
            block6: {
                block4: {
                    SrvLocMsgImpl srvLocMsgImpl;
                    SrvLocMsg srvLocMsg;
                    block5: {
                        block3: {
                            srvLocMsg = (SrvLocMsg)vector3.elementAt(n3);
                            UARequester.checkForError(srvLocMsg, vector3);
                            if (!(srvLocMsg instanceof CAttrMsg)) break block3;
                            vector4 = ((CAttrMsg)srvLocMsg).attrList;
                            break block4;
                        }
                        if (!(srvLocMsg instanceof CSAAdvert)) break block5;
                        srvLocMsgImpl = (CSAAdvert)srvLocMsg;
                        if (!serviceURL.equals(srvLocMsgImpl.URL)) break block6;
                        vector4 = srvLocMsgImpl.attrs;
                        break block4;
                    }
                    if (!(srvLocMsg instanceof CDAAdvert)) break block4;
                    srvLocMsgImpl = (CDAAdvert)srvLocMsg;
                    if (!serviceURL.equals(((CDAAdvert)srvLocMsgImpl).URL)) break block6;
                    vector4 = ((CDAAdvert)srvLocMsgImpl).attrs;
                }
                if (vector4.size() <= n2) break;
                vector4.setSize(n2);
                break;
            }
            ++n3;
        }
        return new ServiceLocationEnumerator(vector4);
    }

    public synchronized ServiceLocationEnumeration findServiceTypes(String string, Vector vector) throws ServiceLocationException {
        Assert.nonNullParameter(string, " NA");
        Assert.nonNullParameter(vector, "scopes");
        Vector vector2 = this.createMessages(9, string, null, null, vector);
        Vector vector3 = new Vector();
        int n = vector2.size();
        int n2 = config.getMaximumResults();
        int n3 = 0;
        while (n3 < n) {
            CSrvTypeMsg cSrvTypeMsg = (CSrvTypeMsg)vector2.elementAt(n3);
            UARequester.checkForError(cSrvTypeMsg, vector2);
            Vector vector4 = cSrvTypeMsg.serviceTypes;
            UARequester.addUnique(vector4, vector3, n2);
            ++n3;
        }
        return new ServiceLocationEnumerator(vector3);
    }

    public synchronized ServiceLocationEnumeration findServices(ServiceType serviceType, Vector vector, String string) throws ServiceLocationException {
        Assert.nonNullParameter(serviceType, "type");
        Assert.nonNullParameter(vector, "scopes");
        Assert.nonNullParameter(string, "query");
        Vector vector2 = this.createMessages(1, serviceType, string, serviceType, vector);
        Vector vector3 = new Vector();
        int n = vector2.size();
        int n2 = config.getMaximumResults();
        int n3 = 0;
        while (n3 < n) {
            SrvLocMsg srvLocMsg = (SrvLocMsg)vector2.elementAt(n3);
            UARequester.checkForError(srvLocMsg, vector2);
            Vector<ServiceURL> vector4 = null;
            if (srvLocMsg instanceof CSrvMsg) {
                vector4 = ((CSrvMsg)srvLocMsg).serviceURLs;
            } else if (srvLocMsg instanceof CSAAdvert) {
                vector4 = new Vector<ServiceURL>();
                vector4.addElement(((CSAAdvert)srvLocMsg).URL);
            } else if (srvLocMsg instanceof CDAAdvert) {
                vector4 = new Vector();
                vector4.addElement(((CDAAdvert)srvLocMsg).URL);
            }
            UARequester.addUnique(vector4, vector3, n2);
            ++n3;
        }
        return new ServiceLocationEnumerator(vector3);
    }

    public Locale getLocale() {
        return this.locale;
    }
}

