/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.AuthBlock;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceStore;
import com.sun.slp.ServiceTable;
import com.sun.slp.ServiceURL;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class SunServerDATable
extends ServerDATable {
    private static final String TIMESTAMP_ID = "424242SUN-TABLE-TIMESTAMP424242";
    private static final String ADDRESS_ID = "424242SUN-TABLE-ADDRESS424242";
    private ServiceTable serviceTable = null;
    private Vector saOnlyScopes = null;

    SunServerDATable() {
        try {
            this.serviceTable = ServiceTable.getServiceTable();
        }
        catch (ServiceLocationException serviceLocationException) {}
        this.saOnlyScopes = DATable.conf.getSAOnlyScopes();
        Assert.assert(this.saOnlyScopes.size() > 0, "no_sa_scopes", new Object[0]);
    }

    public synchronized Hashtable findDAScopes(Vector vector) throws ServiceLocationException {
        int n = vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("(");
            stringBuffer.append("424242SUN-TABLE-SCOPES424242");
            stringBuffer.append("=");
            stringBuffer.append((String)vector.elementAt(n2));
            stringBuffer.append(")");
            ++n2;
        }
        if (n2 > 1) {
            stringBuffer.insert(0, "(|");
            stringBuffer.append(")");
        }
        if (n2 > 0) {
            stringBuffer.insert(0, "(&");
        }
        stringBuffer.append("(");
        stringBuffer.append("424242SUN-TABLE-VERSION424242");
        stringBuffer.append("=");
        stringBuffer.append(new Integer(2).toString());
        stringBuffer.append(")");
        if (n2 > 0) {
            stringBuffer.append(")");
        }
        ServiceStore serviceStore = this.serviceTable.store;
        Hashtable hashtable = serviceStore.findServices(Defaults.SUN_DA_SERVICE_TYPE.toString(), this.saOnlyScopes, stringBuffer.toString(), Defaults.locale);
        Hashtable hashtable2 = (Hashtable)hashtable.get("FS_SERVICES");
        Enumeration enumeration = hashtable2.keys();
        Vector vector2 = new Vector();
        Vector vector3 = (Vector)vector.clone();
        Vector<String> vector4 = new Vector<String>();
        vector4.addElement("424242SUN-TABLE-SCOPES424242");
        while (enumeration.hasMoreElements()) {
            ServiceURL serviceURL = (ServiceURL)enumeration.nextElement();
            Vector vector5 = (Vector)hashtable2.get(serviceURL);
            Hashtable hashtable3 = serviceStore.findAttributes(serviceURL, vector5, vector4, Defaults.locale);
            Vector vector6 = (Vector)hashtable3.get("FA_ATTRIBUTES");
            String string = serviceURL.getHost();
            Vector vector7 = null;
            n = vector6.size();
            n2 = 0;
            while (n2 < n) {
                ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)vector6.elementAt(n2);
                String string2 = serviceLocationAttribute.getId();
                Vector vector8 = serviceLocationAttribute.getValues();
                if (string2.equals("424242SUN-TABLE-SCOPES424242")) {
                    vector7 = vector8;
                }
                ++n2;
            }
            DATable.addToEquivClass(string, vector7, vector2);
            DATable.filterScopes(vector3, vector7, false);
        }
        hashtable2.clear();
        if (vector3.size() > 0) {
            hashtable2.put("&&**^^MULTICASTxxxKEY^^**&&", vector3);
        }
        if (vector2.size() > 0) {
            hashtable2.put("&&**^^UNICASTxxxKEY^^**&&", vector2);
        }
        return hashtable2;
    }

    private ServiceURL formServiceTableDAURL(ServiceURL serviceURL, Vector vector) {
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            block5: {
                serializable = (ServiceLocationAttribute)vector.elementAt(n2);
                String string = serializable.getId();
                if (string.equals("424242SUN-TABLE-SCOPES424242")) {
                    String string2 = "";
                    try {
                        string2 = serializable.externalize();
                    }
                    catch (ServiceLocationException serviceLocationException) {
                        DATable.conf.writeLog("ssdat_inter_attr_err", new Object[]{serializable, serviceLocationException.getMessage()});
                        break block5;
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(";");
                    }
                    stringBuffer.append(string2.substring(1, string2.length() - 1));
                }
            }
            ++n2;
        }
        serializable = new ServiceURL(String.valueOf(String.valueOf(Defaults.SUN_DA_SERVICE_TYPE)) + "://" + serviceURL.getHost() + "/" + stringBuffer.toString(), serviceURL.getLifetime());
        return serializable;
    }

    public synchronized long recordNewDA(ServiceURL serviceURL, Vector vector, long l, int n, Vector vector2, String string) {
        String string2 = serviceURL.getHost();
        long l2 = -1L;
        Vector vector3 = (Vector)vector.clone();
        ServiceLocationAttribute serviceLocationAttribute = new ServiceLocationAttribute("424242SUN-TABLE-SCOPES424242", vector);
        vector2.addElement(serviceLocationAttribute);
        Vector vector4 = new Vector();
        vector4.addElement(Long.toString(l));
        serviceLocationAttribute = new ServiceLocationAttribute(TIMESTAMP_ID, vector4);
        vector2.addElement(serviceLocationAttribute);
        vector4 = new Vector();
        vector4.addElement(new Integer(n));
        serviceLocationAttribute = new ServiceLocationAttribute("424242SUN-TABLE-VERSION424242", vector4);
        vector2.addElement(serviceLocationAttribute);
        vector4 = new Vector();
        vector4.addElement(serviceURL.getHost());
        serviceLocationAttribute = new ServiceLocationAttribute(ADDRESS_ID, vector4);
        vector2.addElement(serviceLocationAttribute);
        ServiceURL serviceURL2 = this.formServiceTableDAURL(serviceURL, vector2);
        ServiceStore serviceStore = this.serviceTable.store;
        try {
            Object object;
            Vector<String> vector5 = new Vector<String>();
            vector5.addElement(TIMESTAMP_ID);
            Hashtable hashtable = serviceStore.findAttributes(serviceURL2, this.saOnlyScopes, vector5, Defaults.locale);
            Vector vector6 = (Vector)hashtable.get("FA_ATTRIBUTES");
            if (vector6 != null && vector6.size() > 0) {
                serviceLocationAttribute = (ServiceLocationAttribute)vector6.elementAt(0);
                vector4 = serviceLocationAttribute.getValues();
                object = (String)vector4.elementAt(0);
                try {
                    l2 = Long.parseLong(((String)object).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    Assert.assert(false, "ssdat_number_format", new Object[0]);
                }
            }
            serviceStore.register(serviceURL2, vector2, this.saOnlyScopes, Defaults.locale, null, null);
            object = AuthBlock.commaSeparatedListToLinkedList(string);
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {}
            if (string2 != null) {
                this.daSPIsHash.put(inetAddress, object);
            }
        }
        catch (ServiceLocationException serviceLocationException) {
            DATable.conf.writeLog("ssdat_register_error", new Object[]{serviceLocationException.getMessage(), serviceURL2, this.saOnlyScopes});
        }
        return l2;
    }

    public synchronized boolean removeDA(InetAddress inetAddress, Vector vector) {
        String string = "(424242SUN-TABLE-ADDRESS424242=" + inetAddress.getHostAddress() + ")";
        ServiceStore serviceStore = this.serviceTable.store;
        try {
            Hashtable hashtable = this.returnMatchingDAs(string);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ServiceURL serviceURL = (ServiceURL)enumeration.nextElement();
                serviceStore.deregister(serviceURL, this.saOnlyScopes, null);
            }
        }
        catch (ServiceLocationException serviceLocationException) {
            DATable.conf.writeLog("ssdat_deregister_error", new Object[]{serviceLocationException.getMessage(), inetAddress, this.saOnlyScopes});
            return false;
        }
        return true;
    }

    public synchronized Hashtable returnMatchingDAs(String string) throws ServiceLocationException {
        ServiceStore serviceStore = ServiceTable.getServiceTable().store;
        Vector vector = DATable.conf.getSAOnlyScopes();
        Hashtable hashtable = serviceStore.findServices(Defaults.SUN_DA_SERVICE_TYPE.toString(), vector, string, Defaults.locale);
        return (Hashtable)hashtable.get("FS_SERVICES");
    }
}

