/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.RequestHandler;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;

class StreamListener
extends Thread {
    private ServerSocket serverSocket = null;
    private InetAddress interfac = null;
    private static SLPConfig config = null;
    private static Hashtable listeners = new Hashtable();

    private StreamListener(InetAddress inetAddress) throws ServiceLocationException {
        int n = config.getServerSocketQueueLength();
        try {
            this.serverSocket = new ServerSocket(427, n, inetAddress);
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(17, "socket_creation_failure", new Object[]{inetAddress, iOException.getMessage()});
        }
        listeners.put(inetAddress, this);
        this.interfac = inetAddress;
    }

    static void initializeStreamListenerOnInterface(InetAddress inetAddress) throws ServiceLocationException {
        if (listeners.get(inetAddress) != null) {
            return;
        }
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        StreamListener streamListener = new StreamListener(inetAddress);
        streamListener.start();
    }

    public void run() {
        this.setName("SLP Stream Listener");
        long l = 0L;
        while (true) {
            Socket socket;
            block5: {
                socket = null;
                try {
                    socket = this.serverSocket.accept();
                    if (config.traceMsg() && socket != null) {
                        config.writeLog("sl_incoming", new Object[]{socket.getInetAddress().toString(), this.interfac});
                    }
                    if (socket == null) break block5;
                    socket.setSoTimeout(config.getTCPTimeout());
                }
                catch (SocketException socketException) {
                    if (!config.traceMsg()) continue;
                    config.writeLog("sl_sock_timeout", new Object[]{socket.getInetAddress().toString(), this.interfac, socketException.getMessage()});
                    continue;
                }
                catch (IOException iOException) {
                    long l2 = System.currentTimeMillis();
                    Assert.assert(l2 - l >= 250L, "sls_repeat_failure", new Object[0]);
                    l = l2;
                    continue;
                }
            }
            RequestHandler requestHandler = new RequestHandler(socket, this.interfac, config);
            requestHandler.start();
        }
    }
}

