/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.AuthBlock;
import com.sun.slp.CSrvReg;
import com.sun.slp.Defaults;
import com.sun.slp.PermSARegTable;
import com.sun.slp.SARequester;
import com.sun.slp.SAttrMsg;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.SSAAdvert;
import com.sun.slp.SSrvDereg;
import com.sun.slp.SSrvMsg;
import com.sun.slp.SSrvReg;
import com.sun.slp.SSrvTypeMsg;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceStore;
import com.sun.slp.ServiceStoreFactory;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

class ServiceTable {
    static final String SDAADVERT = "com.sun.slp.SDAAdvert";
    private static final String locationMsg = "Service table";
    protected ServiceStore store = null;
    protected static SLPConfig conf = null;
    protected static ServiceTable table = null;
    protected static AgerThread thrAger = null;
    private static long sleepyTime = 64800000L;

    protected ServiceTable() {
        if (thrAger != null) {
            return;
        }
        thrAger = new AgerThread();
        thrAger.setPriority(1);
        thrAger.start();
    }

    void ageStore() {
        try {
            ServiceStore serviceStore = this.store;
            synchronized (serviceStore) {
                Vector vector = new Vector();
                sleepyTime = this.store.ageOut(vector);
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    ServiceStore.ServiceRecord serviceRecord = (ServiceStore.ServiceRecord)vector.elementAt(n2);
                    ServiceURL serviceURL = serviceRecord.getServiceURL();
                    this.trackRegisteredServiceTypes();
                    ++n2;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            ServiceTable.reportNonfatalException(runtimeException, new Vector(), this.store);
        }
        catch (ServiceLocationException serviceLocationException) {
            ServiceTable.reportNonfatalException(serviceLocationException, new Vector(), this.store);
        }
    }

    private final boolean areSupportedScopes(Vector vector) {
        Vector vector2 = conf.getSAConfiguredScopes();
        Vector vector3 = conf.getSAOnlyScopes();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (!vector2.contains(e) && !vector3.contains(e)) {
                vector.removeElementAt(n);
                continue;
            }
            ++n;
        }
        return vector.size() > 0;
    }

    private void checkForRestrictedType(ServiceType serviceType) throws ServiceLocationException {
        if (Defaults.restrictedTypes.contains(serviceType)) {
            throw new ServiceLocationException(3, "st_restricted_type", new Object[]{serviceType});
        }
    }

    private static ServiceTable createServiceTable() throws ServiceLocationException {
        ServiceTable serviceTable = new ServiceTable();
        serviceTable.store = ServiceStoreFactory.createServiceStore();
        return serviceTable;
    }

    SrvLocMsg deregister(SSrvDereg sSrvDereg) {
        SrvLocHeader srvLocHeader = sSrvDereg.getHeader();
        Locale locale = srvLocHeader.locale;
        Vector vector = srvLocHeader.scopes;
        ServiceURL serviceURL = sSrvDereg.URL;
        Hashtable hashtable = sSrvDereg.URLSignature;
        Vector vector2 = sSrvDereg.tags;
        boolean bl = false;
        try {
            if (hashtable != null) {
                AuthBlock.verifyAll(hashtable);
            }
            this.checkForRestrictedType(serviceURL.getServiceType());
            if (hashtable != null && vector2 != null) {
                throw new ServiceLocationException(7, "st_prot_attr_dereg", new Object[0]);
            }
            if (conf.getHasSecurity() && hashtable == null) {
                throw new ServiceLocationException(7, "st_unprot_non_dereg", new Object[0]);
            }
            if (!conf.getHasSecurity() && hashtable != null) {
                throw new ServiceLocationException(3, "st_prot_non_dereg", new Object[0]);
            }
            if (vector2 == null) {
                this.store.deregister(serviceURL, vector, hashtable);
                this.trackRegisteredServiceTypes();
            } else {
                this.store.deleteAttributes(serviceURL, vector, vector2, locale);
            }
            SrvLocMsg srvLocMsg = sSrvDereg.makeReply();
            if (conf.regTest()) {
                conf.writeLog(vector2 == null ? "st_dereg" : "st_delattr", new Object[]{locationMsg, locale, serviceURL.getServiceType(), serviceURL, vector2});
            }
            if (conf.traceAll()) {
                conf.writeLog("st_dump", new Object[]{locationMsg});
                this.store.dumpServiceStore();
            }
            return srvLocMsg;
        }
        catch (ServiceLocationException serviceLocationException) {
            if (conf.traceDrop()) {
                conf.writeLog(vector2 == null ? "st_dereg_drop" : "st_dereg_attr_drop", new Object[]{locationMsg, String.valueOf(serviceLocationException.getMessage()) + "(" + serviceLocationException.getErrorCode() + ")", locale, serviceURL.getServiceType(), serviceURL, vector2});
            }
            return srvLocHeader.makeErrorReply(serviceLocationException);
        }
        catch (RuntimeException runtimeException) {
            Vector<SSrvDereg> vector3 = new Vector<SSrvDereg>();
            vector3.addElement(sSrvDereg);
            ServiceTable.reportNonfatalException(runtimeException, vector3, this.store);
            return srvLocHeader.makeErrorReply(runtimeException);
        }
    }

    public void deserializeTable() {
        ServiceStore serviceStore;
        String string = conf.getSerializedRegURL();
        if (string != null && (serviceStore = this.getStoreFromURL(string)) != null) {
            this.registerStore(serviceStore);
        }
    }

    SrvLocMsg findAttributes(SAttrMsg sAttrMsg) {
        SrvLocHeader srvLocHeader = sAttrMsg.getHeader();
        Vector vector = srvLocHeader.scopes;
        Locale locale = srvLocHeader.locale;
        ServiceURL serviceURL = sAttrMsg.URL;
        String string = sAttrMsg.serviceType;
        Vector vector2 = sAttrMsg.tags;
        boolean bl = false;
        try {
            Object object;
            Serializable serializable;
            if (!this.areSupportedScopes(vector)) {
                throw new ServiceLocationException(4, "st_scope_unsup", new Object[0]);
            }
            Vector vector3 = null;
            Hashtable hashtable = null;
            if (string == null) {
                if (!sAttrMsg.spi.equals("") && vector2.size() > 0) {
                    throw new ServiceLocationException(7, "st_par_attr", new Object[0]);
                }
                serializable = this.store.findAttributes(serviceURL, vector, vector2, locale);
                vector3 = (Vector)serializable.get("FA_ATTRIBUTES");
                hashtable = (Hashtable)serializable.get("FA_SIG");
                if (hashtable != null && !sAttrMsg.spi.equals("") && (object = AuthBlock.getEquivalentAuth(sAttrMsg.spi, hashtable)) == null) {
                    vector3 = new Vector();
                }
            } else {
                if (!sAttrMsg.spi.equals("")) {
                    throw new ServiceLocationException(7, "st_par_attr", new Object[0]);
                }
                vector3 = this.store.findAttributes(string, vector, vector2, locale);
            }
            serializable = string == null ? serviceURL.getServiceType() : new ServiceType(string);
            object = sAttrMsg.makeReply(vector3, hashtable);
            if (conf.traceAll()) {
                conf.writeLog(string != null ? "st_st_attr" : "st_url_attr", new Object[]{locationMsg, string != null ? string.toString() : serviceURL.toString(), vector, vector2, locale, vector3});
            }
            return object;
        }
        catch (ServiceLocationException serviceLocationException) {
            if (conf.traceDrop()) {
                conf.writeLog(string != null ? "st_st_attr_drop" : "st_url_attr_drop", new Object[]{locationMsg, String.valueOf(serviceLocationException.getMessage()) + "(" + serviceLocationException.getErrorCode() + ")", string != null ? string.toString() : serviceURL.toString(), vector, vector2, locale});
            }
            return srvLocHeader.makeErrorReply(serviceLocationException);
        }
        catch (RuntimeException runtimeException) {
            Vector<SAttrMsg> vector4 = new Vector<SAttrMsg>();
            vector4.addElement(sAttrMsg);
            ServiceTable.reportNonfatalException(runtimeException, vector4, this.store);
            return srvLocHeader.makeErrorReply(runtimeException);
        }
    }

    SrvLocMsg findServiceTypes(SSrvTypeMsg sSrvTypeMsg) {
        SrvLocHeader srvLocHeader = sSrvTypeMsg.getHeader();
        Vector vector = srvLocHeader.scopes;
        String string = sSrvTypeMsg.namingAuthority;
        boolean bl = false;
        try {
            if (!this.areSupportedScopes(vector)) {
                throw new ServiceLocationException(4, "st_scope_unsup", new Object[0]);
            }
            Vector vector2 = this.store.findServiceTypes(string, vector);
            SrvLocMsg srvLocMsg = sSrvTypeMsg.makeReply(vector2);
            if (conf.traceAll()) {
                conf.writeLog("st_stypes", new Object[]{locationMsg, string, vector, vector2});
            }
            return srvLocMsg;
        }
        catch (ServiceLocationException serviceLocationException) {
            if (conf.traceDrop()) {
                conf.writeLog("st_stypes_drop", new Object[]{locationMsg, String.valueOf(serviceLocationException.getMessage()) + "(" + serviceLocationException.getErrorCode() + ")", string, vector, srvLocHeader.locale});
            }
            return srvLocHeader.makeErrorReply(serviceLocationException);
        }
        catch (RuntimeException runtimeException) {
            Vector<SSrvTypeMsg> vector3 = new Vector<SSrvTypeMsg>();
            vector3.addElement(sSrvTypeMsg);
            ServiceTable.reportNonfatalException(runtimeException, vector3, this.store);
            return srvLocHeader.makeErrorReply(runtimeException);
        }
    }

    SrvLocMsg findServices(SSrvMsg sSrvMsg) {
        SrvLocHeader srvLocHeader = sSrvMsg.getHeader();
        Locale locale = srvLocHeader.locale;
        Vector vector = srvLocHeader.scopes;
        String string = sSrvMsg.serviceType;
        String string2 = sSrvMsg.query;
        boolean bl = false;
        try {
            Object object;
            boolean bl2;
            if (!this.areSupportedScopes(vector)) {
                throw new ServiceLocationException(4, "st_scope_unsup", new Object[0]);
            }
            Hashtable hashtable = this.store.findServices(string, vector, string2, locale);
            Hashtable hashtable2 = (Hashtable)hashtable.get("FS_SERVICES");
            Hashtable hashtable3 = (Hashtable)hashtable.get("FS_SIGTABLE");
            boolean bl3 = bl2 = hashtable3 != null;
            if (bl2 && !sSrvMsg.spi.equals("")) {
                object = hashtable2.keys();
                while (object.hasMoreElements()) {
                    Object e = object.nextElement();
                    Hashtable hashtable4 = (Hashtable)hashtable3.get(e);
                    AuthBlock authBlock = AuthBlock.getEquivalentAuth(sSrvMsg.spi, hashtable4);
                    if (authBlock != null) continue;
                    hashtable2.remove(e);
                }
            }
            object = sSrvMsg.makeReply(hashtable2, hashtable3);
            if (conf.traceAll()) {
                conf.writeLog("st_sreq", new Object[]{locationMsg, string, vector, string2, locale, hashtable2, hashtable3});
            }
            return object;
        }
        catch (ServiceLocationException serviceLocationException) {
            if (conf.traceDrop()) {
                conf.writeLog("st_sreq_drop", new Object[]{locationMsg, String.valueOf(serviceLocationException.getMessage()) + "(" + serviceLocationException.getErrorCode() + ")", string, vector, string2, locale});
            }
            return srvLocHeader.makeErrorReply(serviceLocationException);
        }
        catch (RuntimeException runtimeException) {
            Vector<SSrvMsg> vector2 = new Vector<SSrvMsg>();
            vector2.addElement(sSrvMsg);
            ServiceTable.reportNonfatalException(runtimeException, vector2, this.store);
            return srvLocHeader.makeErrorReply(runtimeException);
        }
    }

    ServiceStore.ServiceRecord getServiceRecord(ServiceURL serviceURL, Locale locale) {
        return this.store.getServiceRecord(serviceURL, locale);
    }

    static ServiceTable getServiceTable() throws ServiceLocationException {
        if (conf == null) {
            conf = SLPConfig.getSLPConfig();
        }
        if (table == null) {
            table = ServiceTable.createServiceTable();
        }
        return table;
    }

    private long getSleepIncrement(ServiceURL serviceURL) {
        long l;
        long l2 = serviceURL.getLifetime() * 1000;
        long l3 = l2 - (l = (long)((float)l2 * 0.1f));
        if (l3 <= 0L) {
            l3 = 500L;
        }
        return l3;
    }

    private ServiceStore getStoreFromURL(String string) {
        ServiceStore serviceStore = null;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            serviceStore = ServiceStoreFactory.deserializeServiceStore(bufferedReader);
        }
        catch (MalformedURLException malformedURLException) {
            conf.writeLog("st_serialized_malform", new Object[]{string});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            conf.writeLog("st_unsupported_encoding", new Object[]{string});
        }
        catch (IOException iOException) {
            conf.writeLog("st_serialized_ioexception", new Object[]{string, iOException.getMessage()});
        }
        catch (ServiceLocationException serviceLocationException) {
            conf.writeLog("st_serialized_sle", new Object[]{string, serviceLocationException.getMessage()});
        }
        return serviceStore;
    }

    SrvLocMsg makeDAAdvert(SSrvMsg sSrvMsg, InetAddress inetAddress, SLPConfig sLPConfig) {
        SrvLocHeader srvLocHeader = sSrvMsg.getHeader();
        Vector vector = srvLocHeader.scopes;
        short s = srvLocHeader.xid;
        String string = sSrvMsg.query;
        try {
            if (sLPConfig.getHasSecurity() && !AuthBlock.canSignAs(sSrvMsg.spi)) {
                throw new ServiceLocationException(5, "st_cant_sign_as", new Object[]{sSrvMsg.spi});
            }
            Hashtable hashtable = ServerDATable.getServerDATable().returnMatchingDAs(string);
            Enumeration enumeration = hashtable.keys();
            boolean bl = false;
            String string2 = inetAddress.getHostAddress();
            while (enumeration.hasMoreElements()) {
                ServiceURL serviceURL = (ServiceURL)enumeration.nextElement();
                if (!serviceURL.getHost().equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return sSrvMsg.makeReply(new Hashtable(), new Hashtable());
            }
            return this.makeDAAdvert(srvLocHeader, inetAddress, s, vector, sLPConfig);
        }
        catch (ServiceLocationException serviceLocationException) {
            return srvLocHeader.makeErrorReply(serviceLocationException);
        }
    }

    SrvLocMsg makeDAAdvert(SrvLocHeader srvLocHeader, InetAddress inetAddress, short s, Vector vector, SLPConfig sLPConfig) throws ServiceLocationException {
        if (srvLocHeader.version == 1) {
            vector = new Vector();
        }
        if (vector.size() > 0 && !this.areSupportedScopes(vector)) {
            throw new ServiceLocationException(4, "st_scope_unsup", new Object[0]);
        }
        long l = this.store.getStateTimestamp();
        ServiceURL serviceURL = new ServiceURL(String.valueOf(String.valueOf(Defaults.DA_SERVICE_TYPE)) + "://" + inetAddress.getHostAddress(), 10800);
        SDAAdvert sDAAdvert = srvLocHeader.getDAAdvert(s, l, serviceURL, vector, conf.getDAAttributes());
        return sDAAdvert;
    }

    SSAAdvert makeSAAdvert(SSrvMsg sSrvMsg, InetAddress inetAddress, SLPConfig sLPConfig) throws ServiceLocationException {
        Hashtable hashtable;
        Hashtable hashtable2;
        Enumeration enumeration;
        SrvLocHeader srvLocHeader = sSrvMsg.getHeader();
        int n = srvLocHeader.version;
        short s = srvLocHeader.xid;
        Locale locale = srvLocHeader.locale;
        Vector vector = srvLocHeader.scopes;
        String string = sSrvMsg.query;
        String string2 = sSrvMsg.serviceType;
        Vector vector2 = sLPConfig.getSAOnlyScopes();
        if (sLPConfig.getHasSecurity() && !AuthBlock.canSignAs(sSrvMsg.spi)) {
            throw new ServiceLocationException(5, "st_cant_sign_as", new Object[]{sSrvMsg.spi});
        }
        if (!this.areSupportedScopes(vector) && vector.size() > 0) {
            return null;
        }
        if (vector.size() <= 0) {
            vector = (Vector)sLPConfig.getSAConfiguredScopes().clone();
        }
        if (!(enumeration = (hashtable2 = (Hashtable)(hashtable = this.store.findServices(Defaults.SUN_SA_SERVICE_TYPE.toString(), vector2, string, Defaults.locale)).get("FS_SERVICES")).keys()).hasMoreElements()) {
            return null;
        }
        ServiceURL serviceURL = null;
        ServiceURL serviceURL2 = null;
        String string3 = inetAddress.getHostAddress();
        while (enumeration.hasMoreElements()) {
            serviceURL2 = (ServiceURL)enumeration.nextElement();
            if (!string3.equals(serviceURL2.getHost())) continue;
            serviceURL = new ServiceURL(String.valueOf(String.valueOf(Defaults.SA_SERVICE_TYPE)) + "://" + string3, 10800);
            break;
        }
        if (serviceURL == null) {
            return null;
        }
        Hashtable hashtable3 = this.store.findAttributes(serviceURL2, vector2, new Vector(), Defaults.locale);
        Vector vector3 = (Vector)hashtable3.get("FA_ATTRIBUTES");
        return new SSAAdvert(n, s, locale, serviceURL, sLPConfig.getSAConfiguredScopes(), vector3);
    }

    SrvLocMsg register(SSrvReg sSrvReg) {
        SrvLocHeader srvLocHeader = sSrvReg.getHeader();
        Locale locale = srvLocHeader.locale;
        boolean bl = srvLocHeader.fresh;
        Vector vector = srvLocHeader.scopes;
        ServiceURL serviceURL = sSrvReg.URL;
        String string = sSrvReg.serviceType;
        Vector vector2 = sSrvReg.attrList;
        Hashtable hashtable = sSrvReg.URLSignature;
        Hashtable hashtable2 = sSrvReg.attrSignature;
        short s = bl ? (short)3 : 13;
        try {
            if (hashtable != null) {
                AuthBlock.verifyAll(hashtable);
            }
            if (hashtable2 != null) {
                AuthBlock.verifyAll(hashtable2);
            }
            if (serviceURL.getLifetime() <= 0) {
                throw new ServiceLocationException(s, "st_zero", new Object[0]);
            }
            this.checkForRestrictedType(serviceURL.getServiceType());
            if (hashtable2 != null && hashtable == null) {
                throw new ServiceLocationException(s, "st_attr_sig", new Object[0]);
            }
            if (hashtable != null && !bl) {
                throw new ServiceLocationException(13, "st_prot_update", new Object[0]);
            }
            if (!this.areSupportedScopes(vector)) {
                throw new ServiceLocationException(4, "st_scope_unsup", new Object[0]);
            }
            if (conf.getHasSecurity() && (hashtable == null || hashtable2 == null)) {
                throw new ServiceLocationException(7, "st_unprot_non_reg", new Object[0]);
            }
            if (!(conf.getHasSecurity() || hashtable == null && hashtable2 == null)) {
                throw new ServiceLocationException(3, "st_prot_non_reg", new Object[0]);
            }
            Vector vector3 = new Vector();
            Hashtable hashtable3 = new Hashtable();
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)vector2.elementAt(n2);
                ServiceLocationAttribute.mergeDuplicateAttributes(serviceLocationAttribute, hashtable3, vector3, false);
                ++n2;
            }
            boolean bl2 = false;
            if (bl) {
                bl2 = this.store.register(serviceURL, vector3, vector, locale, hashtable, hashtable2);
                this.trackRegisteredServiceTypes();
            } else {
                this.store.updateRegistration(serviceURL, vector3, vector, locale);
            }
            SrvLocMsg srvLocMsg = sSrvReg.makeReply(bl2);
            if (conf.regTest()) {
                conf.writeLog(bl ? "st_reg_add" : "st_reg_update", new Object[]{locationMsg, locale, string, serviceURL, vector3, vector});
            }
            if (conf.traceAll()) {
                conf.writeLog("st_dump", new Object[]{locationMsg});
                this.store.dumpServiceStore();
            }
            long l = this.getSleepIncrement(serviceURL);
            ServiceStore serviceStore = this.store;
            synchronized (serviceStore) {
                if (l < sleepyTime) {
                    sleepyTime = l;
                    thrAger.interrupt();
                }
            }
            return srvLocMsg;
        }
        catch (ServiceLocationException serviceLocationException) {
            if (conf.traceDrop()) {
                conf.writeLog("st_reg_drop", new Object[]{locationMsg, String.valueOf(serviceLocationException.getMessage()) + "(" + serviceLocationException.getErrorCode() + ")", locale, string, serviceURL, vector2, vector});
            }
            return srvLocHeader.makeErrorReply(serviceLocationException);
        }
        catch (RuntimeException runtimeException) {
            Vector<SSrvReg> vector4 = new Vector<SSrvReg>();
            vector4.addElement(sSrvReg);
            ServiceTable.reportNonfatalException(runtimeException, vector4, this.store);
            return srvLocHeader.makeErrorReply(runtimeException);
        }
    }

    private void registerStore(ServiceStore serviceStore) {
        Enumeration enumeration = serviceStore.getServiceRecordsByScope(null);
        boolean bl = conf.getHasSecurity();
        boolean bl2 = conf.getHasSecurity();
        PermSARegTable permSARegTable = SARequester.getPermSARegTable();
        while (enumeration.hasMoreElements()) {
            Object object;
            ServiceStore.ServiceRecord serviceRecord = (ServiceStore.ServiceRecord)enumeration.nextElement();
            ServiceURL serviceURL = serviceRecord.getServiceURL();
            Vector vector = serviceRecord.getScopes();
            Vector vector2 = serviceRecord.getAttrList();
            Locale locale = serviceRecord.getLocale();
            Hashtable hashtable = null;
            Hashtable hashtable2 = null;
            try {
                CSrvReg cSrvReg = new CSrvReg(false, locale, serviceURL, vector, vector2, null, null);
                if (bl || bl2) {
                    object = new ByteArrayOutputStream();
                    cSrvReg.getHeader().externalize((ByteArrayOutputStream)object, false, true);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                    byteArrayInputStream.read();
                    byteArrayInputStream.read();
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    SLPHeaderV2 sLPHeaderV2 = new SLPHeaderV2();
                    sLPHeaderV2.parseHeader(3, dataInputStream);
                    SSrvReg sSrvReg = new SSrvReg((SrvLocHeader)sLPHeaderV2, dataInputStream);
                    hashtable = sSrvReg.URLSignature;
                    hashtable2 = sSrvReg.attrSignature;
                }
                this.store.register(serviceURL, vector2, vector, locale, hashtable, hashtable2);
                if (serviceURL.getIsPermanent()) {
                    permSARegTable.reg(serviceURL, cSrvReg);
                }
                if (!conf.regTest()) continue;
                conf.writeLog("st_reg_add", new Object[]{locationMsg, locale, serviceURL.getServiceType(), serviceURL, vector2, vector});
            }
            catch (ServiceLocationException serviceLocationException) {
                object = serviceLocationException.getMessage();
                conf.writeLog("st_serialized_seex", new Object[]{new Integer(serviceLocationException.getErrorCode()), serviceURL, object == null ? "<no message>" : object});
            }
            catch (Exception exception) {
                object = exception.getMessage();
                conf.writeLog("st_serialized_seex", new Object[]{serviceURL, object == null ? "<no message>" : object});
            }
        }
    }

    private static void reportException(boolean bl, Exception exception, Vector vector) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        String string = bl ? "fatal_error" : "nonfatal_error";
        String string2 = exception.getMessage();
        if (string2 == null) {
            string2 = conf.formatMessage("no_message", new Object[0]);
        } else if (exception instanceof ServiceLocationException) {
            string2 = String.valueOf(string2) + "(" + ((ServiceLocationException)exception).getErrorCode() + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\n        (" + Integer.toString(n2) + "):" + vector.elementAt(n2).toString());
            ++n2;
        }
        conf.writeLog(string, new Object[]{exception.getClass().getName(), string2, stringBuffer, stringWriter.toString()});
    }

    protected static void reportFatalException(Exception exception) {
        ServiceTable.reportException(true, exception, new Vector());
        if (table != null) {
            ServiceTable.table.store.dumpServiceStore();
        }
        conf.writeLog("exiting_msg", new Object[0]);
        System.exit(1);
    }

    protected static void reportNonfatalException(Exception exception, Vector vector, ServiceStore serviceStore) {
        ServiceTable.reportException(false, exception, vector);
        if (conf.traceAll()) {
            serviceStore.dumpServiceStore();
        }
    }

    void serializeServiceStore(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            OutputStream outputStream = uRLConnection.getOutputStream();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            ServiceStoreFactory.serialize(bufferedWriter, this.store);
        }
        catch (MalformedURLException malformedURLException) {
            conf.writeLog("st_serialized_malform", new Object[]{string});
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            conf.writeLog("st_unsupported_encoding", new Object[]{string});
        }
        catch (IOException iOException) {
            conf.writeLog("st_serialized_ioexception", new Object[]{string, iOException});
        }
        catch (ServiceLocationException serviceLocationException) {
            conf.writeLog("st_serialized_sle", new Object[]{string, serviceLocationException.getMessage()});
        }
    }

    private void trackRegisteredServiceTypes() throws ServiceLocationException {
        Vector vector = this.store.findServiceTypes("*", conf.getSAConfiguredScopes());
        Vector vector2 = conf.getSAAttributes();
        ServiceLocationAttribute serviceLocationAttribute = new ServiceLocationAttribute("service-type", vector);
        vector2.addElement(serviceLocationAttribute);
        Vector vector3 = conf.getInterfaces();
        int n = vector3.size();
        int n2 = 0;
        while (n2 < n) {
            InetAddress inetAddress = (InetAddress)vector3.elementAt(n2);
            ServiceURL serviceURL = new ServiceURL(String.valueOf(String.valueOf(Defaults.SUN_SA_SERVICE_TYPE)) + "://" + inetAddress.getHostAddress(), 65535);
            Vector vector4 = conf.getSAOnlyScopes();
            Locale locale = Defaults.locale;
            this.store.register(serviceURL, vector2, vector4, locale, null, null);
            ++n2;
        }
    }

    private class AgerThread
    extends Thread {
        AgerThread() {
        }

        public void run() {
            this.setName("SLP Service Table Age-out");
            long l = sleepyTime;
            long l2 = 0L;
            while (true) {
                try {
                    l2 = System.currentTimeMillis();
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    long l3 = l2 + l - System.currentTimeMillis();
                    if ((l3 = l3 <= 0L ? 0L : l3) >= (l = sleepyTime)) continue;
                    l = l3;
                    continue;
                }
                if (table == null) continue;
                table.ageStore();
                l = sleepyTime;
            }
        }
    }
}

