/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.AttributePattern;
import com.sun.slp.AttributeString;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.Opaque;
import com.sun.slp.Parser;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServerAttribute;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceStore;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

class ServiceStoreInMemory
implements ServiceStore {
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String ATTRIBUTE_STRING_TYPE = "com.sun.slp.AttributeString";
    private static final String BOOLEAN_TYPE = "java.lang.Boolean";
    private static final String OPAQUE_TYPE = "com.sun.slp.Opaque";
    private Hashtable scopeTypeLangTable = new Hashtable();
    private Hashtable urlScopeLangTable = new Hashtable();
    private Hashtable sstLocales = new Hashtable();
    BtreeVector ageOutQueue = new BtreeVector();
    private static final int NO_REGS = 0;
    private static final int NO_REGS_IN_LOCALE = 1;
    private static final int REGS_IN_LOCALE = 2;
    private long bootTime = SLPConfig.currentSLPTime();

    ServiceStoreInMemory() {
    }

    private void addRecordToAttrSort(BtreeVector btreeVector, ServiceRecordInMemory serviceRecordInMemory, Vector vector) {
        Vector vector2 = serviceRecordInMemory.getAttrList();
        int n = vector2.size();
        if (n <= 0) {
            List list = btreeVector.add(new AttributeString("", serviceRecordInMemory.getLocale()), serviceRecordInMemory);
            vector.addElement(list);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ServerAttribute serverAttribute = (ServerAttribute)vector2.elementAt(n2);
            List list = btreeVector.add(serverAttribute.idPattern, serviceRecordInMemory);
            vector.addElement(list);
            ++n2;
        }
    }

    private void addRecordToAttrValueSort(Hashtable hashtable, ServiceRecordInMemory serviceRecordInMemory, Vector vector) {
        Vector vector2 = serviceRecordInMemory.getAttrList();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            ServerAttribute serverAttribute = (ServerAttribute)vector2.elementAt(n2);
            AttributeString attributeString = serverAttribute.idPattern;
            Vector vector3 = serverAttribute.values;
            Hashtable hashtable2 = (Hashtable)hashtable.get(attributeString);
            if (hashtable2 == null) {
                hashtable2 = this.makeAttrTypeTable();
                hashtable.put(attributeString, hashtable2);
            }
            String string = null;
            if (vector3 != null) {
                Object object = vector3.elementAt(0);
                string = object.getClass().getName();
                object = (BtreeVector)hashtable2.get(string);
                int n3 = vector3.size();
                int n4 = 0;
                while (n4 < n3) {
                    List list = ((BtreeVector)object).add(vector3.elementAt(n4), serviceRecordInMemory);
                    vector.addElement(list);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void addRecordToScopeTypeLangTable(String string, String string2, String string3, boolean bl, ServiceRecordInMemory serviceRecordInMemory, Vector vector) {
        String string4 = this.makeScopeTypeLangKey(string, string2, string3);
        STLRecord sTLRecord = (STLRecord)this.scopeTypeLangTable.get(string4);
        if (sTLRecord == null) {
            sTLRecord = new STLRecord(bl);
            this.scopeTypeLangTable.put(string4, sTLRecord);
        }
        this.addRecordToAttrValueSort(sTLRecord.attrValueSort, serviceRecordInMemory, vector);
        this.addRecordToAttrSort(sTLRecord.attrSort, serviceRecordInMemory, vector);
    }

    private List addToAgeOutQueue(ServiceRecordInMemory serviceRecordInMemory) {
        Long l = new Long(serviceRecordInMemory.getExpirationTime());
        return this.ageOutQueue.add(l, serviceRecordInMemory);
    }

    private void addTypeLocale(String string, String string2, String string3) {
        Integer n;
        String string4 = this.makeScopeTypeKey(string2, string);
        Hashtable<String, Integer> hashtable = (Hashtable<String, Integer>)this.sstLocales.get(string4);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Integer>();
            this.sstLocales.put(string4, hashtable);
        }
        n = (n = (Integer)hashtable.get(string3)) == null ? new Integer(1) : new Integer(n + 1);
        hashtable.put(string3, n);
    }

    public synchronized long ageOut(Vector vector) {
        SLPConfig sLPConfig = SLPConfig.getSLPConfig();
        boolean bl = sLPConfig.traceDrop();
        Vector vector2 = this.ageOutQueue.getContents();
        int n = 0;
        while (n < vector2.size()) {
            long l;
            RegRecord regRecord = (RegRecord)vector2.elementAt(n);
            long l2 = (Long)regRecord.value;
            if (l2 > (l = System.currentTimeMillis())) break;
            vector2.removeElementAt(n);
            List list = regRecord.head.next;
            while (list != null) {
                ServiceRecordInMemory serviceRecordInMemory = list.record;
                ServiceURL serviceURL = serviceRecordInMemory.getServiceURL();
                Vector vector3 = serviceRecordInMemory.getScopes();
                Locale locale = serviceRecordInMemory.getLocale();
                if (bl) {
                    sLPConfig.writeLog("ssim_ageout", new Object[]{serviceURL, serviceRecordInMemory.getAttrList(), vector3, locale, serviceRecordInMemory.getURLSignature(), serviceRecordInMemory.getAttrSignature(), Long.toString(l), Long.toString(l2)});
                }
                vector.addElement(serviceRecordInMemory);
                list = list.next;
                String string = locale.getLanguage();
                this.deregisterInternal(serviceURL, vector3, string);
            }
            ++n;
        }
        long l = 64800000L;
        if (vector2.size() > 0) {
            RegRecord regRecord = (RegRecord)vector2.elementAt(0);
            l = (Long)regRecord.value - System.currentTimeMillis();
            l = l > 0L ? l : 0L;
        }
        return l;
    }

    private void checkForExistingUnderOtherServiceType(ServiceURL serviceURL, Vector vector) throws ServiceLocationException {
        Hashtable hashtable = (Hashtable)this.urlScopeLangTable.get(serviceURL.toString());
        if (hashtable == null) {
            return;
        }
        Object e = vector.elementAt(0);
        Hashtable hashtable2 = (Hashtable)hashtable.get(e);
        Assert.assert(hashtable2 != null, "ssim_null_lang_table", new Object[]{e});
        Enumeration enumeration = hashtable2.elements();
        Assert.assert(enumeration.hasMoreElements(), "ssim_empty_lang_table", new Object[]{e});
        Vector vector2 = (Vector)enumeration.nextElement();
        Assert.assert(vector2.size() > 0, "ssim_empty_reg_vector", new Object[]{e});
        List list = (List)vector2.elementAt(0);
        ServiceURL serviceURL2 = list.record.getServiceURL();
        ServiceType serviceType = serviceURL2.getServiceType();
        if (!serviceType.equals(serviceURL.getServiceType())) {
            throw new ServiceLocationException(13, "ssim_st_already", new Object[0]);
        }
    }

    private void checkScopeStatus(ServiceURL serviceURL, Vector vector, short s) throws ServiceLocationException {
        Hashtable hashtable = (Hashtable)this.urlScopeLangTable.get(serviceURL.toString());
        if (hashtable == null) {
            return;
        }
        int n = vector.size();
        boolean bl = true;
        if (n != hashtable.size()) {
            bl = false;
        } else {
            int n2 = 0;
            while (n2 < n) {
                if (hashtable.get(vector.elementAt(n2)) == null) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        if (!bl) {
            throw new ServiceLocationException(s, "ssim_scope_mis", new Object[0]);
        }
    }

    private void deleteAttributes(ServiceRecordInMemory serviceRecordInMemory, Vector vector) throws ServiceLocationException {
        Vector vector2 = serviceRecordInMemory.getAttrList();
        if (vector2.size() <= 0) {
            return;
        }
        int n = vector2.size();
        Vector<ServerAttribute> vector3 = new Vector<ServerAttribute>();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n) {
            ServerAttribute serverAttribute = (ServerAttribute)vector2.elementAt(n3);
            AttributeString attributeString = serverAttribute.idPattern;
            boolean bl = false;
            int n4 = 0;
            while (n4 < n2) {
                AttributePattern attributePattern = (AttributePattern)vector.elementAt(n4);
                if (attributePattern.match(attributeString)) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                vector3.addElement(serverAttribute);
            }
            ++n3;
        }
        serviceRecordInMemory.setAttrList(vector3);
    }

    public synchronized void deleteAttributes(ServiceURL serviceURL, Vector vector, Vector vector2, Locale locale) throws ServiceLocationException {
        String string = SLPConfig.localeToLangTag(locale);
        Hashtable hashtable = (Hashtable)this.urlScopeLangTable.get(serviceURL.toString());
        if (hashtable == null) {
            throw new ServiceLocationException(3, "ssim_no_rec", new Object[]{serviceURL});
        }
        this.checkScopeStatus(serviceURL, vector, (short)3);
        Vector vector3 = this.stringVectorToAttributePattern(vector2, Defaults.locale);
        Enumeration enumeration = hashtable.keys();
        Assert.assert(enumeration.hasMoreElements(), "ssim_empty_scope_table", new Object[]{serviceURL});
        Hashtable<ServiceRecordInMemory, ServiceRecordInMemory> hashtable2 = new Hashtable<ServiceRecordInMemory, ServiceRecordInMemory>();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable3 = (Hashtable)hashtable.get(string2);
            Enumeration enumeration2 = hashtable3.keys();
            Assert.assert(enumeration2.hasMoreElements(), "ssim_empty_lang_table", new Object[]{serviceURL});
            Vector vector4 = (Vector)hashtable3.get(string);
            if (vector4 == null) continue;
            bl = true;
            List list = (List)vector4.elementAt(0);
            ServiceRecordInMemory serviceRecordInMemory = list.record;
            Locale locale2 = serviceRecordInMemory.getLocale();
            if (hashtable2.get(serviceRecordInMemory) != null) continue;
            hashtable2.put(serviceRecordInMemory, serviceRecordInMemory);
            this.deregisterInternal(serviceURL, serviceRecordInMemory.getScopes(), string);
            if (locale2.getLanguage().equals("tr")) {
                Vector vector5 = this.stringVectorToAttributePattern(vector2, locale2);
                this.deleteAttributes(serviceRecordInMemory, vector5);
            } else {
                this.deleteAttributes(serviceRecordInMemory, vector3);
            }
            this.registerInternal(serviceRecordInMemory);
        }
        if (!bl) {
            throw new ServiceLocationException(3, "ssim_no_rec_locale", new Object[]{serviceURL, locale});
        }
    }

    private void deleteTypeLocale(String string, String string2, String string3) {
        String string4 = this.makeScopeTypeKey(string2, string);
        Hashtable hashtable = (Hashtable)this.sstLocales.get(string4);
        Assert.assert(hashtable != null, "ssim_ssttable_botch", new Object[]{string, string2});
        Integer n = (Integer)hashtable.get(string3);
        Assert.assert(n != null, "ssim_ssttable_lang_botch", new Object[]{string3, string, string2});
        n = new Integer(n - 1);
        if (n <= 0) {
            hashtable.remove(string3);
            if (hashtable.size() <= 0) {
                this.sstLocales.remove(string4);
            }
            String string5 = this.makeScopeTypeLangKey(string2, string, string3);
            this.scopeTypeLangTable.remove(string5);
        } else {
            hashtable.put(string3, n);
        }
    }

    public synchronized void deregister(ServiceURL serviceURL, Vector vector, Hashtable hashtable) throws ServiceLocationException {
        ServiceRecordInMemory serviceRecordInMemory = this.findExistingRecord(serviceURL, vector, null);
        if (serviceRecordInMemory == null) {
            throw new ServiceLocationException(3, "ssim_no_rec", new Object[]{serviceURL});
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (serviceRecordInMemory.urlSig.remove(k) != null) continue;
                throw new ServiceLocationException(7, "not_all_spis_present", new Object[]{k});
            }
            if (serviceRecordInMemory.urlSig.size() != 0) {
                throw new ServiceLocationException(7, "not_all_spis_present", new Object[]{serviceRecordInMemory.urlSig.keys()});
            }
        }
        this.deregisterInternal(serviceRecordInMemory.getServiceURL(), vector, null);
    }

    private void deregisterFromLocale(Hashtable hashtable, String string) {
        Vector vector = (Vector)hashtable.get(string);
        Assert.assert(vector != null, "ssim_null_reg_vector", new Object[]{string});
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            List list = (List)vector.elementAt(n2);
            list.delete();
            ++n2;
        }
        hashtable.remove(string);
    }

    private void deregisterInternal(ServiceURL serviceURL, Vector vector, String string) {
        ServiceType serviceType = serviceURL.getServiceType();
        Hashtable hashtable = (Hashtable)this.urlScopeLangTable.get(serviceURL.toString());
        if (hashtable == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            if (hashtable2 != null) {
                if (string != null) {
                    this.deregisterFromLocale(hashtable2, string);
                    this.deleteTypeLocale(serviceType.toString(), string2, string);
                    if (serviceType.isAbstractType()) {
                        this.deleteTypeLocale(serviceType.getAbstractTypeName(), string2, string);
                    }
                } else {
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        this.deregisterFromLocale(hashtable2, string);
                        this.deleteTypeLocale(serviceType.toString(), string2, string);
                        if (!serviceType.isAbstractType()) continue;
                        this.deleteTypeLocale(serviceType.getAbstractTypeName(), string2, string);
                    }
                }
                if (hashtable2.size() <= 0) {
                    hashtable.remove(string2);
                }
            }
            ++n2;
        }
        if (hashtable.size() <= 0) {
            this.urlScopeLangTable.remove(serviceURL.toString());
        }
    }

    public synchronized void dumpServiceStore() {
        SLPConfig sLPConfig = SLPConfig.getSLPConfig();
        sLPConfig.writeLogLine("ssim_dump_start", new Object[]{this});
        Enumeration enumeration = this.scopeTypeLangTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            STLRecord sTLRecord = (STLRecord)this.scopeTypeLangTable.get(string);
            if (sTLRecord.isAbstract) continue;
            BtreeVector btreeVector = sTLRecord.attrSort;
            Vector vector = new Vector();
            AllBVCollector allBVCollector = new AllBVCollector(vector);
            btreeVector.getAll(allBVCollector);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ServiceRecordInMemory serviceRecordInMemory = (ServiceRecordInMemory)vector.elementAt(n2);
                this.writeRecordToLog(sLPConfig, serviceRecordInMemory);
                ++n2;
            }
        }
        sLPConfig.writeLog("ssim_dump_end", new Object[]{this});
    }

    public synchronized Hashtable findAttributes(ServiceURL serviceURL, Vector vector, Vector vector2, Locale locale) throws ServiceLocationException {
        Hashtable<String, Cloneable> hashtable = new Hashtable<String, Cloneable>();
        Vector vector3 = new Vector();
        String string = locale.getLanguage();
        Hashtable hashtable2 = null;
        int n = this.languageSupported(serviceURL.getServiceType().toString(), vector, string);
        if (n == 1) {
            throw new ServiceLocationException(1, "ssim_lang_unsup", new Object[]{locale});
        }
        if (n == 2) {
            vector2 = this.stringVectorToAttributePattern(vector2, locale);
            Hashtable hashtable3 = (Hashtable)this.urlScopeLangTable.get(serviceURL.toString());
            if (hashtable3 != null) {
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    Vector vector4;
                    String string2 = (String)vector.elementAt(n3);
                    Hashtable hashtable4 = (Hashtable)hashtable3.get(string2);
                    if (hashtable4 != null && (vector4 = (Vector)hashtable4.get(string)) != null) {
                        List list = (List)vector4.elementAt(0);
                        ServiceRecordInMemory serviceRecordInMemory = list.record;
                        ServiceStoreInMemory.findMatchingAttributes(serviceRecordInMemory, vector2, hashtable, vector3);
                        hashtable.clear();
                        hashtable.put("FA_ATTRIBUTES", vector3);
                        hashtable2 = serviceRecordInMemory.getAttrSignature();
                        if (hashtable2 == null) break;
                        hashtable.put("FA_SIG", hashtable2);
                        break;
                    }
                    ++n3;
                }
            }
        }
        if (hashtable.size() <= 0) {
            hashtable.put("FA_ATTRIBUTES", vector3);
        }
        return hashtable;
    }

    public synchronized Vector findAttributes(String string, Vector vector, Vector vector2, Locale locale) throws ServiceLocationException {
        String string2 = locale.getLanguage();
        Vector vector3 = new Vector();
        int n = this.languageSupported(string, vector, string2);
        if (n == 1) {
            throw new ServiceLocationException(1, "ssim_lang_unsup", new Object[]{locale});
        }
        if (n == 2) {
            vector2 = this.stringVectorToAttributePattern(vector2, locale);
            int n2 = vector2.size();
            AttributeBVCollector attributeBVCollector = new AttributeBVCollector(vector2, vector3);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                String string3 = (String)vector.elementAt(n4);
                String string4 = this.makeScopeTypeLangKey(string3, string, string2);
                STLRecord sTLRecord = (STLRecord)this.scopeTypeLangTable.get(string4);
                if (sTLRecord != null) {
                    BtreeVector btreeVector = sTLRecord.attrSort;
                    if (n2 <= 0) {
                        btreeVector.getAll(attributeBVCollector);
                    } else {
                        int n5 = 0;
                        while (n5 < n2) {
                            AttributePattern attributePattern = (AttributePattern)vector2.elementAt(n5);
                            btreeVector.matchEqual(attributePattern, attributeBVCollector);
                            ++n5;
                        }
                    }
                }
                ++n4;
            }
        }
        return vector3;
    }

    private ServiceRecordInMemory findExistingRecord(ServiceURL serviceURL, Vector vector, String string) {
        ServiceRecordInMemory serviceRecordInMemory = null;
        Hashtable hashtable = (Hashtable)this.urlScopeLangTable.get(serviceURL.toString());
        if (hashtable != null) {
            Enumeration<Object> enumeration = null;
            enumeration = vector == null ? hashtable.keys() : vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string2 = (String)enumeration.nextElement();
                Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
                if (hashtable2 == null) continue;
                Vector vector2 = null;
                if (string != null) {
                    vector2 = (Vector)hashtable2.get(string);
                } else {
                    object = hashtable2.elements();
                    vector2 = (Vector)object.nextElement();
                }
                if (vector2 == null) continue;
                object = (List)vector2.elementAt(0);
                serviceRecordInMemory = ((List)object).record;
                break;
            }
        }
        return serviceRecordInMemory;
    }

    static void findMatchingAttributes(ServiceRecordInMemory serviceRecordInMemory, Vector vector, Hashtable hashtable, Vector vector2) throws ServiceLocationException {
        int n = vector.size();
        Vector vector3 = serviceRecordInMemory.getAttrList();
        int n2 = vector3.size();
        int n3 = 0;
        while (n3 < n2) {
            ServerAttribute serverAttribute = (ServerAttribute)vector3.elementAt(n3);
            if (n <= 0) {
                ServiceStoreInMemory.saveValueIfMatch(serverAttribute, null, hashtable, vector2);
            } else {
                int n4 = 0;
                while (n4 < n) {
                    AttributePattern attributePattern = (AttributePattern)vector.elementAt(n4);
                    ServiceStoreInMemory.saveValueIfMatch(serverAttribute, attributePattern, hashtable, vector2);
                    ++n4;
                }
            }
            ++n3;
        }
    }

    public synchronized Vector findServiceTypes(String string, Vector vector) throws ServiceLocationException {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = this.scopeTypeLangTable.keys();
        boolean bl = string.equals("*");
        boolean bl2 = string.length() <= 0;
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3;
            String string4 = (String)enumeration.nextElement();
            if (this.isAbstractTypeRecord(string4) || !vector.contains(string3 = this.keyScope(string4)) || vector2.contains(string2 = this.keyServiceType(string4))) continue;
            ServiceType serviceType = new ServiceType(string2);
            if (bl) {
                vector2.addElement(serviceType.toString());
                continue;
            }
            String string5 = serviceType.getNamingAuthority();
            if (serviceType.isNADefault() && bl2) {
                vector2.addElement(serviceType.toString());
                continue;
            }
            if (!string.equals(string5)) continue;
            vector2.addElement(serviceType.toString());
        }
        return vector2;
    }

    public synchronized Hashtable findServices(String string, Vector vector, String string2, Locale locale) throws ServiceLocationException {
        Object object;
        String string3 = locale.getLanguage();
        Parser.ParserRecord parserRecord = new Parser.ParserRecord();
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        int n = vector.size();
        int n2 = 0;
        hashtable = parserRecord.services;
        hashtable2 = parserRecord.signatures;
        string2 = string2.trim();
        n2 = string2.length();
        int n3 = this.languageSupported(string, vector, string3);
        if (n3 == 1) {
            throw new ServiceLocationException(1, "ssim_lang_unsup", new Object[]{locale});
        }
        if (n3 == 2) {
            int n4 = 0;
            while (n4 < n) {
                object = (String)vector.elementAt(n4);
                String string4 = this.makeScopeTypeLangKey((String)object, string, string3);
                STLRecord sTLRecord = (STLRecord)this.scopeTypeLangTable.get(string4);
                if (sTLRecord != null) {
                    Object object2;
                    if (n2 <= 0) {
                        object2 = sTLRecord.attrSort;
                        ParserBVCollector parserBVCollector = new ParserBVCollector(vector);
                        parserBVCollector.prReturns = parserRecord;
                        ((BtreeVector)object2).getAll(parserBVCollector);
                    } else {
                        object2 = new InMemoryEvaluator(sTLRecord.attrValueSort, sTLRecord.attrSort, vector);
                        Parser.parseAndEvaluateQuery(string2, (Parser.QueryEvaluator)object2, locale, parserRecord);
                    }
                }
                ++n4;
            }
        }
        object = new Hashtable<String, Hashtable>();
        ((Hashtable)object).put("FS_SERVICES", hashtable);
        if (hashtable2.size() > 0) {
            ((Hashtable)object).put("FS_SIGTABLE", hashtable2);
        }
        return object;
    }

    public synchronized ServiceStore.ServiceRecord getServiceRecord(ServiceURL serviceURL, Locale locale) {
        if (serviceURL == null || locale == null) {
            return null;
        }
        return this.findExistingRecord(serviceURL, null, SLPConfig.localeToLangTag(locale));
    }

    public synchronized Enumeration getServiceRecordsByScope(Vector vector) {
        Vector vector2 = new Vector();
        ScopeBVCollector scopeBVCollector = new ScopeBVCollector(vector2, vector);
        Enumeration enumeration = this.scopeTypeLangTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            STLRecord sTLRecord = (STLRecord)this.scopeTypeLangTable.get(string);
            BtreeVector btreeVector = sTLRecord.attrSort;
            btreeVector.getAll(scopeBVCollector);
        }
        return vector2.elements();
    }

    public long getStateTimestamp() {
        return this.bootTime;
    }

    private Vector initializeURLScopeLangTableVector(ServiceURL serviceURL, String string, String string2) {
        Hashtable hashtable;
        Hashtable hashtable2 = (Hashtable)this.urlScopeLangTable.get(serviceURL.toString());
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            this.urlScopeLangTable.put(serviceURL.toString(), hashtable2);
        }
        if ((hashtable = (Hashtable)hashtable2.get(string)) == null) {
            hashtable = new Hashtable();
            hashtable2.put(string, hashtable);
        }
        Assert.assert(hashtable.get(string2) == null, "ssim_url_lang_botch", new Object[]{string2, serviceURL, string});
        Vector vector = new Vector();
        hashtable.put(string2, vector);
        return vector;
    }

    private final boolean isAbstractTypeRecord(String string) {
        STLRecord sTLRecord = (STLRecord)this.scopeTypeLangTable.get(string);
        return sTLRecord.isAbstract;
    }

    private final String keyScope(String string) {
        int n = string.indexOf(47);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private final String keyServiceType(String string) {
        int n = string.indexOf(47);
        String string2 = "";
        int n2 = string.length();
        if (n >= 0 && n < n2 - 1) {
            string2 = string.substring(n + 1, n2);
        }
        n = string2.indexOf(47);
        string2 = string2.substring(0, n);
        return string2;
    }

    private int languageSupported(String string, Vector vector, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)vector.elementAt(n2);
            String string4 = this.makeScopeTypeKey(string3, string);
            Hashtable hashtable = (Hashtable)this.sstLocales.get(string4);
            if (hashtable != null) {
                Object v = hashtable.get(string2);
                if (v == null) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            ++n2;
        }
        if (!bl && !bl2) {
            return 0;
        }
        if (bl && !bl2) {
            return 1;
        }
        return 2;
    }

    private Hashtable makeAttrTypeTable() {
        Hashtable<String, BtreeVector> hashtable = new Hashtable<String, BtreeVector>();
        hashtable.put(INTEGER_TYPE, new BtreeVector());
        hashtable.put(ATTRIBUTE_STRING_TYPE, new BtreeVector());
        hashtable.put(BOOLEAN_TYPE, new BtreeVector());
        hashtable.put(OPAQUE_TYPE, new BtreeVector());
        return hashtable;
    }

    private String makeScopeTypeKey(String string, String string2) {
        return String.valueOf(string) + "/" + string2;
    }

    private final String makeScopeTypeLangKey(String string, String string2, String string3) {
        return String.valueOf(string) + "/" + string2 + "/" + string3;
    }

    private final void mergeOldRecordIntoNew(ServiceRecordInMemory serviceRecordInMemory, ServiceRecordInMemory serviceRecordInMemory2) throws ServiceLocationException {
        Serializable serializable;
        Vector vector = serviceRecordInMemory2.getAttrList();
        Vector vector2 = serviceRecordInMemory.getAttrList();
        Hashtable<String, ServerAttribute> hashtable = new Hashtable<String, ServerAttribute>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            serializable = (ServerAttribute)vector.elementAt(n2);
            hashtable.put(((ServiceLocationAttribute)serializable).getId().toLowerCase(), (ServerAttribute)serializable);
            ++n2;
        }
        n = vector2.size();
        n2 = 0;
        while (n2 < n) {
            serializable = (ServerAttribute)vector2.elementAt(n2);
            if (hashtable.get(((ServiceLocationAttribute)serializable).getId().toLowerCase()) == null) {
                vector.addElement(serializable);
            }
            ++n2;
        }
        serviceRecordInMemory2.setAttrList(vector);
        serializable = serviceRecordInMemory.getScopes();
        Vector vector3 = serviceRecordInMemory2.getScopes();
        int n3 = ((Vector)serializable).size();
        int n4 = 0;
        while (n4 < n3) {
            String string = (String)((Vector)serializable).elementAt(n4);
            if (!vector3.contains(string)) {
                vector3.addElement(string);
            }
            ++n4;
        }
        serviceRecordInMemory2.setScopes(vector3);
    }

    public synchronized boolean register(ServiceURL serviceURL, Vector vector, Vector vector2, Locale locale, Hashtable hashtable, Hashtable hashtable2) throws ServiceLocationException {
        boolean bl = false;
        String string = locale.getLanguage();
        ServiceRecordInMemory serviceRecordInMemory = this.findExistingRecord(serviceURL, null, string);
        if (serviceRecordInMemory != null) {
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (serviceRecordInMemory.urlSig.remove(k) != null) continue;
                    throw new ServiceLocationException(7, "not_all_spis_present", new Object[]{k});
                }
                if (serviceRecordInMemory.urlSig.size() != 0) {
                    throw new ServiceLocationException(7, "not_all_spis_present", new Object[]{serviceRecordInMemory.urlSig.keys()});
                }
            }
            this.deregisterInternal(serviceURL, serviceRecordInMemory.getScopes(), string);
            bl = true;
        }
        serviceRecordInMemory = new ServiceRecordInMemory(serviceURL, vector, vector2, locale, hashtable, hashtable2);
        this.registerInternal(serviceRecordInMemory);
        return bl;
    }

    private void registerInternal(ServiceRecordInMemory serviceRecordInMemory) {
        ServiceURL serviceURL = serviceRecordInMemory.getServiceURL();
        ServiceType serviceType = serviceURL.getServiceType();
        String string = serviceType.toString();
        String string2 = serviceType.getAbstractTypeName();
        Locale locale = serviceRecordInMemory.getLocale();
        String string3 = locale.getLanguage();
        Vector vector = serviceRecordInMemory.getScopes();
        List list = this.addToAgeOutQueue(serviceRecordInMemory);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)vector.elementAt(n2);
            Vector vector2 = this.initializeURLScopeLangTableVector(serviceURL, string4, string3);
            this.addRecordToScopeTypeLangTable(string4, string, string3, false, serviceRecordInMemory, vector2);
            this.addTypeLocale(string, string4, string3);
            vector2.addElement(list);
            if (serviceType.isAbstractType()) {
                this.addRecordToScopeTypeLangTable(string4, string2, string3, true, serviceRecordInMemory, vector2);
                this.addTypeLocale(string2, string4, string3);
            }
            ++n2;
        }
    }

    private static void saveValueIfMatch(ServerAttribute serverAttribute, AttributePattern attributePattern, Hashtable hashtable, Vector vector) throws ServiceLocationException {
        AttributeString attributeString = serverAttribute.idPattern;
        if (attributePattern == null || attributePattern.match(attributeString)) {
            Vector vector2 = serverAttribute.getValues();
            if (vector2 != null) {
                vector2 = (Vector)vector2.clone();
            }
            ServiceLocationAttribute serviceLocationAttribute = new ServiceLocationAttribute(serverAttribute.getId(), vector2);
            ServiceLocationAttribute.mergeDuplicateAttributes(serviceLocationAttribute, hashtable, vector, true);
        }
    }

    private Vector stringVectorToAttributePattern(Vector vector, Locale locale) throws ServiceLocationException {
        if (vector == null) {
            return null;
        }
        Vector<AttributePattern> vector2 = new Vector<AttributePattern>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            AttributePattern attributePattern = new AttributePattern(string, locale);
            if (!vector2.contains(attributePattern)) {
                vector2.addElement(attributePattern);
            }
            ++n2;
        }
        return vector2;
    }

    public synchronized void updateRegistration(ServiceURL serviceURL, Vector vector, Vector vector2, Locale locale) throws ServiceLocationException {
        String string = locale.getLanguage();
        ServiceRecordInMemory serviceRecordInMemory = this.findExistingRecord(serviceURL, vector2, string);
        if (serviceRecordInMemory == null) {
            throw new ServiceLocationException(13, "ssim_no_rec", new Object[]{serviceURL});
        }
        ServiceType serviceType = serviceURL.getServiceType();
        if (!serviceType.isServiceURL()) {
            this.checkForExistingUnderOtherServiceType(serviceURL, vector2);
        }
        this.deregisterInternal(serviceURL, vector2, string);
        ServiceRecordInMemory serviceRecordInMemory2 = new ServiceRecordInMemory(serviceURL, vector, vector2, locale, null, null);
        this.mergeOldRecordIntoNew(serviceRecordInMemory, serviceRecordInMemory2);
        this.registerInternal(serviceRecordInMemory2);
    }

    private void writeRecordToLog(SLPConfig sLPConfig, ServiceStore.ServiceRecord serviceRecord) {
        Locale locale = serviceRecord.getLocale();
        ServiceURL serviceURL = serviceRecord.getServiceURL();
        Vector vector = serviceRecord.getScopes();
        Vector vector2 = serviceRecord.getAttrList();
        long l = serviceRecord.getExpirationTime();
        Hashtable hashtable = serviceRecord.getURLSignature();
        Hashtable hashtable2 = serviceRecord.getAttrSignature();
        sLPConfig.writeLogLine("ssim_dump_entry_start", new Object[0]);
        sLPConfig.writeLogLine("ssim_dump_entry", new Object[]{locale, serviceURL.toString(), Integer.toString(serviceURL.getLifetime()), Long.toString((l - System.currentTimeMillis()) / 1000L), serviceURL.getServiceType(), vector, vector2});
        if (hashtable != null) {
            sLPConfig.writeLogLine("ssim_dump_urlsig", new Object[]{hashtable});
        }
        if (hashtable2 != null) {
            sLPConfig.writeLogLine("ssim_dump_attrsig", new Object[]{hashtable2});
        }
        sLPConfig.writeLogLine("ssim_entry_end", new Object[0]);
    }

    private static interface BVCollector {
        public void setReturn(ServiceRecordInMemory var1);
    }

    private class ParserBVCollector
    implements BVCollector {
        Parser.ParserRecord prReturns = null;
        private Vector scopes = null;

        ParserBVCollector(Vector vector) {
            this.scopes = vector;
        }

        public void setReturn(ServiceRecordInMemory serviceRecordInMemory) {
            Hashtable hashtable = this.prReturns.services;
            Hashtable hashtable2 = this.prReturns.signatures;
            ServiceURL serviceURL = serviceRecordInMemory.getServiceURL();
            if (hashtable.get(serviceURL) == null) {
                Vector vector = (Vector)serviceRecordInMemory.getScopes().clone();
                DATable.filterScopes(vector, this.scopes, false);
                long l = (serviceRecordInMemory.getExpirationTime() - System.currentTimeMillis()) / 1000L;
                if (l > 0L) {
                    ServiceURL serviceURL2 = new ServiceURL(serviceURL.toString(), (int)l);
                    hashtable.put(serviceURL, vector);
                    Hashtable hashtable3 = serviceRecordInMemory.getURLSignature();
                    if (hashtable3 != null) {
                        hashtable2.put(serviceURL2, hashtable3);
                    }
                }
            }
        }
    }

    private class AttributeBVCollector
    implements BVCollector {
        private Hashtable alreadySeen = new Hashtable();
        private Vector attrTags = null;
        private Hashtable ht = new Hashtable();
        private Vector ret = null;

        AttributeBVCollector(Vector vector, Vector vector2) {
            this.attrTags = vector;
            this.ret = vector2;
        }

        public void setReturn(ServiceRecordInMemory serviceRecordInMemory) {
            block2: {
                if (this.alreadySeen.get(serviceRecordInMemory) != null) break block2;
                this.alreadySeen.put(serviceRecordInMemory, serviceRecordInMemory);
                try {
                    ServiceStoreInMemory.findMatchingAttributes(serviceRecordInMemory, this.attrTags, this.ht, this.ret);
                }
                catch (ServiceLocationException serviceLocationException) {
                    Assert.assert(false, "ssim_attrbvc_botch", new Object[]{serviceLocationException.getMessage()});
                }
            }
        }
    }

    private class ScopeBVCollector
    implements BVCollector {
        private Hashtable alreadySeen = new Hashtable();
        private Vector records = null;
        private Vector scopes = null;

        ScopeBVCollector(Vector vector, Vector vector2) {
            this.records = vector;
            this.scopes = vector2;
        }

        public void setReturn(ServiceRecordInMemory serviceRecordInMemory) {
            if (this.alreadySeen.get(serviceRecordInMemory) == null) {
                this.alreadySeen.put(serviceRecordInMemory, serviceRecordInMemory);
                if (this.scopes == null) {
                    this.records.addElement(serviceRecordInMemory);
                } else {
                    Vector vector = serviceRecordInMemory.getScopes();
                    int n = this.scopes.size();
                    int n2 = 0;
                    while (n2 < n) {
                        if (vector.contains(this.scopes.elementAt(n2))) {
                            this.records.addElement(serviceRecordInMemory);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private class AllBVCollector
    implements BVCollector {
        private Vector records = null;

        AllBVCollector(Vector vector) {
            this.records = vector;
        }

        public void setReturn(ServiceRecordInMemory serviceRecordInMemory) {
            if (!this.records.contains(serviceRecordInMemory)) {
                this.records.addElement(serviceRecordInMemory);
            }
        }
    }

    private class List {
        ServiceRecordInMemory record = null;
        List next = null;
        List prev = null;

        List(ServiceRecordInMemory serviceRecordInMemory) {
            this.record = serviceRecordInMemory;
        }

        synchronized void delete() {
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.prev = null;
            this.next = null;
        }

        synchronized List insertAfter(ServiceRecordInMemory serviceRecordInMemory) {
            List list = new List(serviceRecordInMemory);
            list.next = this.next;
            list.prev = this;
            if (this.next != null) {
                this.next.prev = list;
            }
            this.next = list;
            return list;
        }
    }

    private class RegRecord {
        Object value = null;
        List head = new List(null);

        RegRecord(Object object) {
            this.value = object;
        }

        List add(ServiceRecordInMemory serviceRecordInMemory) {
            return this.head.insertAfter(serviceRecordInMemory);
        }

        boolean setReturn(BVCollector bVCollector) {
            boolean bl = false;
            List list = this.head;
            list = list.next;
            while (list != null) {
                ServiceRecordInMemory serviceRecordInMemory = list.record;
                bVCollector.setReturn(serviceRecordInMemory);
                bl = true;
                list = list.next;
            }
            return bl;
        }

        public String toString() {
            return "<RegRecord value=" + this.value + "list=" + this.head.next + ">";
        }
    }

    private class BtreeVector {
        private Vector contents = new Vector();

        BtreeVector() {
        }

        List add(Object object, ServiceRecordInMemory serviceRecordInMemory) {
            RegRecord regRecord = this.walkVector(object, true);
            return regRecord.add(serviceRecordInMemory);
        }

        boolean compareEqual(Object object, Object object2) {
            if (object instanceof Integer || object instanceof Boolean || object instanceof Opaque || object instanceof Long) {
                if (object2.equals(object)) {
                    return true;
                }
            } else if (object instanceof AttributeString) {
                if (((AttributeString)object2).match((AttributeString)object)) {
                    return true;
                }
            } else {
                Assert.assert(false, "ssim_unk_qtype", new Object[]{object2.getClass().getName()});
            }
            return false;
        }

        boolean compareGreaterEqual(Object object, Object object2) {
            if (object instanceof Integer) {
                if ((Integer)object >= (Integer)object2) {
                    return true;
                }
            } else if (object instanceof AttributeString) {
                if (((AttributeString)object).greaterEqual((AttributeString)object2)) {
                    return true;
                }
            } else if (object instanceof Long) {
                if ((Long)object >= (Long)object2) {
                    return true;
                }
            } else if (object instanceof Boolean || object instanceof Opaque) {
                if (object.toString().compareTo(object2.toString()) >= 0) {
                    return true;
                }
            } else {
                Assert.assert(false, "ssim_unk_qtype", new Object[]{object.getClass().getName()});
            }
            return false;
        }

        boolean compareLessEqual(Object object, Object object2) {
            if (object instanceof Integer) {
                if ((Integer)object <= (Integer)object2) {
                    return true;
                }
            } else if (object instanceof AttributeString) {
                if (((AttributeString)object).lessEqual((AttributeString)object2)) {
                    return true;
                }
            } else if (object instanceof Long) {
                if ((Long)object <= (Long)object2) {
                    return true;
                }
            } else if (object instanceof Boolean || object instanceof Opaque) {
                if (object.toString().compareTo(object2.toString()) <= 0) {
                    return true;
                }
            } else {
                Assert.assert(false, "ssim_unk_qtype", new Object[]{object.getClass().getName()});
            }
            return false;
        }

        boolean getAll(BVCollector bVCollector) {
            int n = this.contents.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                RegRecord regRecord = (RegRecord)this.contents.elementAt(n2);
                bl |= regRecord.setReturn(bVCollector);
                ++n2;
            }
            return bl;
        }

        Vector getContents() {
            return this.contents;
        }

        boolean matchDoesNotContain(Object object, BVCollector bVCollector) {
            RegRecord regRecord;
            int n = this.contents.size();
            Vector<RegRecord> vector = new Vector<RegRecord>();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                regRecord = (RegRecord)this.contents.elementAt(n2);
                if (!this.compareEqual(regRecord.value, object)) {
                    vector.addElement(regRecord);
                }
                ++n2;
            }
            n = vector.size();
            n2 = 0;
            while (n2 < n) {
                regRecord = (RegRecord)vector.elementAt(n2);
                bl |= regRecord.setReturn(bVCollector);
                ++n2;
            }
            return bl;
        }

        boolean matchEqual(Object object, BVCollector bVCollector) {
            boolean bl = false;
            if (object instanceof AttributePattern) {
                int n = this.contents.size();
                int n2 = 0;
                while (n2 < n) {
                    RegRecord regRecord = (RegRecord)this.contents.elementAt(n2);
                    AttributePattern attributePattern = (AttributePattern)object;
                    AttributeString attributeString = (AttributeString)regRecord.value;
                    if (attributePattern.match(attributeString)) {
                        bl |= regRecord.setReturn(bVCollector);
                    }
                    ++n2;
                }
            } else {
                RegRecord regRecord = this.walkVector(object, false);
                bl = regRecord == null ? false : regRecord.setReturn(bVCollector);
            }
            return bl;
        }

        boolean matchGreaterEqual(Object object, BVCollector bVCollector) {
            int n = this.contents.size();
            boolean bl = false;
            int n2 = n - 1;
            while (n2 >= 0) {
                RegRecord regRecord = (RegRecord)this.contents.elementAt(n2);
                if (!this.compareGreaterEqual(regRecord.value, object)) break;
                bl |= regRecord.setReturn(bVCollector);
                --n2;
            }
            return bl;
        }

        boolean matchLessEqual(Object object, BVCollector bVCollector) {
            int n = this.contents.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                RegRecord regRecord = (RegRecord)this.contents.elementAt(n2);
                if (!this.compareLessEqual(regRecord.value, object)) break;
                bl |= regRecord.setReturn(bVCollector);
                ++n2;
            }
            return bl;
        }

        boolean matchNotEqual(Object object, BVCollector bVCollector) {
            int n = this.contents.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                RegRecord regRecord = (RegRecord)this.contents.elementAt(n2);
                if (!this.compareEqual(regRecord.value, object)) {
                    bl |= regRecord.setReturn(bVCollector);
                }
                ++n2;
            }
            return bl;
        }

        boolean matchNotGreaterEqual(Object object, BVCollector bVCollector) {
            int n = this.contents.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                RegRecord regRecord = (RegRecord)this.contents.elementAt(n2);
                if (this.compareGreaterEqual(regRecord.value, object)) break;
                bl |= regRecord.setReturn(bVCollector);
                ++n2;
            }
            return bl;
        }

        boolean matchNotLessEqual(Object object, BVCollector bVCollector) {
            int n = this.contents.size();
            boolean bl = false;
            int n2 = n - 1;
            while (n2 >= 0) {
                RegRecord regRecord = (RegRecord)this.contents.elementAt(n2);
                if (this.compareLessEqual(regRecord.value, object)) break;
                bl |= regRecord.setReturn(bVCollector);
                --n2;
            }
            return bl;
        }

        public String toString() {
            return "<BtreeVector " + this.contents.toString() + ">";
        }

        private RegRecord walkVector(Object object, boolean bl) {
            int n = this.contents.size();
            int n2 = n / 2;
            int n3 = n - 1;
            int n4 = 0;
            RegRecord regRecord = null;
            n3 = n3 < 0 ? 0 : n3;
            while (n > 0) {
                regRecord = (RegRecord)this.contents.elementAt(n2);
                if (bl && regRecord.head.next == null) {
                    this.contents.removeElementAt(n2);
                    n2 = n4 + --n / 2;
                    n3 = --n3 < 0 ? 0 : n3;
                    continue;
                }
                if (this.compareEqual(regRecord.value, object)) {
                    return regRecord;
                }
                if (this.compareLessEqual(object, regRecord.value)) {
                    n3 = n2;
                    n = n3 - n4;
                    int n5 = n2 = (n2 = n3 - n / 2) < 0 ? 0 : n2;
                    if (n2 != n3) continue;
                    regRecord = null;
                    RegRecord regRecord2 = (RegRecord)this.contents.elementAt(n4);
                    if (bl) {
                        regRecord = new RegRecord(object);
                        if (this.compareEqual(regRecord2.value, object)) {
                            return regRecord2;
                        }
                        if (this.compareLessEqual(object, regRecord2.value)) {
                            this.contents.insertElementAt(regRecord, n4);
                            break;
                        }
                        this.contents.insertElementAt(regRecord, n2);
                        break;
                    }
                    if (!this.compareEqual(regRecord2.value, object)) break;
                    regRecord = regRecord2;
                    break;
                }
                if (!this.compareGreaterEqual(object, regRecord.value) || (n2 = (n4 = n2) + (n = n3 - n4) / 2) != n4) continue;
                regRecord = null;
                RegRecord regRecord3 = (RegRecord)this.contents.elementAt(n3);
                if (bl) {
                    regRecord = new RegRecord(object);
                    if (this.compareEqual(regRecord3.value, object)) {
                        return regRecord3;
                    }
                    if (this.compareGreaterEqual(object, regRecord3.value)) {
                        int n6 = n3 + 1;
                        if (n6 >= this.contents.size()) {
                            this.contents.addElement(regRecord);
                            break;
                        }
                        this.contents.insertElementAt(regRecord, n6);
                        break;
                    }
                    this.contents.insertElementAt(regRecord, n3);
                    break;
                }
                if (!this.compareEqual(regRecord3.value, object)) break;
                regRecord = regRecord3;
                break;
            }
            if (bl && regRecord == null) {
                regRecord = new RegRecord(object);
                Assert.assert(this.contents.size() == 0, "ssim_btree_botch", new Object[0]);
                this.contents.addElement(regRecord);
            }
            return regRecord;
        }
    }

    private class InMemoryEvaluator
    implements Parser.QueryEvaluator {
        private Hashtable attrLevel;
        private BtreeVector attrLevelNot;
        private Vector inScopes;
        private ParserBVCollector returns;

        InMemoryEvaluator(Hashtable hashtable, BtreeVector btreeVector, Vector vector) {
            this.attrLevel = hashtable;
            this.attrLevelNot = btreeVector;
            this.inScopes = vector;
            ServiceStoreInMemory serviceStoreInMemory2 = ServiceStoreInMemory.this;
            serviceStoreInMemory2.getClass();
            this.returns = serviceStoreInMemory2.new ParserBVCollector(this.inScopes);
        }

        public boolean evaluate(AttributeString attributeString, char c, Object object, boolean bl, Parser.ParserRecord parserRecord) throws ServiceLocationException {
            Object object2;
            Hashtable hashtable;
            boolean bl2 = false;
            this.returns.prReturns = parserRecord;
            if (bl) {
                bl2 = this.attrLevelNot.matchDoesNotContain(attributeString, this.returns);
            }
            if ((hashtable = (Hashtable)this.attrLevel.get(attributeString)) == null) {
                return bl2;
            }
            if (c == '*') {
                if (!bl) {
                    bl2 = this.attrLevelNot.matchEqual(attributeString, this.returns);
                }
                return bl2;
            }
            Class<?> clazz = object.getClass();
            String string = clazz.getName();
            if (object instanceof AttributePattern) {
                string = clazz.getSuperclass().getName();
            }
            if (bl) {
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    String string2 = (String)object2.nextElement();
                    if (string2.equals(string)) continue;
                    BtreeVector btreeVector = (BtreeVector)hashtable.get(string2);
                    bl2 |= btreeVector.getAll(this.returns);
                }
            }
            object2 = (BtreeVector)hashtable.get(string);
            switch (c) {
                case '=': {
                    if (!bl) {
                        bl2 = ((BtreeVector)object2).matchEqual(object, this.returns);
                        break;
                    }
                    bl2 = ((BtreeVector)object2).matchNotEqual(object, this.returns);
                    break;
                }
                case '<': {
                    if (!bl) {
                        bl2 = ((BtreeVector)object2).matchLessEqual(object, this.returns);
                        break;
                    }
                    bl2 = ((BtreeVector)object2).matchNotLessEqual(object, this.returns);
                    break;
                }
                case '>': {
                    if (!bl) {
                        bl2 = ((BtreeVector)object2).matchGreaterEqual(object, this.returns);
                        break;
                    }
                    bl2 = ((BtreeVector)object2).matchNotGreaterEqual(object, this.returns);
                    break;
                }
                default: {
                    Assert.assert(false, "ssim_unk_qop", new Object[]{new Character(c)});
                }
            }
            return bl2;
        }
    }

    private class ServiceRecordInMemory
    implements ServiceStore.ServiceRecord {
        private ServiceURL serviceURL = null;
        private Vector attrList = null;
        private Locale locale = null;
        private long timeToDie = 0L;
        private Vector scopes = null;
        private Hashtable urlSig = null;
        private Hashtable attrSig = null;

        ServiceRecordInMemory(ServiceURL serviceURL, Vector vector, Vector vector2, Locale locale, Hashtable hashtable, Hashtable hashtable2) {
            Assert.nonNullParameter(serviceURL, "surl");
            Assert.nonNullParameter(vector, "alist");
            Assert.nonNullParameter(vector2, "nscopes");
            Assert.nonNullParameter(locale, "loc");
            this.serviceURL = serviceURL;
            this.attrList = this.attributeVectorToServerAttribute(vector, locale);
            this.scopes = vector2;
            this.locale = locale;
            this.urlSig = hashtable;
            this.attrSig = hashtable2;
            int n = this.serviceURL.getLifetime();
            this.timeToDie = (long)(n * 1000) + System.currentTimeMillis();
        }

        private Vector attributeVectorToServerAttribute(Vector vector, Locale locale) {
            int n = vector.size();
            Vector<ServerAttribute> vector2 = new Vector<ServerAttribute>();
            int n2 = 0;
            while (n2 < n) {
                ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)vector.elementAt(n2);
                vector2.addElement(new ServerAttribute(serviceLocationAttribute, locale));
                ++n2;
            }
            return vector2;
        }

        public final Vector getAttrList() {
            return this.attrList;
        }

        public Hashtable getAttrSignature() {
            return this.attrSig;
        }

        public long getExpirationTime() {
            return this.timeToDie;
        }

        public final Locale getLocale() {
            return this.locale;
        }

        public final Vector getScopes() {
            return this.scopes;
        }

        public final ServiceURL getServiceURL() {
            return this.serviceURL;
        }

        public Hashtable getURLSignature() {
            return this.urlSig;
        }

        final void setAttrList(Vector vector) {
            this.attrList = vector;
        }

        final void setAttrSignature(Hashtable hashtable) {
            this.attrSig = hashtable;
        }

        final void setScopes(Vector vector) {
            this.scopes = vector;
        }

        final void setURLSignature(Hashtable hashtable) {
            this.urlSig = hashtable;
        }

        public String toString() {
            String string = "{";
            string = String.valueOf(string) + this.serviceURL + ", " + this.locale + ", " + this.attrList + ", " + this.scopes + ", " + this.locale + ", " + this.urlSig + ", " + this.attrSig;
            string = String.valueOf(string) + "}";
            return string;
        }
    }

    private class STLRecord {
        Hashtable attrValueSort = new Hashtable();
        BtreeVector attrSort = new BtreeVector();
        boolean isAbstract = false;

        STLRecord(boolean bl) {
            this.isAbstract = bl;
        }
    }
}

