/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.CSrvReg;
import com.sun.slp.DATable;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceStore;
import com.sun.slp.ServiceStoreInMemory;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class ServiceStoreFactory {
    private static final String DEFAULT_SERVICE_STORE = "com.sun.slp.ServiceStoreInMemory";
    private static final String SERVICE_STORE_PROPERTY = "sun.net.slp.serviceStoreClass";
    private static final char COMMENT_CHAR1 = '#';
    private static final char COMMENT_CHAR2 = ';';
    private static final String URL_LIST_SEP = ", ";
    private static final String SCOPES_ATTR_ID = "scopes";

    ServiceStoreFactory() {
    }

    static ServiceStore createServiceStore() throws ServiceLocationException {
        return ServiceStoreFactory.createServiceStoreFromProperty(SERVICE_STORE_PROPERTY);
    }

    private static ServiceStore createServiceStoreFromProperty(String string) throws ServiceLocationException {
        Properties properties = System.getProperties();
        String string2 = properties.getProperty(string, DEFAULT_SERVICE_STORE);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServiceLocationException(20, "ssf_no_class", new Object[]{string2});
        }
        ServiceStore serviceStore = null;
        try {
            serviceStore = (ServiceStore)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceLocationException(20, "ssf_inst_ex", new Object[]{string2, instantiationException.getMessage()});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceLocationException(20, "ssf_ill_ex", new Object[]{string2, illegalAccessException.getMessage()});
        }
        catch (ClassCastException classCastException) {
            throw new ServiceLocationException(20, "ssf_class_cast", new Object[]{string2});
        }
        return serviceStore;
    }

    private static void deserialize(BufferedReader bufferedReader, ServiceStore serviceStore) throws IOException, ServiceLocationException {
        SLPConfig sLPConfig = SLPConfig.getSLPConfig();
        int n = 0;
        int n2 = 0;
        while (bufferedReader.ready()) {
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            char c;
            ++n;
            String string = bufferedReader.readLine().trim();
            if (string.length() <= 0 || (c = string.charAt(0)) == '#' || c == ';') continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, URL_LIST_SEP);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().trim();
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken().trim();
                        if (stringTokenizer.hasMoreTokens()) {
                            string5 = stringTokenizer.nextToken().trim();
                            if (stringTokenizer.hasMoreTokens()) {
                                string3 = null;
                            }
                        }
                    }
                }
            }
            if (string2 == null || string4 == null || string3 == null) {
                throw new ServiceLocationException(2, "ssf_not_valid_url", new Object[]{string});
            }
            Locale locale = SLPConfig.langTagToLocale(string3);
            ServiceURL serviceURL = null;
            try {
                int n3 = Integer.parseInt(string4);
                if (n3 == 65535) {
                    n3 = -1;
                }
                serviceURL = new ServiceURL(string2, n3);
                if (string5 != null) {
                    serializable3 = serviceURL.getServiceType();
                    if (serializable3.isServiceURL()) {
                        sLPConfig.writeLog("ssf_set_servc_err", new Object[]{string2, serializable3});
                    } else {
                        serializable2 = new ServiceType(string5);
                        if (!serializable2.isServiceURL() && !serializable2.equals(serviceURL.getServiceType())) {
                            serviceURL.setServiceType((ServiceType)serializable2);
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServiceLocationException(2, "ssf_not_valid_lifetime", new Object[]{string4, new Integer(n)});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ServiceLocationException(2, "ssf_syntax_err", new Object[]{illegalArgumentException.getMessage(), new Integer(n)});
            }
            Vector vector = new Vector();
            serializable3 = new Hashtable();
            serializable2 = null;
            boolean bl = true;
            try {
                while (bufferedReader.ready()) {
                    ++n;
                    string = bufferedReader.readLine();
                    if (string.length() > 0) {
                        if (string.indexOf("=") != -1) {
                            string = "(" + string + ")";
                        }
                        serializable = new ServiceLocationAttribute(string, false);
                        if (bl) {
                            bl = false;
                            if (((ServiceLocationAttribute)serializable).getId().equalsIgnoreCase(SCOPES_ATTR_ID)) {
                                serializable2 = serializable;
                                continue;
                            }
                        }
                        ServiceLocationAttribute.mergeDuplicateAttributes((ServiceLocationAttribute)serializable, (Hashtable)serializable3, vector, false);
                        continue;
                    }
                    break;
                }
            }
            catch (ServiceLocationException serviceLocationException) {
                serviceLocationException.makeAddendum(" (line " + n + ")");
                throw serviceLocationException;
            }
            serializable = null;
            if (serializable2 == null) {
                serializable = sLPConfig.getSAConfiguredScopes();
            } else {
                serializable = ((ServiceLocationAttribute)serializable2).getValues();
                try {
                    SLPHeaderV2.unescapeScopeStrings((Vector)serializable);
                    DATable.validateScopes((Vector)serializable, locale);
                }
                catch (ServiceLocationException serviceLocationException) {
                    serviceLocationException.makeAddendum(" (line " + n2 + ")");
                    throw serviceLocationException;
                }
            }
            serviceStore.register(serviceURL, vector, (Vector)serializable, locale, null, null);
            CSrvReg cSrvReg = new CSrvReg(true, locale, serviceURL, (Vector)serializable, vector, null, null);
            ServerDATable serverDATable = ServerDATable.getServerDATable();
            serverDATable.forwardSAMessage(cSrvReg, sLPConfig.getLoopback());
        }
    }

    static ServiceStore deserializeServiceStore(BufferedReader bufferedReader) throws ServiceLocationException {
        ServiceStoreInMemory serviceStoreInMemory = new ServiceStoreInMemory();
        try {
            ServiceStoreFactory.deserialize(bufferedReader, serviceStoreInMemory);
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(2, "ssf_io_deser", new Object[]{iOException.getMessage()});
        }
        return serviceStoreInMemory;
    }

    static void serialize(BufferedWriter bufferedWriter, ServiceStore serviceStore) throws IOException, ServiceLocationException {
        Enumeration enumeration = serviceStore.getServiceRecordsByScope(null);
        while (enumeration.hasMoreElements()) {
            ServiceStore.ServiceRecord serviceRecord = (ServiceStore.ServiceRecord)enumeration.nextElement();
            ServiceURL serviceURL = serviceRecord.getServiceURL();
            String string = serviceURL.toString();
            Vector vector = (Vector)serviceRecord.getAttrList().clone();
            Locale locale = serviceRecord.getLocale();
            Vector vector2 = serviceRecord.getScopes();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(URL_LIST_SEP);
            stringBuffer.append(SLPConfig.localeToLangTag(locale));
            stringBuffer.append(URL_LIST_SEP);
            stringBuffer.append(Integer.toString(serviceURL.getLifetime()));
            if (!string.startsWith("service")) {
                ServiceType serviceType = serviceURL.getServiceType();
                stringBuffer.append(URL_LIST_SEP);
                stringBuffer.append(serviceType.toString());
            }
            bufferedWriter.write(stringBuffer.toString(), 0, stringBuffer.length());
            bufferedWriter.newLine();
            stringBuffer.setLength(0);
            if (vector2.size() > 1 && !"default".equals((String)vector2.elementAt(0))) {
                vector.insertElementAt(new ServiceLocationAttribute(SCOPES_ATTR_ID, vector2), 0);
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)vector.elementAt(n2);
                Vector vector3 = serviceLocationAttribute.getValues();
                stringBuffer.append(ServiceLocationAttribute.escapeAttributeString(serviceLocationAttribute.getId(), false));
                if (vector3 != null) {
                    stringBuffer.append("=");
                    int n3 = vector3.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        Object e = vector3.elementAt(n4);
                        if (n4 > 0) {
                            stringBuffer.append(URL_LIST_SEP);
                        }
                        stringBuffer.append(ServiceLocationAttribute.escapeValue(e));
                        ++n4;
                    }
                }
                bufferedWriter.write(stringBuffer.toString(), 0, stringBuffer.length());
                bufferedWriter.newLine();
                stringBuffer.setLength(0);
                ++n2;
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
    }
}

