/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.Opaque;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServerAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.SrvLocHeader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServiceLocationAttribute
implements Serializable {
    static final String RESERVED = "(),\\!<=>~";
    static final char ESCAPE = '\\';
    static final char CTL_LOWER = '\u0000';
    static final char CTL_UPPER = '\u001f';
    static final char DEL = '\u007f';
    static final String WHITESPACE = " \n\t\r";
    static final char SPACE = ' ';
    static final char COMMA = ',';
    static final char PERCENT = '%';
    private static final String BAD_TAG_CHARS = "*\n\t\r";
    static final String TRUE = "true";
    static final String FALSE = "false";
    Vector values = null;
    String id = null;

    ServiceLocationAttribute() {
    }

    public ServiceLocationAttribute(String string, Vector vector) throws IllegalArgumentException {
        Assert.nonNullParameter(string, "id");
        this.id = string;
        if (vector != null && vector.size() > 0) {
            this.values = (Vector)vector.clone();
            this.verifyValueTypes(this.values, false);
        }
    }

    ServiceLocationAttribute(String string, boolean bl) throws ServiceLocationException {
        if (string == null || string.length() <= 0) {
            new ServiceLocationException(2, "null_string_parameter", new Object[]{string});
        }
        if (string.startsWith("(") && string.endsWith(")")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, string.length() - 1), "=", true);
            try {
                this.id = ServiceLocationAttribute.unescapeAttributeString(stringTokenizer.nextToken(), true);
                if (this.id.length() <= 0) {
                    throw new ServiceLocationException(2, "null_id", new Object[]{string});
                }
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken("");
                this.values = SrvLocHeader.parseCommaSeparatedListIn(string2, true);
                int n = this.values.size();
                Object var7_6 = null;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = (String)this.values.elementAt(n2);
                    Object object = ServiceLocationAttribute.evaluate(string3);
                    this.values.setElementAt(object, n2);
                    ++n2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ServiceLocationException(2, "assignment_syntax_err", new Object[]{string});
            }
            this.verifyValueTypes(this.values, bl);
        } else {
            if (string.indexOf(40) != -1 || string.indexOf(41) != -1) {
                throw new ServiceLocationException(2, "assignment_syntax_err", new Object[]{string});
            }
            this.id = ServiceLocationAttribute.unescapeAttributeString(string, true);
        }
    }

    private static boolean canEscape(char c) {
        return RESERVED.indexOf(c) != -1 || c >= '\u0000' && c <= '\u001f' || c == '\u007f';
    }

    public boolean equals(Object object) {
        if (!(object instanceof ServiceLocationAttribute)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)object;
        Vector vector = serviceLocationAttribute.values;
        if (!serviceLocationAttribute.getId().equalsIgnoreCase(this.id)) {
            return false;
        }
        if (this.values == null && vector == null) {
            return true;
        }
        if (this.values == null && vector != null || this.values != null && vector == null) {
            return false;
        }
        if (this.values.size() != vector.size()) {
            return false;
        }
        Object e = vector.elementAt(0);
        object = this.values.elementAt(0);
        if (object.getClass() != e.getClass()) {
            return false;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            e = vector.elementAt(n2);
            if (!this.values.contains(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static String escapeAttributeString(String string, boolean bl) throws ServiceLocationException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (bl && BAD_TAG_CHARS.indexOf(c) != -1) {
                throw new ServiceLocationException(2, "bad_id_char", new Object[]{Integer.toHexString(c)});
            }
            if (ServiceLocationAttribute.canEscape(c)) {
                stringBuffer.append('\\');
                String string2 = ServiceLocationAttribute.escapeChar(c);
                if (string2.length() <= 1) {
                    string2 = "0" + string2;
                }
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String escapeChar(char c) {
        byte[] byArray = null;
        try {
            byArray = String.valueOf(c).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.assert(false, "no_utf8", new Object[0]);
        }
        int n = 0;
        if (byArray.length > 3) {
            Assert.assert(false, "illegal_utf8", new Object[]{new Character(c)});
        }
        n = byArray[0] & 0xFF;
        if (byArray.length > 1) {
            n |= (byArray[1] & 0xFF) << 8;
        }
        if (byArray.length > 2) {
            n |= (byArray[2] & 0xFF) << 16;
        }
        String string = Integer.toHexString(n);
        return string;
    }

    public static String escapeId(String string) throws IllegalArgumentException {
        String string2 = null;
        try {
            string2 = ServiceLocationAttribute.escapeAttributeString(string, true);
        }
        catch (ServiceLocationException serviceLocationException) {
            throw new IllegalArgumentException(serviceLocationException.getMessage());
        }
        return string2;
    }

    public static String escapeValue(Object object) throws IllegalArgumentException {
        ServiceLocationAttribute.typeCheckValue(object);
        if (object instanceof byte[]) {
            object = new Opaque((byte[])object);
        }
        return ServiceLocationAttribute.escapeValueInternal(object);
    }

    private static String escapeValueInternal(Object object) {
        String string;
        if (object instanceof String) {
            try {
                string = ServiceLocationAttribute.escapeAttributeString((String)object, false);
            }
            catch (ServiceLocationException serviceLocationException) {
                throw new IllegalArgumentException(serviceLocationException.getMessage());
            }
        } else {
            string = object.toString();
        }
        return string;
    }

    static Object evaluate(String string) throws ServiceLocationException {
        Object object = null;
        try {
            object = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2;
            object = string.equalsIgnoreCase(TRUE) || string.equalsIgnoreCase(FALSE) ? Boolean.valueOf(string) : ((string2 = string).startsWith("\\ff") ? (Object)Opaque.unescapeByteArray(string2) : ServiceLocationAttribute.unescapeAttributeString(string2, false));
        }
        return object;
    }

    String externalize() throws ServiceLocationException {
        Object object;
        if (this.values == null) {
            return ServiceLocationAttribute.escapeAttributeString(this.id, true);
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.values.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            String string = null;
            string = ServiceLocationAttribute.escapeValueInternal(object);
            vector.addElement(string);
        }
        object = new StringBuffer("(" + ServiceLocationAttribute.escapeAttributeString(this.id, true) + "=");
        ((StringBuffer)object).append(SrvLocHeader.vectorToCommaSeparatedList(vector));
        ((StringBuffer)object).append(")");
        return ((StringBuffer)object).toString();
    }

    public String getId() {
        return this.id;
    }

    public Vector getValues() {
        if (this.values == null) {
            return null;
        }
        Vector vector = (Vector)this.values.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = vector.elementAt(n2);
            if (object instanceof Opaque) {
                object = ((Opaque)object).bytes;
            }
            vector.setElementAt(object, n2);
            ++n2;
        }
        return vector;
    }

    public int hashCode() {
        return this.id.toLowerCase().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void mergeDuplicateAttributes(ServiceLocationAttribute serviceLocationAttribute, Hashtable hashtable, Vector vector, boolean bl) throws ServiceLocationException {
        String string = serviceLocationAttribute.getId().toLowerCase();
        ServiceLocationAttribute serviceLocationAttribute2 = (ServiceLocationAttribute)hashtable.get(string);
        Assert.assert(!(serviceLocationAttribute2 instanceof ServerAttribute) && !(serviceLocationAttribute instanceof ServerAttribute), "merge_servattr", new Object[0]);
        if (serviceLocationAttribute2 == null) {
            hashtable.put(string, serviceLocationAttribute);
            vector.addElement(serviceLocationAttribute);
            return;
        }
        Vector vector2 = serviceLocationAttribute.values;
        Vector vector3 = serviceLocationAttribute2.values;
        if (vector3 == null && vector2 == null) {
            return;
        }
        if (vector3 == null && vector2 != null || vector2 == null && vector3 != null) {
            Vector vector4;
            if (!bl) throw new ServiceLocationException(2, "attribute_type_mismatch", new Object[]{serviceLocationAttribute.getId()});
            serviceLocationAttribute2.values = vector4 = vector2 != null ? vector2 : vector3;
            serviceLocationAttribute.values = vector4;
            return;
        } else {
            int n = vector2.size();
            Object e = vector3.elementAt(0);
            Class<?> clazz = e.getClass();
            int n2 = 0;
            while (n2 < n) {
                Object e2 = vector2.elementAt(n2);
                if (clazz != e2.getClass() && !bl) {
                    throw new ServiceLocationException(2, "attribute_type_mismatch", new Object[]{serviceLocationAttribute.getId()});
                }
                if (e2 instanceof Boolean && !e2.equals(e) && !bl) {
                    throw new ServiceLocationException(2, "boolean_incompat", new Object[]{serviceLocationAttribute.getId()});
                }
                if (!vector3.contains(e2)) {
                    vector3.addElement(e2);
                }
                ++n2;
            }
            serviceLocationAttribute.values = vector3;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.id);
        if (this.values != null) {
            stringBuffer.append("=");
            int n = this.values.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.values.elementAt(n2);
                if (n2 == 0) {
                    stringBuffer.append(e.getClass().getName());
                    stringBuffer.append(":");
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(e.toString());
                ++n2;
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static void typeCheckValue(Object object) {
        SLPConfig sLPConfig = SLPConfig.getSLPConfig();
        Assert.nonNullParameter(object, "attribute value vector element");
        if (object.equals("")) {
            throw new IllegalArgumentException(sLPConfig.formatMessage("empty_string_value", new Object[0]));
        }
        if (!(object instanceof Integer || object instanceof Boolean || object instanceof String || object instanceof byte[])) {
            throw new IllegalArgumentException(sLPConfig.formatMessage("value_type_error", new Object[0]));
        }
    }

    static String unescapeAttributeString(String string, boolean bl) throws ServiceLocationException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                if (n2 > n - 2) {
                    throw new ServiceLocationException(2, "nonterminating_escape", new Object[]{string});
                }
                c = ServiceLocationAttribute.unescapeChar(string.substring(++n2, n2 + 2));
                ++n2;
                if (!ServiceLocationAttribute.canEscape(c)) {
                    throw new ServiceLocationException(2, "char_not_reserved_attr", new Object[]{new Character(c), string});
                }
            } else if (ServiceLocationAttribute.canEscape(c)) {
                throw new ServiceLocationException(2, "reserved_not_escaped", new Object[]{new Character(c)});
            }
            if (bl && BAD_TAG_CHARS.indexOf(c) != -1) {
                throw new ServiceLocationException(2, "bad_id_char", new Object[]{Integer.toHexString(c)});
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    static char unescapeChar(String string) throws ServiceLocationException {
        int n = 0;
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServiceLocationException(2, "not_a_character", new Object[]{string});
        }
        String string2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray = null;
        by = (byte)(n & 0xFF);
        by2 = (byte)(n >> 8 & 0xFF);
        by3 = (byte)(n >> 16 & 0xFF);
        by4 = (byte)(n >> 24 & 0xFF);
        if (by4 != 0) {
            byArray = new byte[3];
            byArray[3] = by4;
            byArray[2] = by3;
            byArray[1] = by2;
            byArray[0] = by;
        } else if (by3 != 0) {
            byArray = new byte[3];
            byArray[2] = by3;
            byArray[1] = by2;
            byArray[0] = by;
        } else if (by2 != 0) {
            byArray = new byte[2];
            byArray[1] = by2;
            byArray[0] = by;
        } else {
            byArray = new byte[]{by};
        }
        try {
            string2 = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.assert(false, "no_utf8", new Object[0]);
        }
        int n2 = string2.length();
        if (string2.length() > 1) {
            throw new ServiceLocationException(2, "more_than_one", new Object[]{string});
        }
        return n2 == 1 ? string2.charAt(0) : (char)'\u0000';
    }

    protected void verifyValueTypes(Vector vector, boolean bl) {
        SLPConfig sLPConfig = SLPConfig.getSLPConfig();
        int n = vector.size();
        Class<?> clazz = null;
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            ServiceLocationAttribute.typeCheckValue(e);
            if (n2 == 0) {
                clazz = e.getClass();
            } else if (!clazz.equals(e.getClass()) && !bl) {
                throw new IllegalArgumentException(sLPConfig.formatMessage("type_mismatch_error", new Object[0]));
            }
            if (!bl && n2 != 0 && e instanceof Boolean) {
                throw new IllegalArgumentException(sLPConfig.formatMessage("multivalued_boolean", new Object[0]));
            }
            if (e instanceof byte[]) {
                vector.setElementAt(new Opaque((byte[])e), n2);
            } else if (e instanceof String) {
                String string = (String)e;
                try {
                    Object object = ServiceLocationAttribute.evaluate(string);
                    if (!(object instanceof String)) {
                        vector.setElementAt(String.valueOf(string) + " ", n2);
                    }
                }
                catch (ServiceLocationException serviceLocationException) {}
            }
            ++n2;
        }
    }
}

