/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.ActiveDiscoverer;
import com.sun.slp.AuthBlock;
import com.sun.slp.CDAAdvert;
import com.sun.slp.CSrvDereg;
import com.sun.slp.CSrvReg;
import com.sun.slp.DATable;
import com.sun.slp.SLPConfig;
import com.sun.slp.SSrvDereg;
import com.sun.slp.SSrvReg;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceTable;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.Transact;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;

abstract class ServerDATable
extends DATable {
    protected static ActiveDiscoverer activeDiscoverer = null;
    protected Hashtable forwardRegs = new Hashtable();
    private static Object readyLock = new Object();
    protected Hashtable daSPIsHash = new Hashtable();

    ServerDATable() {
    }

    private void forwardRegOrDereg(InetAddress inetAddress, SrvLocMsg srvLocMsg) {
        Object object;
        SrvLocHeader srvLocHeader;
        block19: {
            Object object2;
            Object object3;
            srvLocHeader = srvLocMsg.getHeader();
            if (DATable.conf.isLocalHostSource(inetAddress)) {
                return;
            }
            if (DATable.conf.getHasSecurity()) {
                object = (LinkedList)this.daSPIsHash.get(inetAddress);
                if (object == null) {
                    return;
                }
                object3 = null;
                if (srvLocMsg instanceof SSrvReg) {
                    object3 = ((SSrvReg)srvLocMsg).URLSignature;
                } else if (srvLocMsg instanceof SSrvDereg) {
                    object3 = ((SSrvDereg)srvLocMsg).URLSignature;
                } else {
                    return;
                }
                object2 = ((Hashtable)object3).elements();
                while (object2.hasMoreElements()) {
                    AuthBlock authBlock = (AuthBlock)object2.nextElement();
                    boolean bl = false;
                    int n = 0;
                    while (n < ((LinkedList)object).size()) {
                        if (AuthBlock.checkEquiv((String)((LinkedList)object).get(n), authBlock)) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (bl) continue;
                    return;
                }
            }
            if (DATable.conf.traceDATraffic()) {
                DATable.conf.writeLog("sdat_forward", new Object[]{Integer.toHexString(srvLocHeader.xid), inetAddress});
            }
            object = null;
            try {
                if (srvLocMsg instanceof SSrvReg) {
                    object3 = (SSrvReg)srvLocMsg;
                    object = object2 = new CSrvReg(srvLocHeader.fresh, srvLocHeader.locale, ((SSrvReg)object3).URL, srvLocHeader.scopes, ((SSrvReg)object3).attrList, ((SSrvReg)object3).URLSignature, ((SSrvReg)object3).attrSignature);
                } else if (srvLocMsg instanceof SSrvDereg) {
                    object3 = (SSrvDereg)srvLocMsg;
                    object = object2 = new CSrvDereg(srvLocHeader.locale, ((SSrvDereg)object3).URL, srvLocHeader.scopes, ((SSrvDereg)object3).tags, ((SSrvDereg)object3).URLSignature);
                } else if (srvLocMsg instanceof CSrvReg) {
                    object = srvLocMsg;
                }
                object = Transact.transactTCPMsg(inetAddress, (SrvLocMsg)object, false);
            }
            catch (ServiceLocationException serviceLocationException) {
                if (!DATable.conf.traceDATraffic()) break block19;
                DATable.conf.writeLog("sdat_forward_exception", new Object[]{Integer.toHexString(srvLocHeader.xid), inetAddress, new Integer(serviceLocationException.getErrorCode()), serviceLocationException.getMessage()});
            }
        }
        if ((object == null || object.getErrorCode() != 0) && DATable.conf.traceDATraffic()) {
            DATable.conf.writeLog("sdat_forward_err", new Object[]{Integer.toHexString(srvLocHeader.xid), inetAddress, object == null ? "<null>" : Integer.toString(object.getErrorCode())});
        }
    }

    private void forwardRegistrations(ServiceURL serviceURL, Vector vector, long l, int n) {
        Object object;
        Serializable serializable;
        Object object2;
        SrvLocMsg srvLocMsg;
        try {
            Thread.currentThread();
            Thread.sleep(DATable.conf.getRandomWait());
        }
        catch (InterruptedException interruptedException) {}
        Enumeration enumeration = this.forwardRegs.elements();
        InetAddress inetAddress = null;
        String string = serviceURL.getHost();
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (DATable.conf.traceDrop() || DATable.conf.traceDATraffic()) {
                DATable.conf.writeLog("sdat_drop_fwd", new Object[]{string});
            }
            return;
        }
        ServiceTable serviceTable = null;
        try {
            serviceTable = ServiceTable.getServiceTable();
        }
        catch (ServiceLocationException serviceLocationException) {}
        Vector<SrvLocMsg> vector2 = new Vector<SrvLocMsg>();
        while (enumeration.hasMoreElements()) {
            SrvLocMsg srvLocMsg2 = (SrvLocMsg)enumeration.nextElement();
            ServiceURL serviceURL2 = srvLocMsg2 instanceof SSrvReg ? ((SSrvReg)srvLocMsg2).URL : ((CSrvReg)srvLocMsg2).URL;
            srvLocMsg = srvLocMsg2.getHeader();
            object2 = serviceTable.getServiceRecord(serviceURL2, ((SrvLocHeader)srvLocMsg).locale);
            if (object2 == null) {
                vector2.addElement(srvLocMsg2);
                continue;
            }
            serializable = (Vector)((SrvLocHeader)srvLocMsg).scopes.clone();
            DATable.filterScopes((Vector)serializable, vector, false);
            if (((Vector)serializable).size() <= 0) continue;
            if (srvLocMsg2 instanceof SSrvReg) {
                object = (SSrvReg)srvLocMsg2;
                ((SrvLocHeader)srvLocMsg).scopes = (Vector)((SrvLocHeader)srvLocMsg).scopes.clone();
                ((SSrvReg)object).attrList = (Vector)object2.getAttrList().clone();
                ((SSrvReg)object).URLSignature = object2.getURLSignature();
                ((SSrvReg)object).attrSignature = object2.getAttrSignature();
            }
            this.forwardRegOrDereg(inetAddress, srvLocMsg2);
        }
        int n2 = vector2.size();
        int n3 = 0;
        while (n3 < n2) {
            srvLocMsg = (SrvLocMsg)vector2.elementAt(n3);
            object2 = srvLocMsg.getHeader();
            serializable = srvLocMsg instanceof SSrvReg ? ((SSrvReg)srvLocMsg).URL : ((CSrvReg)srvLocMsg).URL;
            object = this.makeKey((ServiceURL)serializable, ((SrvLocHeader)object2).locale);
            this.forwardRegs.remove(object);
            ++n3;
        }
    }

    void forwardSAMessage(SrvLocMsg srvLocMsg, InetAddress inetAddress) throws ServiceLocationException {
        Object object;
        Object object2;
        SrvLocHeader srvLocHeader = srvLocMsg.getHeader();
        if (!DATable.conf.isLocalHostSource(inetAddress)) {
            return;
        }
        if (srvLocMsg instanceof SSrvReg || srvLocMsg instanceof CSrvReg) {
            object2 = srvLocMsg instanceof SSrvReg ? ((SSrvReg)srvLocMsg).URL : ((CSrvReg)srvLocMsg).URL;
            object = this.makeKey((ServiceURL)object2, srvLocHeader.locale);
            this.forwardRegs.put(object, srvLocMsg);
        } else {
            object2 = (SSrvDereg)srvLocMsg;
            if (((SSrvDereg)object2).tags == null) {
                object = this.makeKey(((SSrvDereg)object2).URL, srvLocHeader.locale);
                this.forwardRegs.remove(object);
            }
        }
        object2 = this.findDAScopes(srvLocHeader.scopes);
        object = (Vector)((Hashtable)object2).get("&&**^^UNICASTxxxKEY^^**&&");
        if (object == null) {
            return;
        }
        int n = ((Vector)object).size();
        int n2 = 0;
        while (n2 < n) {
            DATable.DARecord dARecord = (DATable.DARecord)((Vector)object).elementAt(n2);
            Vector vector = dARecord.daAddresses;
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                InetAddress inetAddress2 = (InetAddress)vector.elementAt(n4);
                if (!inetAddress.equals(inetAddress2)) {
                    this.forwardRegOrDereg(inetAddress2, srvLocMsg);
                }
                ++n4;
            }
            ++n2;
        }
    }

    static ServerDATable getServerDATable() throws ServiceLocationException {
        ServerDATable serverDATable = null;
        Object object = readyLock;
        synchronized (object) {
            if (DATable.daTable != null) {
                ServerDATable serverDATable2 = (ServerDATable)DATable.daTable;
                Object var3_3 = null;
                return serverDATable2;
            }
            DATable.conf = SLPConfig.getSLPConfig();
            DATable.daTable = DATable.linkAndInstantiateFromProp();
            serverDATable = (ServerDATable)DATable.daTable;
            Vector vector = new Vector();
            activeDiscoverer = new ActiveDiscoverer(2, serverDATable, vector, SLPConfig.getMulticastAddress());
            activeDiscoverer.start();
        }
        return serverDATable;
    }

    void handleAdvertIn(CDAAdvert cDAAdvert) {
        SrvLocHeader srvLocHeader = cDAAdvert.getHeader();
        if (cDAAdvert.isGoingDown()) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(cDAAdvert.URL.getHost());
            }
            catch (UnknownHostException unknownHostException) {
                DATable.conf.writeLog("unknown_da_address", new Object[]{cDAAdvert.URL.getHost()});
                return;
            }
            if (this.removeDA(inetAddress, srvLocHeader.scopes) && DATable.conf.traceDATraffic()) {
                DATable.conf.writeLog("sdat_delete_da", new Object[]{cDAAdvert.URL, srvLocHeader.scopes});
            }
        } else {
            long l;
            if (cDAAdvert.authBlock != null) {
                try {
                    AuthBlock.verifyAll(cDAAdvert.authBlock);
                }
                catch (ServiceLocationException serviceLocationException) {
                    if (DATable.conf.traceDrop()) {
                        DATable.conf.writeLog("sdat_daadvert_vrfy_failed", new Object[]{cDAAdvert.URL});
                    }
                    return;
                }
            }
            if ((l = this.recordNewDA(cDAAdvert.URL, srvLocHeader.scopes, cDAAdvert.timestamp, srvLocHeader.version, cDAAdvert.attrs, cDAAdvert.spis)) >= cDAAdvert.timestamp) {
                if (DATable.conf.traceDATraffic()) {
                    DATable.conf.writeLog("sdat_add_da_no_forward", new Object[]{cDAAdvert.URL, srvLocHeader.scopes, new Long(l)});
                }
                return;
            }
            if (DATable.conf.traceDATraffic()) {
                DATable.conf.writeLog("sdat_add_da", new Object[]{cDAAdvert.URL, srvLocHeader.scopes, new Long(cDAAdvert.timestamp)});
            }
            this.forwardRegistrations(cDAAdvert.URL, srvLocHeader.scopes, cDAAdvert.timestamp, srvLocHeader.version);
        }
    }

    private String makeKey(ServiceURL serviceURL, Locale locale) {
        return String.valueOf(serviceURL.toString()) + "/" + locale.toString();
    }

    abstract long recordNewDA(ServiceURL var1, Vector var2, long var3, int var5, Vector var6, String var7);

    abstract Hashtable returnMatchingDAs(String var1) throws ServiceLocationException;
}

