/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.SLPServerHeaderV2;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.SrvLocMsgImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

class SSrvTypeMsg
extends SrvLocMsgImpl {
    String namingAuthority = "";

    SSrvTypeMsg(SrvLocHeader srvLocHeader, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        super(srvLocHeader, 9);
        this.initialize(dataInputStream);
    }

    void initialize(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        SLPServerHeaderV2 sLPServerHeaderV2 = (SLPServerHeaderV2)this.getHeader();
        StringBuffer stringBuffer = new StringBuffer();
        sLPServerHeaderV2.parsePreviousRespondersIn(dataInputStream);
        this.namingAuthority = this.parseNamingAuthorityIn(sLPServerHeaderV2, dataInputStream, "UTF8");
        if (this.namingAuthority.equalsIgnoreCase("iana")) {
            throw new ServiceLocationException(2, "sstm_iana", new Object[0]);
        }
        sLPServerHeaderV2.parseScopesIn(dataInputStream);
        sLPServerHeaderV2.constructDescription("SrvTypeRqst", "           naming authority=``" + this.namingAuthority + "''\n");
    }

    SrvLocMsg makeReply(Vector vector) throws ServiceLocationException {
        SLPServerHeaderV2 sLPServerHeaderV2 = ((SLPServerHeaderV2)this.getHeader()).makeReplyHeader();
        sLPServerHeaderV2.iNumReplies = vector.size();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sLPServerHeaderV2.parseCommaSeparatedListOut(vector, byteArrayOutputStream);
        sLPServerHeaderV2.payload = byteArrayOutputStream.toByteArray();
        sLPServerHeaderV2.constructDescription("SrvTypeRply", "           types=``" + vector + "''\n");
        return sLPServerHeaderV2;
    }

    protected String parseNamingAuthorityIn(SrvLocHeader srvLocHeader, DataInputStream dataInputStream, String string) throws ServiceLocationException, IOException {
        int n = 0;
        n = srvLocHeader.getInt(dataInputStream);
        if (n == 0) {
            return "";
        }
        if (n == 65535) {
            return "*";
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        srvLocHeader.nbytes += n;
        String string2 = SrvLocHeader.getBytesString(byArray, string).toLowerCase();
        ServiceType.validateTypeComponent(string2);
        return string2;
    }
}

