/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.AuthBlock;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.SLPServerHeaderV2;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.SrvLocMsgImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class SSrvMsg
extends SrvLocMsgImpl {
    String serviceType = "";
    String query = "";
    String spi = "";

    protected SSrvMsg() {
    }

    SSrvMsg(SrvLocHeader srvLocHeader, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        super(srvLocHeader, 1);
        this.initialize(dataInputStream);
    }

    void initialize(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        SLPServerHeaderV2 sLPServerHeaderV2 = (SLPServerHeaderV2)this.getHeader();
        StringBuffer stringBuffer = new StringBuffer();
        sLPServerHeaderV2.parsePreviousRespondersIn(dataInputStream);
        sLPServerHeaderV2.getString(stringBuffer, dataInputStream);
        this.serviceType = stringBuffer.toString();
        if (this.serviceType.length() <= 0) {
            throw new ServiceLocationException(2, "srq_stype_missing", new Object[0]);
        }
        ServiceType serviceType = new ServiceType(this.serviceType);
        this.serviceType = serviceType.toString();
        sLPServerHeaderV2.getString(stringBuffer, dataInputStream);
        sLPServerHeaderV2.scopes = SrvLocHeader.parseCommaSeparatedListIn(stringBuffer.toString(), true);
        if (sLPServerHeaderV2.scopes.size() <= 0) {
            if (!serviceType.equals(Defaults.DA_SERVICE_TYPE) && !serviceType.equals(Defaults.SA_SERVICE_TYPE)) {
                throw new ServiceLocationException(2, "no_scope_vector", new Object[0]);
            }
        } else {
            SLPHeaderV2.unescapeScopeStrings(sLPServerHeaderV2.scopes);
            DATable.validateScopes(sLPServerHeaderV2.scopes, sLPServerHeaderV2.locale);
        }
        sLPServerHeaderV2.getString(stringBuffer, dataInputStream);
        this.query = stringBuffer.toString();
        sLPServerHeaderV2.getString(stringBuffer, dataInputStream);
        this.spi = stringBuffer.toString();
        sLPServerHeaderV2.constructDescription("SrvRqst", "        service type=``" + this.serviceType + "''\n" + "        query=``" + this.query + "''\n" + "        spi=``" + this.spi + "''");
    }

    SrvLocMsg makeReply(Hashtable hashtable, Hashtable hashtable2) throws ServiceLocationException {
        SLPServerHeaderV2 sLPServerHeaderV2 = ((SLPServerHeaderV2)this.getHeader()).makeReplyHeader();
        sLPServerHeaderV2.iNumReplies = hashtable.size();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = hashtable.size();
        String string = "\n";
        sLPServerHeaderV2.putInt(n, byteArrayOutputStream);
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object object;
            ServiceURL serviceURL = (ServiceURL)enumeration.nextElement();
            Hashtable<String, Object> hashtable3 = null;
            if (hashtable2 != null) {
                hashtable3 = (Hashtable<String, Object>)hashtable2.get(serviceURL);
                object = AuthBlock.getEquivalentAuth(this.spi, hashtable3);
                hashtable3 = null;
                if (object != null) {
                    hashtable3 = new Hashtable<String, Object>();
                    hashtable3.put(this.spi, object);
                }
                string = String.valueOf(string) + "         " + serviceURL.toString() + ": " + (hashtable3 != null ? ((AuthBlock)object).toString() : "No Auth Block\n");
            }
            if (!sLPServerHeaderV2.parseServiceURLOut(serviceURL, hashtable3 != null, hashtable3, byteArrayOutputStream, true)) {
                sLPServerHeaderV2.overflow = true;
                object = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                SrvLocHeader.putInteger(n2, byteArrayOutputStream);
                byteArrayOutputStream.write((byte[])object, 2, ((Object)object).length - 2);
                break;
            }
            ++n2;
        }
        sLPServerHeaderV2.payload = byteArrayOutputStream.toByteArray();
        sLPServerHeaderV2.constructDescription("SrvRply", "        service URLs=``" + hashtable + "''\n" + "        auth block=" + string + "\n");
        return sLPServerHeaderV2;
    }
}

